/**
 * RSSWebSpiderRobot
 * RSS Web񃍃{bg{
 */
package org.logical_paradox.rss.robot;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.TooManyListenersException;

import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSSubModuleIF;
import org.logical_paradox.rss.logging.RSSDebugLogWriter;
import org.logical_paradox.rss.logging.RSSLogWriter;
import org.logical_paradox.rss.robot.event.RSSWSAgentEvent;
import org.logical_paradox.rss.robot.event.RSSWSAgentListener;

public class RSSWebSpiderRobot implements RSSWSAgentListener, RSSSubModuleIF {
	private static final String RSS_SPIDER_CONF_PATH = "conf/rsswebspider.conf";

	private String RSSWSRobotKey = null;				// {bg̖O(Iɐ)
	protected RSSWebSpiderConfig cfg = null;			// {bgуG[WFg̐ݒf[^
	protected RSSWebNavigator navigator = null;			// oHirQ[^
	protected RSSWebSpiderAgent agents[] = null;		// TsȂG[WFgXbh

	protected int timeoutSec = 360000;					// ڑ^CAEgb(ftHg = 1)

	/**
	 * ftHgRXgN^
	 */
	public RSSWebSpiderRobot() {
	}

	/**
	 * {bgC֐
	 */
	public static void main( String[] args ) throws Exception {
		RSSWebSpiderRobot robot = new RSSWebSpiderRobot();

		try {
			robot.startModule();
		} catch( Exception e ) {
			System.err.println( "{bg̏Ɏs܂DOmFĂ" );
			RSSDebugLogWriter.write( e );
			System.exit(1);
		}
	}

	/**
	 * G[WFgXbh̃[vJnۂɌĂ΂R[obN
	 */
	public boolean AtTheBeginningOfAgentCallback( RSSWebSpiderAgent me ) {
		// oHirQ[^ŏ҂
		navigator.waitUntilEmpty();
/*
		synchronized( navigator ) {
			while( navigator.getQueueSize() == 0 ) {
				try {
					navigator.wait();			// ŏԂ̕ω҂킹
				} catch( InterruptedException e ) {
					// ҂ǂ߂ꍇ̏
					return false;
				}
			}
*/

		synchronized( navigator ) {
			// oHirQ[^̏Ԃωꍇ́C珈𑱍s
			// ̃Xbhėp
			try {
				String url = null;
				while( (url = navigator.getNextURL()) == null ) {
					navigator.wait();
				}
System.err.println( Thread.currentThread().getName() + " " + url );
				me.setup( url, timeoutSec );
			} catch( Exception e ) {
				return false;
			}
		}

		return true;
	}

	/**
	 * G[WFg̃XbhIꍇ̃R[obN\bh
	 * ăX^[gJnꂽꍇtrue,߂ꍇfalseԂ
	 */
	public boolean AtTheEndOfAgentCallback( RSSWebSpiderAgent me ) {
		return true;
	}

	/**
	 * {bg̏
	 */
	private void init() throws IOException, TooManyListenersException, IllegalArgumentException, RSSIllegalConfigException, IllegalObjectStateException {
		// ݒt@C̓ǂݍ݂Ɠě
		cfg = new RSSWebSpiderConfig( RSS_SPIDER_CONF_PATH );

		// OC^[̏
		RSSDebugLogWriter.setLogWriter(
				new RSSLogWriter( new FileOutputStream( "logs" + File.separator + cfg.getProperty( "DEBUG_TRACE_LOG_FILENAME" ), true ) )
		);
		RSSDebugLogWriter.setLoggingMode( cfg.getRobotSwDebugTraceLog() );
		RSSDebugLogWriter.enableEchoMode( false );
		RSSDebugLogWriter.write( "OC^[܂" );

		// oHirQ[^쐬
		navigator = RSSWebNavigator.getNavigator();
		navigator.enableLocalContentsMgr( true );
		RSSDebugLogWriter.write( "TirQ[^쐬܂" );


		RSSWSRobotKey = navigator.getRobotId();
		System.err.println( "Robot name : " + getRobotKey() );

		// w肳ꂽʂ̃G[WFgOɍ쐬[u
		int countOfAgents = cfg.getAgentsPerRobot();
		agents = new RSSWebSpiderAgent[ countOfAgents ];
		for( int i = 0; i < countOfAgents; i++ ) {
			agents[i] = new RSSWebSpiderAgent( this );
			agents[i].addRSSWSAgentListener( this );
		}
		RSSDebugLogWriter.write( agents.length + "̒TG[WFg쐬܂" );

		timeoutSec = cfg.getAgentConnectionTimeoutSec();

		String[] contentTypes = cfg.getAllowedContentType();
		StringBuffer logLine = new StringBuffer();
		logLine.append( "WΏۃRec^Cv: " );

		if( contentTypes == null || contentTypes.length == 0 ) {
			logLine.append( "S" );
		} else {
			for( int i = 0; i < contentTypes.length; i++ ) {
				logLine.append( contentTypes[i] + " " );
			}
		}
		RSSDebugLogWriter.write( logLine.toString() );
		System.err.println( logLine.toString() );
	}

	/**
	 * ̃{bgconfigurationԂ
	 */
	public RSSWebSpiderConfig getSpiderConfig() {
		return cfg;
	}

	public String getRobotKey() {
		return RSSWSRobotKey;
	}

	public synchronized void onConnect( RSSWSAgentEvent e ) {
		RSSDebugLogWriter.write( "ڑ܂" );
		RSSWebSpiderAgent src = (RSSWebSpiderAgent)e.getSource();

		// Cxg̏I
		e.destroy();
	}

	public void onClose( RSSWSAgentEvent e ) {
		RSSDebugLogWriter.write( "Rec̓ǂݍ݂܂" );
		RSSWebSpiderAgent src = (RSSWebSpiderAgent)e.getSource();
		try {
			// WebRecirQ[^֓]
			// Rec݂Ȃ(404 not found]Ȃ)ꍇŁCrobots.txtłȂꍇ͖
			if( e.getContents().getWebContents() != null || e.getContents().isRobotsRule() == true ) {
				RSSDebugLogWriter.write( "Rec̓eo^Ă܂" );
				navigator.sendContents( e.getContents() );
			} else {
				RSSDebugLogWriter.write( "̗RɂCRec̓o^XLbv܂" );
			}

			// \[X̉̂ŁCoHirQ[^ɃbZ[W𑗐M
			// ̃irQ[^̏ԕω҂őҋ@ĂSẴG[WFgN
			RSSDebugLogWriter.write( "[JTL[:" + navigator.getQueueSize() );

			synchronized( navigator ) {
				if( navigator.getQueueSize() > 0 ) {
					navigator.notifyAll();				// getNextURL() == nullŒ~ĂXbhN
				}
			}

		} catch( Exception ie ) {
			ie.printStackTrace();
		}

		// Cxg̏I
		e.destroy();
	}

	/**
	 * {bg̏I
	 * t@CiCUĂ΂
	 */
	public void close() throws RemoteException {
		navigator.close();
		navigator = null;
		RSSWSRobotKey = null;

		// SẴG[WFg~
		if( agents != null ) {
			for( int i = 0; i < agents.length; i++ ) {
				agents[i] = null;
			}
		}
	}

	public void finalize() throws RemoteException {
		close();
	}


	/**
	 * W[Rg[pC^[tF[X::
	 * W[Jn
	 */
	public void startModule() throws ModuleException {
		try {
			init();
			// XbhSX^[g
			for( int i = 0; i < agents.length; i++ ) {
				agents[i].start();
			}

		Date bgn = Calendar.getInstance( ).getTime( );
		System.err.println( "Jn: " + bgn.toString() );

			// oHirQ[^̏Ԃ܂ɒׂ鏈
			// IĂlqł΁CG[WFg~
			boolean exitf = true;
			int suscnt = 0;

			while( exitf ) {
				Thread.sleep( 500 );
				if( suscnt == 30 || navigator.isFinished() == true ) {
					// Sꍇ
					for( int i = 0; i < agents.length; i++ ) {
						// S̃XbhI
						agents[i].interrupt();
					}
					exitf = false;
				} else if( navigator.getQueueSize() == 0 && navigator.countSuspendedSites() > 0 ) {
					// [J̒TpURLL[ɂ͉ς܂ĂȂǁCT}̃TCgꍇ
					// Ƃ肠T}JE^AbvĂ
					// 莞Ԃo߂Ă󂪕ςȂꍇ́C߂ďI邽
					suscnt++;
					System.err.println( "T}̉񕜂҂Ă܂:" + suscnt );
				} else {
					// T}ȊǑŊĂȂꍇ
					suscnt = 0;
				}
			}

			// Xbh̑҂킹
			// SII
			for( int i = 0; i < agents.length; i++ ) {
				agents[i].join();
			}

			// I
			close();
			System.err.println( "done." );

		Date fin = Calendar.getInstance( ).getTime( );
		System.err.println( "I: " + fin.toString() );

			RSSDebugLogWriter.write( "T܂" );
		} catch( Exception e ) {
			throw new ModuleException( e );
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[ꎞ~
	 */
	public void suspendModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * ~Ă郂W[̎sĊJ
	 */
	public void continueModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[~
 	 * ̃\bhĂ΂ꂽꍇCW[͈Sȕ@ŏI
	 * IW[́CVCX^XȂƊJn邱Ƃ͂łȂ
	 */
	public void stopModule() throws ModuleException {
	}
}

// end of rss1test.java
