/**
 * RSSWebSpiderAgent
 * WebG[WFg
 */
package org.logical_paradox.rss.robot;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TooManyListenersException;

import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.http.RSSHttpResponse;
import org.logical_paradox.rss.http.RSSHttpURLConnection;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.logging.RSSDebugLogWriter;
import org.logical_paradox.rss.robot.event.RSSWSAgentEvent;
import org.logical_paradox.rss.robot.event.RSSWSAgentListener;

import HTTPClient.NVPair;


public class RSSWebSpiderAgent extends Thread {
	private RSSHttpURLConnection con = null;
	private String content = null;
	private RSSWSAgentListener eventListener = null;
	private boolean running = false;
	private RSSWebSpiderRobot robot = null;

	public RSSWebSpiderAgent( RSSWebSpiderRobot r ) {
		robot = r;
		running = false;
	}

	public boolean isRunning() {
		return running;
	}

	public void setup( String remoteHost, int timeoutSec ) throws MalformedURLException, IOException, TooManyListenersException {
		RSSDebugLogWriter.write( "Xbh̃ZbgAbvĂ܂" );

		// owb_̓o^
		NVPair[] nvp = {
				new NVPair( "User-Agent", robot.getSpiderConfig().getHttpUserAgent() ),
				new NVPair( "Cache-Control", "no-cache" )
		};

		URL dest = new URL( remoteHost );
/*
		if( dest.getProtocol().equals( "http" ) == false ) {
			throw new IOException();
		}
*/
		RSSHttpURLConnection c = new RSSHttpURLConnection( new URL( remoteHost ) );
		c.setDefaultHeaders( nvp );
		c.setTimeout( timeoutSec );
		try {
			c.removeModule( Class.forName( "HTTPClient.CookieModule" ) );
		} catch( Exception e ) {
		}
		con = c;

		RSSDebugLogWriter.write( "Xbh̃ZbgAbv܂" );
	}

	public String getRemoteHost() throws IllegalObjectStateException {
		if( con == null ) {
			throw new IllegalObjectStateException();
		}
		return con.getURL().toString();
	}

	public void run() {
		super.run();

		while( true ) {
			RSSDebugLogWriter.write( "XbhڑJn܂" );

			// ڑCxgs
			sendOnConnectEvent( new RSSWSAgentEvent( this ) );

			boolean rc = robot.AtTheBeginningOfAgentCallback( this );
			if( rc == false ) {
				// Xbh̊Jn𖞂ĂȂꍇ́CďI
				robot.AtTheEndOfAgentCallback( this );
				return;
			}

			running = true;
			RSSDebugLogWriter.write( "Xbhrun()Jn܂" );
			RSSDebugLogWriter.write( "URL: " + con.getURL().toString() );

			RSSHttpResponse res = null;
			try {
				res = new RSSHttpResponse( con.Get(), "8859_1" );			// I8859_1ɂĂ
				int responseCode = res.getResponseCode();

				if( robot.getSpiderConfig().isEnabledContentType( res.getHeader( "Content-Type" ) ) == false ) {
					// 擾łȂ^Cv̏ꍇ̓f[^̂Ă
					content = null;
				} else if( responseCode == java.net.HttpURLConnection.HTTP_OK ) {
					// Ƀy[W̎擾łꍇ
					RSSDebugLogWriter.write( "XbhRec̓ǂݍ݂n߂܂" );
					content = res.getText();
					RSSDebugLogWriter.write( "XbhڑĂ܂" );
				} else if(
					responseCode == java.net.HttpURLConnection.HTTP_MOVED_PERM ||
					responseCode == java.net.HttpURLConnection.HTTP_MOVED_TEMP
				) {
					// ]ꂽꍇ
					String forwardedTo = res.getHeader( "Location" );
					if( forwardedTo != null ) {
						System.err.println( "]:" + forwardedTo );
					}
				} else {
					// ȊȌꍇ
//					System.err.println( "(" + con.getResponseCode() + ") " + con.getURL() );
				}
			} catch( Exception e ) {
				// 炩̃G[ĐڑłȂ
				String errmsg = "failed";
				if( res != null ) {
					errmsg += "(" + res.getResponseCode() + ")";
				}
				errmsg += " : " + con.getURL().toString();

				System.err.println( errmsg );
				RSSDebugLogWriter.write( errmsg );

				content = null;
			} finally {

				// IԂɂ
				running = false;

				// ؒfCxgs
				RSSDebugLogWriter.write( "XbhonClose()Cxg𔭍sĂ܂" );
				try {
					sendOnCloseEvent( new RSSWSAgentEvent( this, new WebContents( res, content ) ) );
				} catch( Exception e ) {
				}
			}
		}
	}

	/**
	 * CxgXi[̓o^
	 */
	public void addRSSWSAgentListener( RSSWSAgentListener listener ) throws TooManyListenersException {
		// CxgXi[1o^łȂ
		// ̃CxgXi[o^悤Ƃꍇ́CO𓊂
		if( eventListener != null ) {
			throw new TooManyListenersException();
		}
		eventListener = listener;
	}

	/**
	 * CxgXi[̍폜
	 */
	public void removeRSSWSAgentListener() {
		eventListener = null;
	}

	/**
	 * ڑCxg̑M
	 */
	public void sendOnConnectEvent( RSSWSAgentEvent e ) {
		eventListener.onConnect( e );
	}

	/**
	 * ؒfCxg̑M
	 */
	public void sendOnCloseEvent( RSSWSAgentEvent e ) {
		eventListener.onClose( e );
	}
}

// end of RSSWebSpiderAgent.java
