/**
 * RSSNavigatorConfig
 * RSS WebTirQ[^[̐ݒēNX
 */
package org.logical_paradox.rss.robot;

import java.io.IOException;

import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.dsync.RSSSyncConfig;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;

public class RSSNavigatorConfig extends RSSSyncConfig {
	public static final boolean NAVIMODE_DISTRIB = true;		// UVXeƂē삳
	public static final boolean NAVIMODE_STANDALONE = false;	// X^hA[œ삳

	private String cfgHttpUserAgent = "RSS-agent/1b (http://www.logical-paradox.org/)";
	private String cfgRoutingNodeSelectorURL = null;
	private int cfgKeepLocks = 300;
	private int cfgKeepUrls = 1600;
	private int cfgUnTracedURLSendCnt = 20;
	private int cfgDebugTraceURLs = 50;
	private boolean cfgNaviSwRunLog = false;
	private String cfgNavigatorRunLogFilename = "rssnavigator.run.log";
	private boolean cfgNavigationMode = true;
	private boolean cfgEchoURL = true;
	private String cfgRoot = "";
	private long cfgSiteLockExpire = 1000 * 60 * 5;
	private RoutingAlgorithm cfgRoutingAlgorithm = null;
	private int cfgNavigatorSyncInterval = 10000;

	/**
	 * RXgN^
	 */
	public RSSNavigatorConfig( String fn ) throws IOException, RSSIllegalConfigException {
		super( fn );
		String errmsg = checkResourceVariables();
		if( errmsg != null ) {
			throw new RSSIllegalConfigException( errmsg );
		}
	}

	public String getRoutingNodeSelectorURL() {
		return cfgRoutingNodeSelectorURL;
	}
	public boolean getEchoURL() {
		return cfgEchoURL;
	}
	public String getHttpUserAgent() {
		return cfgHttpUserAgent;
	}
	public int getDebugTraceURLs() {
		return cfgDebugTraceURLs;
	}
	public int getKeepLocks() {
		return cfgKeepLocks;
	}
	public int getKeepUrls() {
		return cfgKeepUrls;
	}
	public int getUnTracedURLSendCnt() {
		return cfgUnTracedURLSendCnt;
	}
	public boolean getNaviSwRunLog() {
		return cfgNaviSwRunLog;
	}
	public String getNavigatorRunLogFilename() {
		return cfgNavigatorRunLogFilename;
	}
	public boolean getNavigationMode() {
		return cfgNavigationMode;
	}
	public String getRoot() {
		return cfgRoot;
	}
	public long getSiteLockExpire() {
		return cfgSiteLockExpire;
	}
	public RoutingAlgorithm getRoutingAlgorithm() {
		return cfgRoutingAlgorithm;
	}
	public int getNavigatorSyncInterval() {
		return cfgNavigatorSyncInterval;
	}

	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		String errmsg = super.checkResourceVariables();			// f[cfg̃`FbN\bhĂяo

		if( getProperty( "HTTP_USER_AGENT" ) != null ) {
			cfgHttpUserAgent = getProperty( "HTTP_USER_AGENT" );
		}

		cfgRoutingNodeSelectorURL = getProperty( "RSS_ROUTING_NODE_SELECTOR_URL" );
		if( cfgRoutingNodeSelectorURL == null ) {
			errmsg += "RSS_ROUTING_NODE_SELECTOR_URLw肳Ă܂\n";
		}

		try {
			cfgKeepLocks = getPropertyAsInt( "KEEP_LOCKS" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "KEEP_LOCKS̒lsł\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgKeepUrls = getPropertyAsInt( "KEEP_URLS" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "KEEP_URLS̒lsł\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgUnTracedURLSendCnt = getPropertyAsInt( "UNTRACED_URL_SEND_CNT" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "UNTRACED_URL_SEND_CNT̒lsł\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgDebugTraceURLs = getPropertyAsInt( "DEBUG_TRACE_URLS" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "DEBUG_TRACE_URLS̒lsł";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgNaviSwRunLog = getPropertyAsBool( "NAVI_SW_RUNLOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "NAVI_SW_RUNLOG̒lsł";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgEchoURL = getPropertyAsBool( "ECHO_URL" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "ECHO_URL̒lsł";
		} catch( RSSNullValueException ne ) {}

		cfgNavigatorRunLogFilename = getProperty( "NAVIGATOR_RUNLOG_FILENAME" );
		String cfgSNavigationMode = getProperty( "NAVIGATION_MODE" );
		if( cfgSNavigationMode == null || cfgSNavigationMode.trim().toUpperCase().equals( "DISTRIB" ) ) {
			cfgNavigationMode = NAVIMODE_DISTRIB;
		} else if( cfgSNavigationMode.trim().toUpperCase().equals( "STANDALONE" ) ) {
			cfgNavigationMode = NAVIMODE_STANDALONE;
		} else {
			errmsg += "NAVIGATION_MODEsł";
		}

		cfgRoot = getProperty( "ROOT" );

		try {
			cfgSiteLockExpire = getPropertyAsInt( "SITELOCK_EXPIRE" );
			if( cfgSiteLockExpire < 0 ) {
				// bN̗L̓}CiXɐݒ肷邱Ƃ͂łȂ
				throw new RSSValueFormatException();
			}
		} catch( RSSValueFormatException vfe ) {
			errmsg += "SITELOCK_EXPIRE0ȏɐݒ肵Ă\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgNavigatorSyncInterval = getPropertyAsInt( "NAVIGATOR_SYNC_INTERVAL" );
			if( cfgNavigatorSyncInterval < 500 ) {
				// ̃^C~O0.5bȉɐݒ肷邱Ƃ͂łȂ
				throw new RSSValueFormatException();
			}
		} catch( RSSValueFormatException vfe ) {
			errmsg += "NAVIGATOR_SYNC_INTERVAL500ȏɐݒ肵Ă\n";
		} catch( RSSNullValueException ne ) {}

		try {
			String algorithm = getProperty( "ROUTING_ALGORITHM" );
			cfgRoutingAlgorithm = (RoutingAlgorithm)Class.forName( algorithm ).newInstance();
		} catch( Exception e ) {
			errmsg += "ROUTING_ALGORITHMŒ`ꂽoHASÝC݂܂\n";
		}

		if( errmsg.trim().length() > 0 ) {
			return errmsg;
		} else {
			return null;
		}
	}
}

// end of RSSNavigatorConfig.java
