/**
 * DbmysqlContentsAccessor
 * mysqlf[^x[XRecXg[WƂĎgpANZXC^[tF[X
 */
package org.logical_paradox.rss.rcm.accessor;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.logical_paradox.rss.IllegalObjectStateException;

public class DbmysqlContentsAccessor implements ContentsAccessor {
	private boolean activeFlag = false;				// ̃C^[tF[XڑԂ
	private Connection con = null;
	private Statement st = null;

	/**
	 * ftHgRXgN^
	 */
	public DbmysqlContentsAccessor() {
		activeFlag = false;
	}

	/**
	 * RecXg[WƐڑ
	 */
	public synchronized void open( String openstr ) throws IllegalArgumentException {
		if( isActive() ) {
			// ɃI[vĂ
			return;
		}

		if( openstr == null || openstr.trim().length() == 0 ) {
			throw new IllegalArgumentException();
		}

		// JDBChCõ[hƐڑ
		try {
			Class.forName( "com.mysql.jdbc.Driver" ).newInstance();
			con = DriverManager.getConnection( openstr );
			st = con.createStatement();

			activeFlag = true;
		} catch( Exception e ) {
			throw new IllegalArgumentException( e.getMessage() );
		}
	}

	/**
	 * Reco^
	 */
	public void regist( String url, String contents ) throws IllegalObjectStateException {
		if( isActive() == false || url == null || url.trim().length() == 0 ) {
			throw new IllegalObjectStateException();
		}

		String sql = "insert into contents values(null,'" + url + "','" + contents + "')";
		try {
			st.execute( sql );
		} catch( SQLException se ) {
			// o^łȂ
		}
	}

	/**
	 * Rec폜
	 */
	public void unregist( String url ) throws IllegalObjectStateException {
		if( isActive() == false || url == null || url.trim().length() == 0 ) {
			throw new IllegalObjectStateException();
		}

		String sql = "delete from contents where url='" + url + "'";
		try {
			st.execute( sql );
		} catch( SQLException se ) {
			// 폜łȂ
		}
	}

	/**
	 * SẴRec폜
	 */
	public void unregistAll() throws IllegalObjectStateException {
		if( isActive() == false ) {
			throw new IllegalObjectStateException();
		}

		String sql = "delete from contents";
		try {
			st.execute( sql );
		} catch( SQLException se ) {
			// 폜łȂ
		}
	}

	/**
	 * wURLɑΉRecԂ
	 */
	public String find( String url ) throws IllegalObjectStateException {
		if( isActive() == false || url == null || url.trim().length() == 0 ) {
			throw new IllegalObjectStateException();
		}

		String sql = "select * from contents where url='" + url + "'";
		String contents = null;

		try {
			ResultSet rs = st.executeQuery( sql );
			if( rs.next() ) {
				contents = rs.getString(1);
			}
		} catch( SQLException se ) {
			// G[̏ꍇ͉Ȃ
		}
		return contents;
	}

	/**
	 * Xg[WƂ̐ڑ
	 */
	public synchronized void close() throws IllegalObjectStateException {
		if( isActive() == false ) {
			throw new IllegalObjectStateException( "connector has already been closed" );
		}

		try {
			// Xe[gg̃N[Y
			if( st != null ) {
				st.close();
				st = null;
			}
			// DBڑ̃N[Y
			if( con != null ) {
				con.close();
				con = null;
			}

			activeFlag = false;
		} catch( SQLException se ) {
			throw new IllegalObjectStateException( se.getMessage() );
		}
	}

	/**
	 * ̃C^[tF[Xgp\ǂԂ
	 */
	protected boolean isActive() {
		return activeFlag;
	}

	/**
	 * t@CiCU
	 */
	public void finalize() {
		try {
			close();
		} catch( Exception e ) {
			// ȂDłȂ
		}
	}
}

// end of DbmysqlContentsAccessor.java
