/**
 * StandAloneContentsRegister
 * X^hA[ł̃Reco^NCAgIuWFNg
 * PɃf[^x[XɃReco^邾̑㕨
 */
package org.logical_paradox.rss.rcm;

import org.logical_paradox.rss.logging.RSSDebugLogWriter;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.DbContentsAccessorFactory;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class StandAloneContentsRegister implements ContentsRegister {
	private ContentsAccessor accessor = null;			// RecɃANZX邽߂̃C^[tF[X
	private boolean activeFlag = false;
	private final String rkey;

	/**
	 * ftHgRXgN^
	 */
	public StandAloneContentsRegister( String connstr ) {
		try {
			DbContentsAccessorFactory f = new DbContentsAccessorFactory( connstr );
			accessor = f.getAccessor();
			activeFlag = true;
		} catch( Exception e ) {
			activeFlag = false;
			RSSDebugLogWriter.write( "RecANZX̂߂̃C^[tF[X擾ł܂ł" );
		} finally {
			rkey = "localreg_" + RandomKeyGenerator.getUniqKey();
		}
	}

	/**
	 * RecWX^Ԃ
	 */
	public String getRegisterName() {
		return rkey;
	}
	/**
	 * Reco^
	 */
	public void registContents( String url, String contents ) {
		if( url == null || url.trim().length() == 0 || contents == null || contents.trim().length() == 0 ) {
			return;
		}
		if( isActive() == false ) {
			return;
		}
		try {
			accessor.regist( url, contents );
		} catch( Exception e ) {
		}
	}

	/**
	 * Reco^Ă邩ǂԂ
	 * o^ĂꍇtrueCo^ĂȂꍇfalse
	 */
	public boolean isRegistered( String url ) {
		if( isActive() == false ) {
			return false;
		}
		try {
			return accessor.find( url ) != null ? true : false;
		} catch( Exception e ) {
			return false;
		}
	}

	/**
	 * Rec̓o^
	 */
	public void unregistContents( String url ) {
		if( isActive() == false ) {
			return;
		}
		try {
			accessor.unregist( url );
		} catch( Exception e ) {
		}
	}

	/**
	 * o^ĂSẴRec폜
	 */
	public void unregistAll() {
		if( isActive() == false ) {
			return;
		}
		try {
			accessor.unregistAll();
		} catch( Exception e ) {
		}
	}

	/**
	 * ̃WX^I/FLǂԂ
	 */
	private boolean isActive() {
		return activeFlag;
	}
}
// end of StandAloneContentsRegister.java
