/**
 * RSSCMServConfig
 * RecǗVXepRtBO
 */
package org.logical_paradox.rss.rcm;
import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

public class RSSRCMConfig extends RSSConfig {
	private boolean cfgRCMSwRunLog = false;
	private String cfgRCMRunLogFilename = "rssrcm.run.log";
	private String cfgRSSContentsMngrService = "";
	private int cfgInitialRegisterServices = 5;
	private int cfgMaxRegisterServices = 15;
	private String cfgRegisterServicePrefix = "";
	private int cfgAgentsPerRegister = 2;
	private int cfgRegistQueueSize = 262144;
	private int cfgContentsSendingInterval = 500;
	private int cfgContentsSendingScale = 20;
	private String cfgContentsAccessorFactory = "";
	private String cfgContentsConnStr = "";
	private String cfgRSSDistributedServiceRegistry;

	private ContentsQueue q = null;


	/**
	 * RXgN^
	 */
	public RSSRCMConfig( String fn ) throws IOException, RSSIllegalConfigException {
		super( fn );
		String errmsg = checkResourceVariables();
		if( errmsg != null ) {
			throw new RSSIllegalConfigException( errmsg );
		}
	}

	public boolean getRCMSwRunLog() {
		return cfgRCMSwRunLog;
	}
	public String getRCMRunLogFilename() {
		return cfgRCMRunLogFilename;
	}
	public String getRSSContentsMngrService() {
		return cfgRSSContentsMngrService;
	}
	public int getInitialRegisterServices() {
		return cfgInitialRegisterServices;
	}
	public int getMaxRegisterServices() {
		return cfgMaxRegisterServices;
	}
	public String getRegisterServicePrefix() {
		return cfgRegisterServicePrefix;
	}
	public int getAgentsPerRegister() {
		return cfgAgentsPerRegister;
	}
	public int getRegistQueueSize() {
		return cfgRegistQueueSize;
	}
	public int getContentsSendingInterval() {
		return cfgContentsSendingInterval;
	}
	public int getContentsSendingScale() {
		return cfgContentsSendingScale;
	}
	public String getContentsAccessorFactory() {
		return cfgContentsAccessorFactory;
	}
	public String getContentsConnStr() {
		return cfgContentsConnStr;
	}
	public String getRSSDistributedServiceRegistry() {
		return cfgRSSDistributedServiceRegistry;
	}
	public ContentsQueue getContentsQueue() {
		return q;
	}

	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		String errmsg = "";

		try {
			cfgRCMSwRunLog = getPropertyAsBool( "RCM_SW_RUNLOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "RCM_SW_RUNLOGsł\n";
		} catch( RSSNullValueException ne ) {}

		if( getProperty( "RCM_RUNLOG_FILENAME" ) != null ) {
			cfgRCMRunLogFilename = getProperty( "RCM_RUNLOG_FILENAME" );
		}
		cfgRSSContentsMngrService = getProperty( "RSS_CONTENTS_MNGR_SERVICE" );
		if( cfgRSSContentsMngrService == null ) {
			errmsg += "RSS_CONTENTS_MNGR_SERVICEݒ肳Ă܂\n";
		}
		cfgRSSDistributedServiceRegistry = getProperty( "RSS_DSR" );
		if( cfgRSSDistributedServiceRegistry == null ) {
			errmsg += "RSS_DSRݒ肳Ă܂\n";
		}

		try {
			cfgInitialRegisterServices = getPropertyAsInt( "INITIAL_REGISTER_SERVICES" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "INITIAL_REGISTER_SERVICESsł\n";
		} catch( RSSNullValueException ne ) {}
		try {
			cfgMaxRegisterServices = getPropertyAsInt( "MAX_REGISTER_SERVICES" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "MAX_REGISTER_SERVICESsł\n";
		} catch( RSSNullValueException ne ) {}

		cfgRegisterServicePrefix = getProperty( "REGISTER_SERVICE_PREFIX" );
		if( cfgRegisterServicePrefix == null ) {
			errmsg += "REGISTER_SERVICE_PREFIXݒ肳Ă܂\n";
		}
		try {
			cfgAgentsPerRegister = getPropertyAsInt( "AGENTS_PER_REGISTER" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "AGENTS_PER_REGISTERsł\n";
		} catch( RSSNullValueException ne ) {}
		try {
			cfgRegistQueueSize = getPropertyAsInt( "REGIST_QUEUE_SIZE" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "REGIST_QUEUE_SIZEsł\n";
		} catch( RSSNullValueException ne ) {}
		try {
			cfgContentsSendingInterval = getPropertyAsInt( "CONTENTS_SENDING_INTERVAL" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "CONTENTS_SENDING_INTERVALsł\n";
		} catch( RSSNullValueException ne ) {}
		try {
			cfgContentsSendingScale = getPropertyAsInt( "CONTENTS_SENDING_SCALE" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "CONTENTS_SENDING_SCALEsł\n";
		} catch( RSSNullValueException ne ) {}

		cfgContentsAccessorFactory = getProperty( "CONTENTS_ACCESSOR_FACTORY" );
		if( cfgContentsAccessorFactory == null ) {
			errmsg += "CONTENTS_ACCESSOR_FACTORYݒ肳Ă܂\n";
		}
		if( getProperty( "CONTENTS_CONNSTR" ) != null ) {
			cfgContentsConnStr = getProperty( "CONTENTS_CONNSTR" );
		}

		if( errmsg.trim().length() > 0 ) {
			return errmsg;
		}

		// RecL[ĂȂȂ΁CŐ
		if( getRegistQueueSize() > 0 ) {
			q = new ContentsQueue( getRegistQueueSize() );
		}
		return null;
	}
}

// end of RSRCMConfig.java
