/**
 * RSSContentsMngrServiceImpl
 * RSS/1b RecǗVXe̎
 */
package org.logical_paradox.rss.rcm;

import java.io.File;
import java.io.FileOutputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModuleIF;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.logging.RSSLogWriter;
import org.logical_paradox.rss.logging.RSSRCMLogWriter;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory;

public class RSSContentsMngrServiceImpl extends UnicastRemoteObject implements RSSContentsMngrService,RSSSubModuleIF {
	public static String RCM_CONF_FILENAME = "conf/rssrcm.conf";	// Ot@C

	private RSSDistributedServiceRegistry DistributedServiceRegistry = null;				// [gT[rXIT[o[̃T[rX
	private String rcmServiceName = null;							// ̃T[rX̖

	private RSSRCMConfig cfg = null;								// RtBO
	private int registerServiceCnt = 1;								// o^WX^T[rX̒ʔ
	private ContentsAccessorFactory accessorFactory = null;			// RecANZT̐q
	private Vector registers = null;								// RecWX^T[rX(L[:T[rX/l:)

	private int registerIdx = 0;									// ɕԂׂWX^T[rX̒ʂԍ

	/**
	 * ftHgRXgN^
	 */
	public RSSContentsMngrServiceImpl() throws RemoteException {
	}

	/**
	 * YT[rX
	 */
	protected void init( RSSRCMConfig conf ) throws Exception {
		cfg = conf;
		registers = new Vector();

		RSSRCMLogWriter.setLogWriter( new RSSLogWriter(
						new FileOutputStream( "logs" + File.separator + cfg.getRCMRunLogFilename(), true ) ) );
		RSSRCMLogWriter.setLoggingMode( cfg.getRCMSwRunLog() );
		RSSRCMLogWriter.write( "OC^[܂" );

		// RecANZT̃t@NgNX[h
		accessorFactory = (ContentsAccessorFactory)Class.forName( cfg.getContentsAccessorFactory() ).newInstance();
		accessorFactory.setDefaultFactoryParam( cfg.getContentsConnStr() );

		RSSRCMLogWriter.write( "RecANZTt@Ng[" + cfg.getContentsAccessorFactory() + "][h܂" );
		RSSRCMLogWriter.write( "[gRecǗVXe\Ă܂" );

		// ݒ肳ꂽ̃WX^T[rXOɍ쐬āCRMIWXgɓo^Ă
		for( int i = 0; i < cfg.getInitialRegisterServices(); i++ ) {
			createRegister();
		}
	}

	/**
	 * RXgN^
	 */
	public RSSContentsMngrServiceImpl( RSSRCMConfig conf ) throws Exception {
		init( conf );
	}

	/**
	 * VReco^T[rXǉ
	 * WX^T[rX̃NX́CKX^uexportł^CvłȂ΂ȂȂ
	 * ɗRȂꍇCRCMContentsRegisterImplgp邱
	 */
	protected void createRegister() throws Exception {
		String serviceName = cfg.getRegisterServicePrefix() + registerServiceCnt;
		RCMContentsRegister r = new RCMContentsRegisterImpl( serviceName, cfg, accessorFactory.getAccessor() );
		registers.addElement( r );

		Naming.bind( serviceName, r );

		RSSRCMLogWriter.write( "WX^T[rX[" + serviceName + "]ǉ܂" );
		registerServiceCnt++;
	}

	/**
	 * o^ĂReco^T[rXXg
	 */
	public String[] getRegisterNames() throws RemoteException {
		return null;
	}

	/**
	 * svɂȂReco^T[rX폜
	 */
	public void gc() throws RemoteException {
	}

	/**
	 * Reco^T[rX̃C^[tF[X擾
	 */
	public ContentsRegister getRegister() throws RemoteException {
		if( registerIdx >= registers.size() ) {
			registerIdx = 0;
		}

		ContentsRegister r = (ContentsRegister)registers.elementAt( registerIdx++ );
		RSSRCMLogWriter.write( "WX^T[rX[" + r.getRegisterName() + "]I܂" );
		return r;
	}

	/**
	 * T[rXo^p\bh
	 */
	public static void main( String[] args ) throws Exception {
		// RecǗVXẽCX^X𐶐
		RSSContentsMngrServiceImpl server = new RSSContentsMngrServiceImpl();

		server.startModule();
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[Jn
	 */
	public void startModule() throws ModuleException {
		try {
			init( new RSSRCMConfig( RCM_CONF_FILENAME ) );

			// RecǗVXe[gT[rXIT[o[֓o^
			// o^C̃T[rX̖OՂD
			DistributedServiceRegistry = (RSSDistributedServiceRegistry)Naming.lookup( cfg.getRSSDistributedServiceRegistry() );
			rcmServiceName = DistributedServiceRegistry.bind( RSSDistributedServiceRegistry.RSS_SERVID_REMOTE_CONTENTS_MGR, this );

			// RecǗVXegRMIWXgɓo^
			Naming.bind( rcmServiceName, this );
		} catch( Exception e ) {
			throw new ModuleException( e );
		}

		RSSRCMLogWriter.write( "[gRecǗVXeJn܂" );
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[ꎞ~
	 */
	public void suspendModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * ~Ă郂W[̎sĊJ
	 */
	public void continueModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[~
 	 * ̃\bhĂ΂ꂽꍇCW[͈Sȕ@ŏI
	 * IW[́CVCX^XȂƊJn邱Ƃ͂łȂ
	 */
	public void stopModule() throws ModuleException {
	}
}

// end of RSSContentsMngrServiceImpl.java
