/**
 * RSSLogWriter
 * OC^[̊NX
 * ޓeʂɃTuNX쐬Ď
 */
package org.logical_paradox.rss.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;


public class RSSLogWriter {
	protected boolean loggingMode = true;
	protected boolean outToStdErr = true;
	protected OutputStream of = null;
	protected PrintWriter p = null;

	/**
	 * RXgN^
	 */
	public RSSLogWriter( OutputStream o ) {
		of = o;
		p = new PrintWriter( o );
	}

	public synchronized void write( Exception e ) {
		Date now = Calendar.getInstance( ).getTime( );
		String today = now.toString( );

		if( outToStdErr == true ) {
			System.err.print( today + " " );
			System.err.println( e.getMessage() );
			e.printStackTrace( System.err );
		}

		if( p != null && loggingMode == true ) {
			p.print( today + " " );
			p.println( e.getMessage() );

			p.print( today + " " );
			e.printStackTrace( p );
		}
	}

	public synchronized void write( String log ) {
		Date now = Calendar.getInstance( ).getTime( );
		String today = now.toString( );

		if( outToStdErr == true ) {
			System.err.print( today + " " );
			System.err.println( log );
		}

		// o͗p̃Xg[ݒ肳Ăꍇ̓O
		if( p != null && loggingMode == true ) {
			p.print( today + " " );
			p.println( log );
			p.flush();
		}
	}

	public void setLoggingMode( boolean m ) {
		loggingMode = m;
	}

	public void enableEchoMode( boolean m ) {
		outToStdErr = m;
	}
}

// end of RSSLogWriter.java
