/**
 * RSSLCAgent
 * [JRecǗVXẽG[WFg
 * ̃G[WFgvÓC̃G[WFgƏLCXbhœ삷
 */
package org.logical_paradox.rss.lcmgr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class RSSLCAgent extends Thread {
	private RSSLCConfig lcfg = null;
	private RSSLocalContentsMgr mgr = null;

	protected RSSLCAgent( RSSLCConfig c, RSSLocalContentsMgr m ) {
		lcfg = c;
		mgr = m;
	}

	/**
	 * I
	 */
	public void done() {
		this.interrupt();
	}

	/**
	 * XbhƂē삷镔
	 */
	public void run() {
		try {
			while( true ) {
				// ׂKȃ^C~OŁC[J̃RecLbVfo
				sleep( lcfg.getContentsSendingInterval() );

				int pSendScale = lcfg.getContentsSendingScale();
				if( lcfg.runningStatus == false ) {
					// T~̏ꍇCⓚpœ]
					pSendScale = 0;
				}
				sendContents( pSendScale );

				synchronized( lcfg.fileEntries ) {
//System.err.println( "Gg:" + lcfg.fileEntries.size() );
					if( lcfg.fileEntries.size() < RSSLocalContentsMgr.MAX_FILECACHE_SIZE && lcfg.runningStatus == false ) {
						// ]ʁC̃t@CȉɃLbVt@CȂ
						// TĊJ
						lcfg.runningStatus = true;
						lcfg.logger.write( " LbVtbV܂DTĊJ܂ " );
						synchronized( mgr ) {
							mgr.notifyAll();
						}
					}
				}
			}
		} catch( InterruptedException e ) {
			// 炩̗RŒ~ꍇ
			// SẴRec[g̃VXe֓]
			try {
				lcfg.logger.write( "G[WFg~MM܂" );
				sendContents( 0 );
			} catch( IOException ie0 ) {}
		} catch( IOException ie ) {
		}
	}

	/**
	 * [JɕۊǂĂRecC[g̃RecǗVXe֓]
	 * Ɋi[Ă̂珇ɓ]
	 *
	 * {IɃLbV̓Ɋi[Ă̂]D
	 * ɉ݂ȂꍇCxt@C烁ɓǂݍŁCꂩ]
	 * ]āCLbVp̃1t@C(1y[W)̃TCŶق傫ꍇC
	 * y[W]邱Ƃ͂łȂ(dl)D
	 *
	 * ɂ̃LbVɑ݂󋵉ŁCt@CLbV
	 * [hłȂꍇĈقDIɓ]dg݂ɂȂĂ邽߁C
	 * ǂ̓󂭂܂ł̃t@C̓[hȂ(󂯂Γ])
	 */
	protected void sendContents( int numberOfContents ) throws IOException {
//System.err.println( "MJn܂:" + lcfg.memCache.size() );

		LocalContents c = null;
		boolean exitf = numberOfContents == 0 ? true : false;

		while( numberOfContents > 0 || exitf == true ) {
			numberOfContents--;
//System.err.println( "MĂ܂:" + numberOfContents );
			synchronized( lcfg.memCache ) {
				if( lcfg.memCache.size() == 0 ) {
					// 1RecĂȂꍇ
					// t@C珑o
					if( restoreFromLocalCache( RSSLocalContentsMgr.RESTORE_CNT_FROM_LCACHE ) > 0 ) {
						// 1ȏǂݍ݂ł̂ŁCx̃[v蒼
						numberOfContents++;
						continue;
					} else {
						// 烍[hłȂꍇ
						// ƂẮC
						// (1) {ɃLbVt@C݂Ȃ
						// (2) Kvȋ󂫃Ȃ
						// 2_
						// ɂĂCMpłԂł͂Ȃ̂ŏI
						exitf = false;
						break;
					}

				} else {
					// ɃRecĂꍇ
//System.err.println( "ɓǂݍ݂܂" );
					c = (LocalContents)lcfg.memCache.removeFirst();		// 擪̂̂擾
					lcfg.memCacheSize -= c.getContents().length();		// oTCYɂ

					// t@C1ǂŁCɓWJ
					// WJꂽt@C͕KvȂ̂ŁC폜Ă܂Ă悢
					restoreFromLocalCache();
				}
			}
			if( c != null ) {
				lcfg.logger.write( c.getURL() + "RecǗVXe֓]Ă܂" );
				// [g̃RecǗVXe֓]
				lcfg.cr.registContents( c.getURL(), c.getContents() );
				lcfg.logger.write( c.getURL() + "RecǗVXe֓]܂" );
			}
		}
//System.err.println( "Ƃ肠[vI" );
	}

	/**
	 * [J̃t@CVXeɕۑĂLbVt@Cw萔ǂݍ
	 * ɓWJ
 	 * WJł邾̋󂫗eʂȂꍇC̃t@CĂ݂
	 * ʁCςWJłȂꍇ0Ԃ
	 * WJłꍇCWJłTCYԂ
	 */
	private int restoreFromLocalCache( int files ) throws IOException {
		final int IM_RETRY_COUNT = 16;			// 荞݂ɎsꍇɃgC

		int ls = 0;
		int failureCnt = 0;
		CacheFileEntry cachef = null;

		while( files > 0 && failureCnt < IM_RETRY_COUNT ) {
			files--;

			synchronized( lcfg.fileEntries ) {
				if( lcfg.fileEntries.size() == 0 ) {
					return 0;
				}
				cachef = (CacheFileEntry)lcfg.fileEntries.getFirst();
				if( cachef.size() > (RSSLocalContentsMgr.MAX_MEMCACHE_SIZE - lcfg.memCacheSize) ) {
					failureCnt++;
					continue;
				}

				// 荞߂Ȃ̂ŁC폜Ă
				lcfg.fileEntries.removeFirst();
			}

			// LbVt@C̓ǂݍ
			File f = new File( cachef.getFileName() );
			BufferedReader bf = new BufferedReader( new FileReader( f ) );
			String contents = null;
			String linebuf = null;
			while( (linebuf = bf.readLine()) != null ) {
				contents += linebuf + "\n";
			}

			// Sǂݍ񂾂̂ŁCt@C폜
			bf.close();
			bf = null;
			f.delete();

			// ǂݍ񂾃Recf[^CɓWJ
			LocalContents c = new LocalContents( cachef.getURL(), contents );
			lcfg.memCache.add( c );
			lcfg.memCacheSize += contents.length();

			lcfg.logger.write( "LbVt@C[" + cachef.getFileName() + "]폜܂" );
			lcfg.logger.write( "c胁:" + (RSSLocalContentsMgr.MAX_MEMCACHE_SIZE - lcfg.memCacheSize) + "bytes" );
		}

		return ls;
	}
	// L֐̈
	// Ȃ̏ꍇ́C1ǂݍ݂sȂȂ
	private int restoreFromLocalCache() throws IOException {
		return restoreFromLocalCache( 1 );
	}
}

// end of RSSLCAgent.java
