/**
 * WebContents
 * T[o[_E[hĂEFuRecۗL邽߂̃IuWFNg
 */
package org.logical_paradox.rss.http;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;

import org.logical_paradox.rss.IllegalObjectStateException;


public class WebContents {
	protected RSSHttpResponse res = null;
	protected String contents = null;
	protected LinkedList filters = new LinkedList();
	protected boolean robotstxtFlag = false;

	/**
	 * RXgN^
	 */
	public WebContents() {
	}

	public WebContents( RSSHttpResponse c, String ct ) throws IllegalObjectStateException, IOException {
		if( c.getResponseCode() < 0 ) {
			throw new IllegalObjectStateException( "HttpURLConnection object has no content" );
		}
		res = c;
		contents = ct;

		// URLrobots.txtĂꍇ̓tOZbg
		if( c.getURL().toString().indexOf( "robots.txt" ) >= 0 ) {
			robotstxtFlag = true;
		}
	}

	/**
	 * robots.txtǂԂ
	 */
	public boolean isRobotsRule() {
		return robotstxtFlag;
	}

	/**
	 * RecϊtB^ǉ
	 */
	public void addContentsFilter( ContentsFilter f ) {
		filters.add( f );
	}

	/**
	 * RecϊtB^폜
	 */
	public void removeContentsFilter( ContentsFilter f ) {
		filters.remove( f );
	}

	/**
	 * HTTPڑIuWFNgA^b`
	 */
	public void attachResponse( RSSHttpResponse c ) throws IllegalObjectStateException, IOException {
		if( c.getResponseCode() < 0 ) {
			throw new IllegalObjectStateException( "HttpURLConnection object has no content" );
		}
		res = c;
	}

	/**
	 * Recf[^Yt
	 */
	public void attachContents( String c ) {
		contents = new String( c );
	}

	/**
	 * RecԂ
	 */
	public String getWebContents() {
		if( contents == null ) {
			return contents;
		}
		String src = new String( contents );

		// ̃IuWFNgɃWCgꂽSẴRecϊtB^ʂ
		for( int i = 0; i < filters.size(); i++ ) {
			ContentsFilter f = (ContentsFilter)filters.get( i );
			src = new String( f.filter( src ) );
		}

		return src;
	}

	/**
	 * X|XR[hԂ
	 */
	public int getResponseCode() throws IllegalObjectStateException, IOException {
		if( res == null ) {
			throw new IllegalObjectStateException( "no instance of HttpURLConnection" );
		}

		return res.getResponseCode();
	}

	/**
	 * X|XbZ[WԂ
	 */
	public String getResponseMessage() throws IllegalObjectStateException, IOException {
		if( res == null ) {
			throw new IllegalObjectStateException( "no instance of HttpURLConnection" );
		}

		return res.getResponseMessage();
	}

	/**
	 * Rec̑傫Ԃ
	 */
	public int getContentLength() throws IllegalObjectStateException {
		if( res == null ) {
			throw new IllegalObjectStateException( "no instance of HttpURLConnection" );
		}

		return res.getContentLength();
	}

	/**
	 * Rec̎ނԂ
	 */
	public String getContentType() throws IllegalObjectStateException {
		if( res == null ) {
			throw new IllegalObjectStateException( "no instance of HttpURLConnection" );
		}

		return res.getContentType();
	}

	/**
	 * Weby[WURLԂ
	 */
	public URL getURL() throws IllegalObjectStateException {
		if( res == null ) {
			throw new IllegalObjectStateException( "no instance of HttpURLConnection" );
		}

		return res.getURL();
	}

	/**
 	 * I
	 */
	public void close() {
		if( res != null ) {
			res = null;
		}
		if( contents != null ) {
			contents = null;
		} 
	}

	/**
	 * t@CiCU
	 */
	public void finalize() {
		close();
	}
}

// end of WebContents.java
