/**
 * RSSHttpResponse
 * RSS/1bpHTTPX|XIuWFNg
 * HTTPClientNXZbǵCHTTPResponsebsOĂ܂
 */
package org.logical_paradox.rss.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;

public class RSSHttpResponse {
	private String contentAsString;
	private HTTPResponse _resp;
	private String _encodingType;


	public RSSHttpResponse( HTTPResponse r, String encodingType ) {
		_resp = r;
		_encodingType = encodingType;
	}

	public int getResponseCode() {
		int rc = 0;
		try {
			rc = _resp.getStatusCode();
		} catch( Exception e ) {
			rc = -1;
		}
		return rc;
	}

	public String getResponseMessage() {
		String s = null;
		try {
			s = _resp.getReasonLine();
		} catch( Exception e ) {
			s = null;
		}

		return s;
	}

	public String getText() throws IOException, ModuleException, ParseException {
		if( contentAsString == null ) {
			InputStream in = _resp.getInputStream();
			if( in == null ) {
				return new String( "" );
			}

			// HTML\[Xunicodeɕϊǂݎ
			BufferedReader reader = new BufferedReader( new InputStreamReader( in, "JISAutoDetect" ) );
			String line = "";
			StringBuffer buf = new StringBuffer();
			while( (line = reader.readLine()) != null ) {
				buf.append( line );
			}
			reader.close();

			// ŌɎw肳ꂽGR[fBOɕϊďo͂
			contentAsString = new String( buf.toString() );//.getBytes( "8859_1" ), _encodingType );
		}

		return contentAsString;
	}

	public int getContentLength() {
		if( contentAsString == null ) {
			return 0;
		} else {
			return contentAsString.length();
		}
	}

	public String getContentType() {
		String s = null;
		try {
			s = _resp.getHeader( "Content-Type" );
		} catch( Exception e ) {
			s = null;
		}

		return s;
	}

	public URL getEffectiveURL() {
		URL u = null;
		try {
			u = _resp.getEffectiveURI().toURL();
		} catch( Exception e ) {
			u = null;
		}
		return u;
	}

	public URL getURL() {
		URL u = null;
		try {
			u = _resp.getOriginalURI().toURL();
		} catch( Exception e ) {
			u = null;
		}
		return u;
	}

	public Enumeration getHeaderKeys() {
		Enumeration e = null;
		try {
			e = _resp.listHeaders();
		} catch( Exception ioe ) {
			e = null;
		}
		return e;
	}

	public String getHeader( String key ) {
		String s = null;
		try {
			s = _resp.getHeader( key );
		} catch( Exception e ) {
			s = null;
		}
		return s;
	}
}

// end of RSSHttpResponse.java
