/**
 * HREFCollector
 * AJ[^OHREF擾郆[eBeBNX
 */
package org.logical_paradox.rss.http;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class HREFCollector {
	/**
	 * AJ[擾
	 */
	public static Vector collect( String contents ) throws NoIndexException {
		ParserGetter gtr = new ParserGetter();
		AnchorCollectionCallback cb = new AnchorCollectionCallback();

		byte[] b = contents.getBytes();

		if( b == null ) {
			return null;
		}

		InputStreamReader ir = new InputStreamReader( new ByteArrayInputStream( b ) );

		// HTMLhLg̉͏
		// GR[fBO͊֌WȂ̂Ŗݒ
		// encoding𖳎ȂݒɂꍇCf[^\[XƓGR[fBOœǂݍނ悤
		// InputStreamReaderݒ肷邱

		try {
			gtr.getParser().parse( ir, cb, true );
		} catch( IOException ioe ) {
			return null;
		}

		return cb.getAnchors();
	}

	/**
	 * w肳ꂽAJ[SĐ΃pXɕϊ
	 */
	public static Vector getAnchorsAsABSPath( URL u, Vector a ) {
		if( a == null || u == null ) {
			return null;
		}

		// URLgݗĂ
		// URĽƂāCURLNXgp
		// ꍇCURL͖
		Vector anchors = new Vector();
		for( int i = 0; i < a.size(); i++ ) {
			try {
				String absoluteURL = new URL( u, (String)a.elementAt(i) ).toString();

				// vgRhttp݂̂Ɍ肷
				if(
					absoluteURL.startsWith( "http" ) == true &&
					absoluteURL.startsWith( "https" ) == false
				) {
					anchors.addElement( absoluteURL );
				}
			} catch( MalformedURLException e ) {}
		}
		return anchors;
	}
}

// end of HREFCollector.java
