/**
 * SyncQueue
 * pbP[W
 * ̂߂̏񂪊i[CǗIuWFNg
 */
package org.logical_paradox.rss.dsync;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class SyncQueue {
	public static final int SYNCQUEUE_SIZE = 65536;					// pbP[W̗e(vf)
	private int packageSize;
	private Hashtable buf = new Hashtable();

	/*
	 * ftHgRXgN^
	 */
	public SyncQueue() {
		packageSize = SYNCQUEUE_SIZE;
	}
	public SyncQueue( int p ) {
		packageSize = p;
	}

	/*
	 * R}hǉ
	 */
	public void add( SyncCommand o ) throws SyncQueueException {
//System.err.println( o.getObject().toString() + "" + o.getFrom() + "" + o.getTo() + "ɑM\" );
		if( buf.size() >= packageSize ) {
			throw new SyncQueueException();
		}

		// R}hi[鏈
		// ₷悤ɁCʂɐĊi[Ă
		Hashtable oSet = (Hashtable)buf.get( (String)o.getTo() );
		if( oSet == null ) {
			oSet = new Hashtable();
		}

		oSet.put( o.getObject().toString(), o );
		buf.put( o.getTo(), oSet );
	}

	/*
	 * SĂ̗vfo
	 */
	public SyncCommand[] getAll() {
		ArrayList commands = new ArrayList();

		synchronized( buf ) {
			Iterator i = buf.values().iterator();
			while( i.hasNext() ) {
				Hashtable commandsToAnNode = (Hashtable)i.next();
				commands.addAll( commandsToAnNode.values() );
			}
		}

		return (SyncCommand[])commands.toArray( new SyncCommand[0] );
	}

	/*
	 * ɈĂR}ho
	 * of[^͍폜
	 */
	public SyncCommand[] get( String myname ) {
		Hashtable oSet = (Hashtable)buf.remove( myname );
		if( oSet == null ) {
			// ĂɉZbgĂȂ
			return new SyncCommand[0];
		}

		Vector dic = new Vector( oSet.values() );
		return (SyncCommand[])dic.toArray( new SyncCommand[0] );
	}

	/*
	 * Xgɒǉ
	 * ǉ̍ہCd̂Sč폜
	 * x̎dg݂ł́Cem[h͒̃m[hȊOǗȂD
	 * ʏ킠m[hɐڑ鉺ʃm[h́C100𒴂邱ƂȂ(}Vp[̊֌WŖۂ)
	 * ܂Chashɂ錟͂ȂȂł邱ƂC̃ASYŖȂƎvD
	 * 
	 * \z郊XN
	 * Eʃm[h̐ɒ[ɑȂꍇ
	 * Exɓ]鍷̐CɑȂꍇ
	 * EsynchronizedubN
	 */
	public SyncCommand[] add( SyncCommand[] o ) {
		ArrayList rejectedCommands = new ArrayList();

		for( int ci = 0; ci < o.length; ci++ ) {
//System.err.println( o[ci].getObject().toString() + "ɂĒׂĂ܂" );
			synchronized( buf ) {
				Iterator i = buf.values().iterator();
				boolean commandDuplicated = false;

				SyncCommand command = null;
				Hashtable commands = null;

				while( i.hasNext() ) {
					commands = (Hashtable)i.next();
					command = (SyncCommand)commands.get( o[ci].getObject().toString() );
					if( command != null ) {
						// 
						commandDuplicated = true;
						break;
					}
				}

				if( commandDuplicated ) {
					switch( o[ci].getType() ) {
						case SyncCommand.COMMAND_LOCK:
						case SyncCommand.COMMAND_FORWARD_URL:
							// ΏۂƂȂR}hɑ݂ꍇ́C폜߂ɕϊ
//		System.err.println( "폜߂ɕϊ܂" );
							o[ci].reverse();
							String to = o[ci].getTo();
							String from = o[ci].getFrom();
							o[ci].setTo( from );					// Ƃ֖߂
							rejectedCommands.add( o[ci] );
							break;

						case SyncCommand.COMMAND_UNLOCK:
						case SyncCommand.COMMAND_UNFORWARD_URL:
							// ΏۂƂȂR}hɑ݂ĂꍇC
							// 폜ĐV̂ǉ
							commands.remove( o[ci].getObject().toString() );
//		System.err.println( "폜܂: " + o[ci].getObject().toString() );
							break;
						default:
//		System.err.println( "ȃR}hw肳܂" );
					}
				} else {
					// ΏۂƂȂR}h܂݂ĂȂꍇCR[h쐬
					Hashtable h = (Hashtable)buf.get( o[ci].getTo() );
					if( h == null ) {
						h = new Hashtable();
					}
					h.put( o[ci].getObject().toString(), o[ci] );
					buf.put( o[ci].getTo(), h );
//System.err.println( "O[" + o[ci].getObject().toString() + "]œo^܂" );
//System.err.println( " = " + o[ci].getTo() );
				}
			}
		}

		return (SyncCommand[])rejectedCommands.toArray( new SyncCommand[0] );
	}

	/*
	 * w肳ꂽR}h폜
	 */
	public void remove( SyncCommand command ) {
		synchronized( buf ) {
			Hashtable oSet = (Hashtable)buf.remove( command.getTo() );
			if( oSet != null ) {
				// ꍇ̓Xg폜Ċi[Ȃ
				oSet.remove( command.getObject().toString() );
				buf.put( command.getTo(), oSet );
			}
		}
	}

	/*
	 * wm[hɑ΂R}hSč폜
	 */
	public void clear( String nk ) {
		synchronized( buf ) {
			Hashtable commandsOfTheNode = (Hashtable)buf.get( nk );
			if( commandsOfTheNode != null ) {
				commandsOfTheNode.clear();
				buf.remove( commandsOfTheNode );
			}
		}
	}

	/*
	 * S폜
	 */
	public void clear() {
		synchronized( buf ) {
			Iterator i = buf.values().iterator();
			while( i.hasNext() ) {
				Hashtable h = (Hashtable)i.next();
				h.clear();
			}

			buf.clear();
		}
	}
}

// end of SyncQueue.java
