/*
 * SyncCommand
 * i[ĂIuWFNgǂ̂悤ɈLqIuWFNg
 */
package org.logical_paradox.rss.dsync;

public class SyncCommand implements java.io.Serializable {
	public static final int COMMAND_LOCK = 1;				// bN擾
	public static final int COMMAND_UNLOCK = -1;			// bN
	public static final int COMMAND_FORWARD_URL = 3;		// URL̓]
	public static final int COMMAND_UNFORWARD_URL = -3;		// URL̓]

	private Object _o = null;								// ̃R}hɊ֘AtĂIuWFNg
	private int _commandType = 0;							// ̃R}h̃^Cv
	private String _from;									// M
	private String _to;										// M

	/*
	 * ftHgRXgN^
	 * 񉻂߂ۂɕKvɂȂ
	 */
	public SyncCommand() {
	}
	/*
	 * RXgN^
	 */
	public SyncCommand( Object o, int type, String from, String to ) throws IllegalArgumentException {
		// R}h̎ނmF
		// R}hǉꍇ́C̔pR[hǉ邱
		if(
			type != COMMAND_LOCK && 
			type != COMMAND_UNLOCK && 
			type != COMMAND_FORWARD_URL &&
			type != COMMAND_UNFORWARD_URL
		) {
			throw new IllegalArgumentException( "command typesł" );
		}

		setObject( o );
		_commandType = type;

		_to = to;
		_from = from;
	}

	public String toString() {
		StringBuffer bf = new StringBuffer();
		bf.append( "SYC_" );

		switch( _commandType ) {
			case COMMAND_LOCK:
				bf.append( "LO" );
				break;

			case COMMAND_UNLOCK:
				bf.append( "UL" );
				break;

			case COMMAND_FORWARD_URL:
				bf.append( "FU" );
				break;

			case COMMAND_UNFORWARD_URL:
				bf.append( "UF" );
				break;

			default:
				bf.append( "ND" );
		}

		bf.append( _o.toString() );

		return bf.toString();
	}

	/*
	 * R}h̓]tɂ
	 */
	public void reverse() {
		_commandType = 0 - _commandType;
	}

	/*
	 * o^ĂIuWFNgԂ
	 */
	public Object getObject() {
		return _o;
	}
	public void setObject( Object o ) throws IllegalArgumentException {
		if( o instanceof java.io.Serializable == false ) {
			throw new IllegalArgumentException( "o^悤ƂIuWFNgjava.io.SerializableC^[tF[XĂ܂" );
		}
		_o = o;
	}

	/*
	 * R}h̎ނԂ
	 */
	public int getType() {
		return _commandType;
	}
	public void setType( int type ) {
		_commandType = type;
	}

	/*
	 * MԂ
	 */
	public String getFrom() {
		return _from;
	}
	public void setFrom( String from ) {
		_from = from;
	}

	/*
	 * MԂ
	 */
	public String getTo() {
		return _to;
	}
	public void setTo( String to ) {
		_to = to;
	}
}

// end of SyncCommand.java
