/**
 * RSSSyncDaemon
 * RSŜm[hœ삷Cxf[
 */
package org.logical_paradox.rss.dsync;

import java.util.TooManyListenersException;

import org.logical_paradox.rss.dsync.event.DelayedSyncEvent;
import org.logical_paradox.rss.dsync.event.DelayedSyncEventListener;
import org.logical_paradox.rss.logging.RSSLogWriter;

public class RSSSyncDaemon extends Thread {
	public static final int SYNCD_ERROR_LIMIT = 5;		// G[̋e

	private RSSSyncInterface syncIF;					// C^[tF[X
	private RSSSyncConfig syncdConfig;					// ݒt@C
	private RSSLogWriter logWriter = null;				// OC^[
	private SyncQueue syncq = null;						// L[
	protected int errorCount = 0;						// G[A
	private boolean loop = true;

	private String nodeId;								// ̒xf[zuĂm[hID

	private DelayedSyncEventListener eventListener;			// CxgXi[

	/*
	 * RXgN^
	 */
	public RSSSyncDaemon( RSSSyncConfig conf, RSSSyncInterface si ) throws Exception {
		syncIF = si;
		syncdConfig = conf;

		syncq = new SyncQueue( syncdConfig.getSyncQueueSize() );

		nodeId = si.getNodeId();
	}

	/*
	 * CxgXi[ǉ(Xi[1ǉ邱ƂłȂ)
	 */
	public void addListener( DelayedSyncEventListener listener ) throws TooManyListenersException {
		if( eventListener != null ) {
			throw new TooManyListenersException( "Xi[͒ǉłȂ̂ŁCx폜Kv܂" );
		}
		eventListener = listener;
	}
	/*
	 * CxgXi[폜
	 */
	public void removeListener() {
		if( eventListener != null ) {
			eventListener = null;
		}
	}

	/*
	 * OC^[ǉ
	 */
	public void setLogWriter( RSSLogWriter writer ) {
		logWriter = writer;
	}
	/*
	 * OC^[
	 */
	public void removeLogWriter() {
		logWriter = null;
	}

	/*
	 * Xbh̃C\bh
	 */
	public void run() {
		write( "xf[Jn܂" );
		try {
			while( loop ) {
				sleep( syncdConfig.getSyncInterval() );

				// ̓]ƎM
				SyncCommand[] receivedElements = sync();
				if( receivedElements != null ) {
					errorCount = 0;
					// MR}h̃nhĂяo
					handleAllEvents( receivedElements );
				} else if( errorCount >= SYNCD_ERROR_LIMIT ) {
					loop = false;
				}
			}
			write( "G[w񐔘AĔ߁Cf[~܂" );
			done();
		} catch( InterruptedException intrexp ) {
			write( "f[ɑ΂~߂M܂" );
			done();
		}
	}

	/*
	 * Oo
	 */
	protected void write( String ls ) {
		if( logWriter != null ) {
			logWriter.write( ls );
		}
	}

	/*
	 * O瓯f[~
	 */
	public void shutdown() {
		loop = false;
	}

	/*
	 * f[~
	 */
	protected void done() {
		write( "f[~܂" );
		removeLogWriter();
	}

	/*
	 * f[ɑ΂ăR}hGg[
	 */
	public void add( SyncCommand command ) throws SyncQueueException {
		try {
			if( command.getTo() == null ) {
				// 悪w肳ĂȂꍇCC^[tF[Xڑ̃m[hID擾ăZbg
				command.setTo( syncIF.getParentNodeId() );
			}
			if( command.getFrom() == null ) {
				// Mw肳ĂȂꍇCC^[tF[Xڑ̃m[hID擾ăZbg
				command.setFrom( getNodeId() );
			}
			syncq.add( command );
		} catch( Exception e ) {
			throw new SyncQueueException( e.getMessage() );
		}
	}

	/*
	 * w̃R}h𓯊L[폜
	 */
	public void remove( SyncCommand command ) {
		syncq.remove( command );
	}

	/*
	 * 
	 * 炩ߐݒ肳ꂽC^[tF[XāĈƂ
	 */
	public SyncCommand[] sync() {
		SyncCommand[] e = null;

		try {
			syncIF.sync( syncq.getAll() );
			syncq.clear();
			e = syncIF.getSyncData();

			if( e != null && e.length > 0 ) {
				write( e.length + "̓񂪖܂" );
			}
		} catch( Exception exp ) {
			errorCount++;
			write( "̑MɃG[܂:" );
			exp.printStackTrace();
		}

		return e;
	}
	public String getNodeId() {
		return nodeId;
	}
	protected void handleAllEvents( SyncCommand[] commands ) {
		if( eventListener == null ) {
			// CxgXi[o^ĂȂ̂ŁCȂ
			return;
		}
		for( int cnt = 0; cnt < commands.length; cnt++ ) {
			DelayedSyncEvent eventObject = new DelayedSyncEvent( this, commands[cnt] );
			switch( commands[cnt].getType() ) {
				case SyncCommand.COMMAND_LOCK:
					eventListener.onLock( eventObject );
					break;

				case SyncCommand.COMMAND_UNLOCK:
					eventListener.onUnlock( eventObject );
					break;

				case SyncCommand.COMMAND_FORWARD_URL:
					eventListener.onForwardURL( eventObject );
					break;

				case SyncCommand.COMMAND_UNFORWARD_URL:
					eventListener.onUnforwardURL( eventObject );
					break;

				default:
					write( "w肳ꂽR}hĂ܂: " + eventObject.getCommand().toString() );
			}
		}
	}
}

// end of RSSSyncDaemon.java
