/**
 * RSSSyncConfig
 * T|[gIuWFNg̐ݒt@CIuWFNg
 */
package org.logical_paradox.rss.dsync;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

public class RSSSyncConfig extends RSSConfig {
	protected int cfgSyncInterval;								// Ԋu
	protected int cfgSyncQueueSize;								// L[TCY

	/*
	 * RXgN^
	 */
	public RSSSyncConfig( String str ) throws IOException, RSSIllegalConfigException {
		super( str );
	}
	public int getSyncInterval() {
		if( cfgSyncInterval <= 0 ) {
			cfgSyncInterval = 500;
		}
		return cfgSyncInterval;
	}
	public int getSyncQueueSize() {
		if( cfgSyncQueueSize <= 0 ) {
			cfgSyncQueueSize = 200;
		}
		return cfgSyncQueueSize;
	}


	protected String checkResourceVariables() {
		StringBuffer errmsg = new StringBuffer();

		try {
			cfgSyncInterval = getPropertyAsInt( "SYNC_INTERVAL" );
		} catch( RSSValueFormatException vfe ) {
			errmsg.append( "SYNC_INTERVAL̒lsł" );
		} catch( RSSNullValueException ne ) {}

		try {
			cfgSyncQueueSize = getPropertyAsInt( "SYNC_QUEUE_SIZE" );
		} catch( RSSValueFormatException vfe ) {
			errmsg.append( "SYNC_QUEUE_SIZE̒lsł" );
		} catch( RSSNullValueException ne ) {}

		return errmsg.toString();
	}

}

// end of RSSSyncConfig.java
