/*
 * ServiceList
 * T[rX̂̃Xg
 */
package org.logical_paradox.rss.dsr;

import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Iterator;

import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

public class ServiceList {
	protected final Hashtable list;								// T[rX̃Xg
	protected final ServiceBindingAlgorithm bindingAlgorithm;	// T[rX蓖Ă̂߂̃ASY

	/*
	 * RXgN^
	 */
	public ServiceList( ServiceBindingAlgorithm ba ) {
		list = new Hashtable();
		bindingAlgorithm = ba;
	}
	public ServiceList( Hashtable org, ServiceBindingAlgorithm ba ) {
		list = org;
		bindingAlgorithm = ba;
	}

	// I\ȃ[gT[rXǉ
	public void add( String name, Remote stub ) {
		list.put( name, stub );
	}

	// I\ȃ[gT[rX폜(T[rX~ꍇȂ)
	public void remove( String name ) {
		list.remove( name );
	}

	// I\ȃ[gT[rX̃Ce[^Ԃ
	public Iterator iterator() {
		return list.keySet().iterator();
	}

	// i[ĂT[rX̃T[rXԂ
	public String[] serviceNames() {
		synchronized( list ) {
			return (String[])list.keySet().toArray( new String[0] );
		}
	}

	// w肳ꂽ̂̃T[rXo^Ă邩ǂԂ
	public boolean contains( String serviceName ) {
		return list.contains( serviceName );
	}

	// i[ĂT[rX̃XgCK؂ȃT[rX̃X^uIĕԂ
	public Remote getService() {
		String serviceName = bindingAlgorithm.getService( this );
		if( serviceName != null ) {
			return (Remote)list.get( serviceName );
		} else {
			return null;
		}
	}
}

// end of ServiceList.java
