/*
 * RSSDistributedServiceRegistryImpl
 * UT[rXWXg()
 */
package org.logical_paradox.rss.dsr;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;

import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModuleIF;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class RSSDistributedServiceRegistryImpl extends UnicastRemoteObject implements RSSDistributedServiceRegistry, RSSSubModuleIF {
	public static final String RSS_DSRCONF_PATH = "conf/rssdsr.conf";

	private RSSDSRConfig cfg = null;
	private final Hashtable remoteServices;
	private final Hashtable bindingAlgorithms;

	/*
	 * ftHgRXgN^
	 */
	public RSSDistributedServiceRegistryImpl() throws RemoteException {
		remoteServices = new Hashtable();
		bindingAlgorithms = new Hashtable();
	}

	/*
	 * [gT[rXo^
	 */
	public String bind( int type, Remote stub ) throws RemoteException {
		ServiceList slist = (ServiceList)remoteServices.get( new Integer( type ) );

		// ܂T[rXo^ĂȂꍇ
		// ServiceListIuWFNg쐬
		if( slist == null ) {
			slist = new ServiceList( getBindingAlgorithmByType( type ) );
		}

		String serviceName = getRemoteServiceName( type );
		slist.add( serviceName, stub );
		remoteServices.put( new Integer( type ), slist );

		System.err.println( "[gT[rXǉ܂: " + serviceName );

		return serviceName;
	}

	/*
	 * w肳ꂽT[rX̓o^
	 */
	public void unbind( int type, String nodeId ) throws RemoteException {
		ServiceList slist = (ServiceList)remoteServices.get( new Integer( type ) );

		if( slist == null || slist.contains( nodeId ) == false ) {
			// w肳ꂽT[rXo^ĂȂꍇ
			throw new RemoteException( "^Cv" + type + "ɑΉ郊[gT[rX́Co^Ă܂" );
		}

		slist.remove( nodeId );
	}

	/*
	 * w肳ꂽT[rXɑΉX^uԂ
	 */
	public Remote getService( int type ) throws RemoteException {
		ServiceList slist = (ServiceList)remoteServices.get( new Integer( type ) );

		if( slist == null ) {
			// w肳ꂽT[rXo^ĂȂꍇ
			throw new RemoteException( "^Cv" + type + "ɑΉ郊[gT[rX́C܂o^Ă܂" );
		}

		return slist.getService();
	}

	protected String getRemoteServiceName( int type ) throws IllegalArgumentException {
		String theKindOfService = null;

		switch( type ) {
			case RSS_SERVID_SERVICE_LOCATER:
				theKindOfService = "SLNODE/";
				break;

			case RSS_SERVID_ROUTING_NODE_CLIENT_FACTORY:
				theKindOfService = "RNCF/";
				break;

			case RSS_SERVID_REMOTE_CONTENTS_MGR:
				theKindOfService = "RCMGR/";
				break;

			default:
				throw new IllegalArgumentException( "SEVICE ID:" + type + "́C`Ă܂D" );
		}

		String serviceName = theKindOfService + RandomKeyGenerator.getUniqKey(16);

		return serviceName;
	}

	/**
	 * [gT[rXIp̃ASYԂ
	 */
	protected ServiceBindingAlgorithm getBindingAlgorithmByType( int type ) throws IllegalArgumentException {
		switch( type ) {
			case RSS_SERVID_SERVICE_LOCATER:
				return cfg.getDSRBindingAlgorithm();

			case RSS_SERVID_ROUTING_NODE_CLIENT_FACTORY:
				return cfg.getRNodeBindingAlgorithm();

			case RSS_SERVID_REMOTE_CONTENTS_MGR:
				return cfg.getRCMGRBindingAlgorithm();

			default:
				throw new IllegalArgumentException( "SEVICE ID:" + type + "́C`Ă܂D" );
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[Jn
	 */
	public void startModule() throws ModuleException {
		try {
			cfg = new RSSDSRConfig( RSSDistributedServiceRegistryImpl.RSS_DSRCONF_PATH );
			String serviceName = cfg.getRSSDistributedServiceRegistry();

			Naming.rebind( serviceName, this );
			System.err.println( "UT[rXWXg '" + serviceName + "' Jn܂D" );

		} catch( Exception e ) {
			throw new ModuleException( e );
		}
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[ꎞ~
	 */
	public void suspendModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * ~Ă郂W[̎sĊJ
	 */
	public void continueModule() throws ModuleException {
	}

	/**
	 * W[Rg[pC^[tF[X::
	 * W[~
 	 * ̃\bhĂ΂ꂽꍇCW[͈Sȕ@ŏI
	 * IW[́CVCX^XȂƊJn邱Ƃ͂łȂ
	 */
	public void stopModule() throws ModuleException {
	}

	/**
	 * C\bh
	 */
	public static void main( String[] args ) throws Exception {
		try {
			RSSDistributedServiceRegistryImpl selector = new RSSDistributedServiceRegistryImpl();
			selector.startModule();
		} catch( Exception e ) {
			System.err.println( e.getMessage() );
			e.printStackTrace();
		}
	}
}

// end of RSSDistributedServiceRegistryImpl.java
