/**
 * RSSDSRConfig
 * UT[rXWXg̃RtBO
 */
package org.logical_paradox.rss.dsr;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

public class RSSDSRConfig extends RSSConfig {
	private String cfgRSSDistributedServiceRegistry;
	private boolean cfgDSRSwDebugTraceLog;
	private boolean cfgDSRSwRunLog;
	private String cfgDebugTraceLogFilename;
	private String cfgRunLogFilename;
	private ServiceBindingAlgorithm cfgDSRBindingAlgorithm;
	private ServiceBindingAlgorithm cfgRNodeBindingAlgorithm;
	private ServiceBindingAlgorithm cfgRCMGRBindingAlgorithm;

	public RSSDSRConfig( String fn ) throws IOException, RSSIllegalConfigException {
		super( fn );
		String errmsg = checkResourceVariables();
		if( errmsg != null ) {
			throw new RSSIllegalConfigException( errmsg );
		}
	}
	public String getRSSDistributedServiceRegistry() {
		return cfgRSSDistributedServiceRegistry;
	}
	public boolean getDSRSwDebugTraceLog() {
		return cfgDSRSwDebugTraceLog;
	}
	public boolean getDSRSwRunLog() {
		return cfgDSRSwRunLog;
	}
	public String getDebugTraceLogFilename() {
		return cfgDebugTraceLogFilename;
	}
	public String getRunLogFilename() {
		return cfgRunLogFilename;
	}
	public ServiceBindingAlgorithm getDSRBindingAlgorithm() {
		return cfgDSRBindingAlgorithm;
	}
	public ServiceBindingAlgorithm getRNodeBindingAlgorithm() {
		return cfgRNodeBindingAlgorithm;
	}
	public ServiceBindingAlgorithm getRCMGRBindingAlgorithm() {
		return cfgRCMGRBindingAlgorithm;
	}

	/**
	 * p[^mF\bh
	 */
	protected String checkResourceVariables() {
		StringBuffer errmsg = new StringBuffer();

		if( getProperty( "RSS_DSR" ) != null ) {
			cfgRSSDistributedServiceRegistry = getProperty( "RSS_DSR" );
		} else {
			errmsg.append( "RSS_DSRw肳Ă܂D\n" );
		}

		try {
			cfgDSRSwDebugTraceLog = getPropertyAsBool( "DSR_SW_DEBUG_TRACE_LOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg.append( "DSR_SW_DEBUG_TRACE_LOGsł\n" );
		} catch( RSSNullValueException ne ) {}

		try {
			cfgDSRSwRunLog = getPropertyAsBool( "DSR_SW_RUNLOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg.append( "DSR_SW_RUNLOGsł\n" );
		} catch( RSSNullValueException ne ) {}

		if( getProperty( "DEBUG_TRACE_LOG_FILENAME" ) != null ) {
			cfgDebugTraceLogFilename = getProperty( "DEBUG_TRACE_LOG_FILENAME" );
		} else {
			errmsg.append( "DEBUG_TRACE_LOG_FILENAMEw肳Ă܂D\n" );
		}

		if( getProperty( "RUNLOG_FILENAME" ) != null ) {
			cfgRunLogFilename = getProperty( "RUNLOG_FILENAME" );
		} else {
			errmsg.append( "RUNLOG_FILENAMEw肳Ă܂D\n" );
		}


		try {
			if( getProperty( "DSR_BINDING_ALGORITHM" ) != null ) {
				cfgDSRBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName( getProperty( "DSR_BINDING_ALGORITHM" ) ).newInstance();
			} else {
				errmsg.append( "DSR_BINDING_ALGORITHMw肳Ă܂D\n" );
			}
		} catch( Exception slBindingAlgorithmExp ) {
			errmsg.append( getProperty( "RNODE_BINDING_ALGORITHM" ) + "̃CX^XɗO܂: " + slBindingAlgorithmExp.getMessage() );
		}

		try {
			if( getProperty( "RNODE_BINDING_ALGORITHM" ) != null ) {
				cfgRNodeBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName( getProperty( "RNODE_BINDING_ALGORITHM" ) ).newInstance();
			} else {
				errmsg.append( "RNODE_BINDING_ALGORITHMw肳Ă܂D\n" );
			}
		} catch( Exception rnodeBindingAlgorithmExp ) {
			errmsg.append( getProperty( "RNODE_BINDING_ALGORITHM" ) + "̃CX^XɗO܂: " + rnodeBindingAlgorithmExp.getMessage() );
		}
		try {
			if( getProperty( "RCMGR_BINDING_ALGORITHM" ) != null ) {
				cfgRCMGRBindingAlgorithm = (ServiceBindingAlgorithm)Class.forName( getProperty( "RCMGR_BINDING_ALGORITHM" ) ).newInstance();
			} else {
				errmsg.append( "RCMGR_BINDING_ALGORITHMw肳Ă܂D\n" );
			}
		} catch( Exception rcmgrBindingAlgorithmExp ) {
			errmsg.append( getProperty( "RNODE_BINDING_ALGORITHM" ) + "̃CX^XɗO܂: " + rcmgrBindingAlgorithmExp.getMessage() );
		}

		if( errmsg.toString().trim().length() == 0 ) {
			return null;
		} else {
			return errmsg.toString();
		}
	}
}

// end of RSSDSRConfig.java
