/**
 * RSSConfig
 * Tm[h/oHm[hȂǂ̊econfig߂̃NX
 */
package org.logical_paradox.rss;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;


public abstract class RSSConfig {
	protected Properties prop = null;

	/**
	 * RXgN^
	 */
	public RSSConfig( String fn ) throws IOException, RSSIllegalConfigException {
		prop = new Properties();
		prop.load( new FileInputStream( fn ) );

		// ݒt@C̓emF
		String errmsg = checkResourceVariables();
		if( errmsg != null && errmsg.trim().length() > 0 ) {
			throw new RSSIllegalConfigException( errmsg );
		}
	}

	/**
	 * ݒt@C̓emF
	 */
	protected abstract String checkResourceVariables();

	/**
	 * wL[̐ݒeԂ
	 */
	public String getProperty( String key ) {
		if( prop.get( key ) == null ) {
			return null;
		} else {
			return new String( (String)prop.get( key ) );
		}
	}

	/**
	 * wL[̓e𐮐ƂĎ擾
	 */
	public int getPropertyAsInt( String key ) throws RSSValueFormatException, RSSNullValueException {
		String p = getProperty( key );
		if( p == null ) {
			throw new RSSNullValueException();
		}

		int rc = 0;
		try {
			rc = Integer.parseInt( p );
		} catch( Exception e ) {
			throw new RSSValueFormatException( e.getMessage() );
		}

		return rc;
	}

	/**
	 * wL[̓eboollƂĎ擾
	 */
	public boolean getPropertyAsBool( String key ) throws RSSValueFormatException, RSSNullValueException {
		String p = getProperty( key );
		if( p == null ) {
			throw new RSSNullValueException();
		} else {
			p = p.toUpperCase().trim();
		}

		boolean rc = true;
		if( p.equals( "ON" ) || p.equals( "TRUE" ) ) {
			rc = true;
		} else if( p.equals( "OFF" ) || p.equals( "FALSE" ) ) {
			rc = false;
		} else {
			throw new RSSValueFormatException();
		}

		return rc;
	}
}

// end of RSSConfig.java
