/*
 * IPv4AddressRangeSet
 * IPv4x[X̃AhX͈͂̃ZbgǗNX
 */
package org.logical_paradox.common.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;

public class IPv4AddressRangeSet extends IPAddressRangeSet {
	/*
	 * RXgN^
	 */
	public IPv4AddressRangeSet() {
	}
	public IPv4AddressRangeSet( String filename ) throws IOException {
		super( filename );
	}
	public IPv4AddressRangeSet( InputStream in ) throws IOException {
		super( in );
	}

	// IPAhX͈̓NX쐬
	protected IPAddress getIPAddress( String ips ) throws UnknownHostException {
		return (IPAddress)new IPv4Address( IPv4Address.getIPv4MaskPair( ips ) );
	}
}

// end of IPv4AddressRangeSet.java
