/*
 * IPAddressRangeSetFactory
 * vbgtH[œKIPAhX͈̓ZbgNXԂt@Ng
 * L̃VXevpeBD悵ĐNX肷
 * "org.logical_paradox.common.net.IPAddressRangeFactoryClass"
 * Ɏw肪ȂꍇCIPv4̃Zbg쐬
 */
package org.logical_paradox.common.net;

public final class IPAddressRangeSetFactory {
	public static final String IPADDRESS_RANGE_SET_FACTORY_CLS = "org.logical_paradox.common.net.IPAddressRangeFactoryClass";
	public static final String DEFAULT_RANGESET_CLASS = "org.logical_paradox.common.net.IPv4AddressRangeSet";

	/*
	 * ftHgRXgN^(protected)
	 * ƂCNXfinal..
	 */
	protected IPAddressRangeSetFactory() {
	}

	// vbgtH[ɍœKIPAhX͈̓ZbgԂ
	public static final IPAddressRangeSet getIPAddressRangeSet() throws ClassNotFoundException {
		String rangeSetClassName = System.getProperty( IPADDRESS_RANGE_SET_FACTORY_CLS );
		if( rangeSetClassName == null || rangeSetClassName.trim().length() == 0 ) {
			rangeSetClassName = DEFAULT_RANGESET_CLASS;
		}

		try {
			return (IPAddressRangeSet)Class.forName( rangeSetClassName ).newInstance();
		} catch( Exception e ) {
			throw new ClassNotFoundException( e.getMessage() );
		}
	}
}

// end of IPAddressRangeSetFactory.java
