/*
 * IPAddressRangeSet
 * IPAhX͈͂̃ZbgǗNX
 */
package org.logical_paradox.common.net;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;

public abstract class IPAddressRangeSet {
	protected final HashSet dic = new HashSet();
	/*
	 * RXgN^
	 */
	public IPAddressRangeSet() {
	}
	public IPAddressRangeSet( String filename ) throws IOException {
		load( filename );
	}
	public IPAddressRangeSet( InputStream in ) throws IOException {
		load( in );
	}

	/*
	 * IPAhX͈͂̈ꗗt@CȂǂ烍[h
	 */
	public void setRanges( String[] ranges ) throws UnknownHostException {
		for( int i = 0; i < ranges.length; i++ ) {
			dic.add( getIPAddress( ranges[i].trim() ) );
		}
	}

	public void load( String filename ) throws IOException {
		load( new FileInputStream( filename ) );
	}
	public void load( InputStream in ) throws IOException {
		BufferedReader br = new BufferedReader( new InputStreamReader( in ) );

		String line = null;
		try {
			while( (line = br.readLine()) != null ) {
				dic.add( getIPAddress( line ) );
			}
		} catch( UnknownHostException ue ) {
			throw new IOException( ue.getMessage() );
		}
		br.close();
	}

	// IPAhX쐬(̃NX쐬邩̓TuNXŎ
	protected abstract IPAddress getIPAddress( String ips ) throws UnknownHostException;

	/*
	 * w肳ꂽIPAhXɊYIPAhX͈̓R[h݂邩ǂ𒲂ׂ
	 */
	public boolean includes( InetAddress ipa ) {
		Iterator it = dic.iterator();
		while( it.hasNext() ) {
			IPAddress range = (IPAddress)it.next();
			if( range.includes( ipa ) ) {
				return true;		// 
			}
		}

		return false;
	}
}

// end of IPAddressRangeSet.java
