/*
 * IPAddress
 * lbg}XNAhXǗNX
 */
package org.logical_paradox.common.net;

import java.net.InetAddress;

public abstract class IPAddress {
	protected final InetAddress ipAddress;
	protected final InetAddress netmask;

	public IPAddress( InetAddress ip, InetAddress nm ) {
		ipAddress = ip;
		netmask = nm;
	}

	public InetAddress getIPAddress() {
		return ipAddress;
	}
	public InetAddress getNetmask() {
		return netmask;
	}

	public String toString() {
		return ipAddress.toString();
	}

	public boolean equals( IPAddress ip ) {
		return ip.getIPAddress().equals( ipAddress ) && ip.getNetmask().equals( netmask ) ? true : false;
	}

	public abstract boolean includes( InetAddress ip );
	public abstract boolean includes( String ip );
}

// end of IPAddress.java
