/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.extern.decimal.OverflowHandling;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;

final class FBDecfloatField<T extends Decimal<T>>
extends FBField {
    private static final BigDecimal BD_MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal BD_MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
    private final Class<T> decimalType;
    private final DecimalHandling<T> decimalHandling;

    FBDecfloatField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType, Class<T> decimalType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        if (!fieldDescriptor.isFbType(32760) && !fieldDescriptor.isFbType(32762)) {
            throw FbExceptionBuilder.forException(337248277).messageParameter(fieldDescriptor.getType()).toFlatSQLException();
        }
        this.decimalType = decimalType;
        this.decimalHandling = this.getDecimalHandling(fieldDescriptor, decimalType);
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        T value = this.getDecimal();
        if (value == null) {
            return null;
        }
        try {
            return ((Decimal)value).toBigDecimal();
        }
        catch (ArithmeticException e) {
            throw new TypeConversionException("Value is too large to fit in target type, or cannot be represented by the target type", e);
        }
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        try {
            this.setDecimalInternal(value != null ? (T)this.decimalHandling.valueOf(value) : null);
        }
        catch (ArithmeticException e) {
            throw new TypeConversionException("Value is too large to fit in target type, or cannot be represented by the target type", e);
        }
    }

    public T getDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.decimalHandling.decode(this.fieldDescriptor, this.getFieldData());
    }

    @Override
    public void setDecimal(Decimal<?> value) throws SQLException {
        try {
            this.setDecimalInternal(value != null ? (T)value.toDecimal(this.decimalType, OverflowHandling.THROW_EXCEPTION) : null);
        }
        catch (ArithmeticException e) {
            throw new TypeConversionException("Value is too large to fit in target type, or cannot be represented by the target type", e);
        }
    }

    private void setDecimalInternal(T value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        try {
            this.setFieldData(this.decimalHandling.encode(this.fieldDescriptor, value));
        }
        catch (ArithmeticException e) {
            throw new TypeConversionException("Value is too large to fit in target type, or cannot be represented by the target type", e);
        }
    }

    @Override
    public double getDouble() throws SQLException {
        T value = this.getDecimal();
        return value != null ? ((Decimal)value).doubleValue() : 0.0;
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setDecimalInternal(this.decimalHandling.valueOf(value));
    }

    @Override
    public float getFloat() throws SQLException {
        return (float)this.getDouble();
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public long getLong() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return 0L;
        }
        if (BD_MIN_LONG.compareTo(value) > 0 || value.compareTo(BD_MAX_LONG) > 0) {
            throw new TypeConversionException("Error converting to long.");
        }
        return value.longValue();
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setBigDecimal(BigDecimal.valueOf(value));
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw new TypeConversionException("Error converting to int.");
        }
        return (int)longValue;
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 32767L || longValue < -32768L) {
            throw new TypeConversionException("Error converting to short.");
        }
        return (short)longValue;
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        long longValue = this.getLong();
        if (longValue > 127L || longValue < -128L) {
            throw new TypeConversionException("Error converting to byte.");
        }
        return (byte)longValue;
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setLong(value);
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value == null) {
            return null;
        }
        return value.toBigInteger();
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setBigDecimal(new BigDecimal(value));
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return BigDecimal.ONE.equals(this.getBigDecimal());
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setBigDecimal(value ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public String getString() throws SQLException {
        T value = this.getDecimal();
        if (value == null) {
            return null;
        }
        return ((Decimal)value).toString();
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        try {
            this.setDecimalInternal(this.decimalHandling.valueOf(value));
        }
        catch (NumberFormatException nex) {
            throw new TypeConversionException("Error converting to string.");
        }
        catch (ArithmeticException e) {
            throw new TypeConversionException("Value is too large to fit in target type, or cannot be represented by the target type", e);
        }
    }

    private DecimalHandling<T> getDecimalHandling(FieldDescriptor fieldDescriptor, Class<T> decimalType) throws FBDriverNotCapableException {
        if (decimalType == Decimal64.class && fieldDescriptor.isFbType(32760)) {
            return Decimal64Handling.INSTANCE;
        }
        if (decimalType == Decimal128.class && fieldDescriptor.isFbType(32762)) {
            return Decimal128Handling.INSTANCE;
        }
        throw new FBDriverNotCapableException("Unsupported type " + decimalType.getName() + " and/or field type " + fieldDescriptor.getType());
    }

    private static final class Decimal128Handling
    implements DecimalHandling<Decimal128> {
        private static final Decimal128Handling INSTANCE = new Decimal128Handling();

        private Decimal128Handling() {
        }

        @Override
        public byte[] encode(FieldDescriptor fieldDescriptor, Decimal128 value) {
            return fieldDescriptor.getDatatypeCoder().encodeDecimal128(value);
        }

        @Override
        public Decimal128 decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
            return fieldDescriptor.getDatatypeCoder().decodeDecimal128(fieldData);
        }

        @Override
        public Decimal128 valueOf(double value) {
            return Decimal128.valueOf(value);
        }

        @Override
        public Decimal128 valueOf(String value) {
            return Decimal128.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }

        @Override
        public Decimal128 valueOf(BigDecimal value) {
            return Decimal128.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }
    }

    private static final class Decimal64Handling
    implements DecimalHandling<Decimal64> {
        private static final Decimal64Handling INSTANCE = new Decimal64Handling();

        private Decimal64Handling() {
        }

        @Override
        public byte[] encode(FieldDescriptor fieldDescriptor, Decimal64 value) {
            return fieldDescriptor.getDatatypeCoder().encodeDecimal64(value);
        }

        @Override
        public Decimal64 decode(FieldDescriptor fieldDescriptor, byte[] fieldData) {
            return fieldDescriptor.getDatatypeCoder().decodeDecimal64(fieldData);
        }

        @Override
        public Decimal64 valueOf(double value) {
            return Decimal64.valueOf(value);
        }

        @Override
        public Decimal64 valueOf(String value) {
            return Decimal64.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }

        @Override
        public Decimal64 valueOf(BigDecimal value) {
            return Decimal64.valueOf(value, OverflowHandling.THROW_EXCEPTION);
        }
    }

    private static interface DecimalHandling<T extends Decimal<T>> {
        public byte[] encode(FieldDescriptor var1, T var2);

        public T decode(FieldDescriptor var1, byte[] var2);

        public T valueOf(double var1);

        public T valueOf(String var1);

        public T valueOf(BigDecimal var1);
    }
}

