/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

public enum QuoteStrategy {
    NO_QUOTES{

        @Override
        public StringBuffer appendQuoted(String objectName, StringBuffer sb) {
            return sb.append(objectName);
        }
    }
    ,
    QUOTES{

        @Override
        public StringBuffer appendQuoted(String objectName, StringBuffer sb) {
            return sb.append('\"').append(objectName).append('\"');
        }
    };


    public abstract StringBuffer appendQuoted(String var1, StringBuffer var2);

    public static QuoteStrategy forDialect(int dialect) {
        if (dialect == 1) {
            return NO_QUOTES;
        }
        return QUOTES;
    }
}

