/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.Sort;

public class OraBoot
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static OraBoot upCache = null;
    private static final String FILENAME = GDKOracleMetaData.getDataPath() + "lx0boot.glb";
    public static final String CUSTOM_CHARSET_METAFILE = "charsetMeta.properties";
    public static final String CUSTOM_LANGUAGE_METAFILE = "langMeta.properties";
    public static final String CUSTOM_LINGUISTIC_METAFILE = "lingMeta.properties";
    public static final String CUSTOM_TERRITORY_METAFILE = "territoryMeta.properties";
    public static final int FLAG_FIXEDWIDTH = 256;
    public static final int FLAG_ASCII = 16;
    public static final int FLAG_EBCDIC = 1;
    protected HashMap languageIdMap = null;
    protected HashMap territoryIdMap = null;
    protected HashMap linguisticIdMap = null;
    protected HashMap charSetIdMap = null;
    protected HashMap tableIdMap = null;
    protected HashMap idtoLanguageMap = null;
    protected HashMap idtoTerritoryMap = null;
    protected HashMap idtoCharSetMap = null;
    protected HashMap idtoLinguisticMap = null;
    protected HashMap idtoTableMap = null;
    protected HashMap oraShortToOraLangMap = null;
    protected Map oraLangToOraShortMap = null;
    protected Map idtoCharSetMaxLen = null;
    protected Map langToTerrMap = null;
    protected Map langToLingMap = null;
    protected Map langToCharSetsUnix = null;
    protected Map langToCharSetsWin = null;
    protected List lstCharSetIsAscii;
    protected List lstCharSetIsEbcdic;
    protected List lstCharSetIsFixed;
    protected List lstCharSetIsStorage;
    protected String[] availableLang = null;
    protected String[] availableTerr = null;
    protected String[] availableCharSet = null;
    protected String[] availableLing = null;

    protected OraBoot() {
    }

    public static synchronized OraBoot getInstance() {
        if (upCache == null) {
            upCache = (OraBoot)OraBoot.readObj(FILENAME);
        }
        return upCache;
    }

    public String getLanguageFileName(String string) {
        return (String)this.languageIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerritoryFileName(String string) {
        return (String)this.territoryIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerritoryFileName(String string, String string2) {
        if (string == null) {
            return (String)this.territoryIdMap.get(string2.toUpperCase(Locale.US));
        }
        String string3 = string.toUpperCase(Locale.US);
        String string4 = string2.toUpperCase(Locale.US);
        String string5 = (String)this.territoryIdMap.get(string3 + "_" + string4);
        if (string5 != null) {
            return string5;
        }
        return (String)this.territoryIdMap.get(string4);
    }

    public String getLinguisticFileName(String string) {
        return (String)this.linguisticIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getCharSetFileName(String string) {
        return OraBoot.formatFileName("lx2", (String)this.charSetIdMap.get(string.toUpperCase(Locale.US)));
    }

    public String getTableFileName(String string) {
        return (String)this.tableIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getCharSetId(String string) {
        return (String)this.charSetIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getLanguageName(String string) {
        return (String)this.idtoLanguageMap.get(string);
    }

    public String getTerritoryName(String string) {
        return (String)this.idtoTerritoryMap.get(string);
    }

    public String getCharSetName(String string) {
        return (String)this.idtoCharSetMap.get(string);
    }

    public String getLinguisticName(String string) {
        return (String)this.idtoLinguisticMap.get(string);
    }

    public String getTableName(String string) {
        return (String)this.idtoTableMap.get(string);
    }

    public String getOraLangFromShort(String string) {
        return (String)this.oraShortToOraLangMap.get(string.toUpperCase(Locale.US));
    }

    public String getOraShortFromLang(String string) {
        return (String)this.oraLangToOraShortMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerrIdFromLang(String string) {
        return (String)this.langToTerrMap.get(string.toUpperCase(Locale.US));
    }

    public String getLingFromLang(String string) {
        return (String)this.langToLingMap.get(string.toUpperCase(Locale.US));
    }

    public List getLocalCharsetsWin(String string) {
        return (List)this.langToCharSetsWin.get(string.toUpperCase(Locale.US));
    }

    public List getLocalCharsetsUnix(String string) {
        return (List)this.langToCharSetsUnix.get(string.toUpperCase(Locale.US));
    }

    public String getCharsetMaxCharLen(String string) {
        String string2 = (String)this.idtoCharSetMaxLen.get(string);
        if (string2 == null && string != null && string.equals(this.getCharSetId("AL16UTF16LE"))) {
            string2 = (String)this.idtoCharSetMaxLen.get(this.getCharSetId("AL16UTF16"));
        }
        return string2;
    }

    public List getCharSetIsAscii() {
        return this.lstCharSetIsAscii;
    }

    public List getCharSetIsEbcdic() {
        return this.lstCharSetIsEbcdic;
    }

    public List getCharSetIsFixed() {
        return this.lstCharSetIsFixed;
    }

    public List getCharSetIsStorage() {
        return this.lstCharSetIsStorage;
    }

    public String[] availableLanguages() {
        return this.availableLang;
    }

    public String[] availableTerritories() {
        return this.availableTerr;
    }

    public String[] availableCharacterSets() {
        return this.availableCharSet;
    }

    public String[] availableLinguisticSorts() {
        return this.availableLing;
    }

    protected static String formatFileName(String string, String string2) {
        String string3 = "0000";
        String string4 = Integer.toHexString(Integer.parseInt(string2));
        String string5 = string3.substring(0, string3.length() - string4.length()) + string4;
        return string + string5;
    }

    static Object readObj(String string) {
        final Class<OraBoot> clazz = OraBoot.class;
        final String string2 = string;
        try {
            final URL uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return clazz.getResource(string2);
                }
            });
            if (uRL == null) {
                return null;
            }
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ClassNotFoundException {
                    InputStream inputStream = uRL.openStream();
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    objectInputStream.close();
                    inputStream.close();
                    if (object instanceof OraBoot) {
                        OraBoot.readCustomBootInfo((OraBoot)object);
                    }
                    return object;
                }
            });
            return t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException("IOException" + privilegedActionException.getMessage());
        }
    }

    private static void readCustomBootInfo(OraBoot oraBoot) {
        OraBoot.readCharsetBootInfo(oraBoot);
        OraBoot.readLanguageBootInfo(oraBoot);
        OraBoot.readLinguisticBootInfo(oraBoot);
        OraBoot.readTerritoryBootInfo(oraBoot);
    }

    private static void readLinguisticBootInfo(OraBoot oraBoot) {
        try {
            URL uRL = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            uRL = classLoader != null ? classLoader.getResource(CUSTOM_LINGUISTIC_METAFILE) : ClassLoader.getSystemResource(CUSTOM_LINGUISTIC_METAFILE);
            if (uRL == null) {
                return;
            }
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Properties properties = (Properties)objectInputStream.readObject();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                String string3 = OraBoot.formatFileName("lx3", string);
                if (oraBoot.idtoLinguisticMap.containsKey(string) || oraBoot.linguisticIdMap.containsKey(string2)) continue;
                oraBoot.idtoLinguisticMap.put(string, string2);
                oraBoot.linguisticIdMap.put(string2, string3);
                oraBoot.availableLing = OraBoot.addToArray(oraBoot.availableLing, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void readTerritoryBootInfo(OraBoot oraBoot) {
        try {
            URL uRL = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            uRL = classLoader != null ? classLoader.getResource(CUSTOM_TERRITORY_METAFILE) : ClassLoader.getSystemResource(CUSTOM_TERRITORY_METAFILE);
            if (uRL == null) {
                return;
            }
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Properties properties = (Properties)objectInputStream.readObject();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                String string3 = OraBoot.formatFileName("lx1", string);
                if (oraBoot.idtoTerritoryMap.containsKey(string) || oraBoot.territoryIdMap.containsKey(string2)) continue;
                oraBoot.idtoTerritoryMap.put(string, string2);
                oraBoot.territoryIdMap.put(string2, string3);
                oraBoot.availableTerr = OraBoot.addToArray(oraBoot.availableTerr, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void readCharsetBootInfo(OraBoot oraBoot) {
        try {
            URL uRL = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            uRL = classLoader != null ? classLoader.getResource(CUSTOM_CHARSET_METAFILE) : ClassLoader.getSystemResource(CUSTOM_CHARSET_METAFILE);
            if (uRL == null) {
                return;
            }
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Properties properties = (Properties)objectInputStream.readObject();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                if (oraBoot.getCharSetName(string) != null || oraBoot.getCharSetId(string3) != null) continue;
                if (Integer.parseInt(string5) == 16) {
                    oraBoot.lstCharSetIsAscii.add(string3);
                    Collections.sort(oraBoot.lstCharSetIsAscii);
                } else if (Integer.parseInt(string5) == 1) {
                    oraBoot.lstCharSetIsEbcdic.add(string3);
                    Collections.sort(oraBoot.lstCharSetIsEbcdic);
                } else if (Integer.parseInt(string5) == 256) {
                    oraBoot.lstCharSetIsFixed.add(string3);
                    Collections.sort(oraBoot.lstCharSetIsFixed);
                }
                oraBoot.charSetIdMap.put(string3, string);
                oraBoot.idtoCharSetMaxLen.put(string, string4);
                oraBoot.idtoCharSetMap.put(string, string3);
                oraBoot.availableCharSet = OraBoot.addToArray(oraBoot.availableCharSet, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void readLanguageBootInfo(OraBoot oraBoot) {
        try {
            URL uRL = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            uRL = classLoader != null ? classLoader.getResource(CUSTOM_LANGUAGE_METAFILE) : ClassLoader.getSystemResource(CUSTOM_LANGUAGE_METAFILE);
            if (uRL == null) {
                return;
            }
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Properties properties = (Properties)objectInputStream.readObject();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                String string3 = OraBoot.formatFileName("lx0", string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                String string4 = stringTokenizer.nextToken();
                if (oraBoot.idtoLanguageMap.containsKey(string) || oraBoot.languageIdMap.containsKey(string4)) continue;
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = stringTokenizer.nextToken();
                String string9 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string7, ",");
                ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer2.countTokens());
                while (stringTokenizer2.hasMoreTokens()) {
                    arrayList.add(stringTokenizer2.nextToken());
                }
                stringTokenizer2 = new StringTokenizer(string8, ",");
                ArrayList<String> arrayList2 = new ArrayList<String>(stringTokenizer2.countTokens());
                while (stringTokenizer2.hasMoreTokens()) {
                    arrayList2.add(stringTokenizer2.nextToken());
                }
                stringTokenizer2 = new StringTokenizer(string9, ",");
                String[] stringArray = new String[stringTokenizer2.countTokens()];
                int n = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer2.nextToken();
                }
                oraBoot.idtoLanguageMap.put(string, string4);
                oraBoot.languageIdMap.put(string4, string3);
                if (!"null".equals(arrayList)) {
                    oraBoot.langToCharSetsUnix.put(string4, arrayList);
                }
                if (!"null".equals(arrayList2)) {
                    oraBoot.langToCharSetsWin.put(string4, arrayList2);
                }
                if (!"null".equals(stringArray[0])) {
                    oraBoot.langToLingMap.put(string4, stringArray[0]);
                }
                if (!"null".equals(string6)) {
                    oraBoot.langToTerrMap.put(string4, string6);
                }
                if (!oraBoot.oraShortToOraLangMap.containsKey(string5) && !"null".equals(string5)) {
                    oraBoot.oraShortToOraLangMap.put(string5, string4);
                }
                if (!oraBoot.oraLangToOraShortMap.containsKey(string4) && !"null".equals(string5)) {
                    oraBoot.oraLangToOraShortMap.put(string4, string5);
                }
                oraBoot.availableLang = OraBoot.addToArray(oraBoot.availableLang, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String[] addToArray(String[] stringArray, String string) {
        Object[] objectArray = null;
        if (stringArray != null) {
            objectArray = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            objectArray[stringArray.length] = string;
            Sort.quickSort(objectArray);
        }
        return objectArray;
    }
}

