/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CMAREngineNIO
extends T4CMAREngine {
    NIONSDataChannel nsDataChannel;
    SessionAtts sAtts;
    private boolean bytesReadyToGo = false;
    private boolean bufferReadyToWriteInto = false;
    int bytesWrittenSoFar = 0;
    int bytesToWriteInNextCall = 0;

    T4CMAREngineNIO(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
        }
        this.net = communication;
        this.sAtts = communication.getSessionAttributes();
        this.nsDataChannel = this.sAtts.dataChannel;
        this.types = new T4CTypeRep(this, true);
        this.types.setRep((byte)1, (byte)2);
        this.sAtts.payloadDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    final void prepareForReading() throws IOException, SQLException {
        try {
            if (this.bytesReadyToGo) {
                this.nsDataChannel.writeDataToSocketChannel();
                this.bytesReadyToGo = false;
                this.nsDataChannel.readDataFromSocketChannel();
            }
            while (!this.sAtts.payloadDataBuffer.hasRemaining()) {
                this.nsDataChannel.readDataFromSocketChannel();
            }
            this.bufferReadyToWriteInto = false;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (NetException netException) {
            if (netException.isNSControlCommandError()) {
                this.bufferReadyToWriteInto = false;
            }
            if (netException.getErrorNumber() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
            }
            throw netException;
        }
    }

    final void prepareForWriting() throws IOException {
        if (!this.bufferReadyToWriteInto) {
            this.sAtts.payloadDataBuffer.clear();
            this.sAtts.payloadDataBuffer.limit(this.sAtts.payloadDataBuffer.capacity() - this.nsDataChannel.getDataExpansionByteSize());
            this.bufferReadyToWriteInto = true;
        }
    }

    private static void valueToUNV(long l2, byte[] byArray) {
        byArray[0] = 0;
        if (l2 == 0L) {
            return;
        }
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = l2 < 0L;
        long l3 = bl2 ? -l2 : l2;
        for (int i2 = 0; i2 < 8; ++i2) {
            byte by = (byte)(l3 >>> 8 * (7 - i2) & 0xFFL);
            if (bl && by == 0) continue;
            bl = false;
            byArray[++n2] = by;
        }
        byArray[0] = (byte)n2;
        if (bl2) {
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        }
    }

    @Override
    final void marshalSB1(byte by) throws IOException {
        this.prepareForWriting();
        if (this.sAtts.payloadDataBuffer.remaining() < 1) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        this.sAtts.payloadDataBuffer.put(by);
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalUB1(short s2) throws IOException {
        this.marshalSB1((byte)s2);
    }

    @Override
    final void marshalSB2(short s2) throws IOException {
        this.prepareForWriting();
        if (this.sAtts.payloadDataBuffer.remaining() < 3) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        if (this.types.rep[1] != 1) {
            this.sAtts.payloadDataBuffer.putShort(s2);
        } else if (s2 == 0) {
            this.sAtts.payloadDataBuffer.put((byte)0);
        } else {
            boolean bl = s2 < 0;
            short s3 = bl ? -s2 : s2;
            if (s3 <= 255) {
                if (bl) {
                    this.sAtts.payloadDataBuffer.put((byte)-127);
                } else {
                    this.sAtts.payloadDataBuffer.put((byte)1);
                }
                this.sAtts.payloadDataBuffer.put((byte)s3);
            } else {
                if (bl) {
                    this.sAtts.payloadDataBuffer.put((byte)-126);
                } else {
                    this.sAtts.payloadDataBuffer.put((byte)2);
                }
                this.sAtts.payloadDataBuffer.putShort(s3);
            }
        }
    }

    @Override
    final void marshalUB2(int n2) throws IOException {
        this.prepareForWriting();
        if (this.sAtts.payloadDataBuffer.remaining() < 3) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        if (this.types.rep[1] != 1) {
            this.sAtts.payloadDataBuffer.putShort((short)n2);
        } else if (n2 == 0) {
            this.sAtts.payloadDataBuffer.put((byte)0);
        } else if (n2 <= 255) {
            this.sAtts.payloadDataBuffer.put((byte)1);
            this.sAtts.payloadDataBuffer.put((byte)n2);
        } else {
            this.sAtts.payloadDataBuffer.put((byte)2);
            this.sAtts.payloadDataBuffer.putShort((short)n2);
        }
        this.bytesReadyToGo = true;
    }

    @Override
    void marshalNativeUB2(short s2, boolean bl) throws IOException {
        try {
            byte by = this.types.getRep((byte)1);
            byte by2 = (byte)(0 | (bl ? 2 : 0));
            this.types.setRep((byte)1, by2);
            this.marshalUB2(s2);
            this.types.setRep((byte)1, by);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    @Override
    final void marshalSB4(int n2) throws IOException {
        this.prepareForWriting();
        if (this.sAtts.payloadDataBuffer.remaining() < 5) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        if (this.types.rep[2] != 1) {
            this.sAtts.payloadDataBuffer.putInt(n2);
        } else if (n2 == 0) {
            this.sAtts.payloadDataBuffer.put((byte)0);
        } else {
            int n3;
            boolean bl = n2 < 0;
            int n4 = n3 = bl ? -n2 : n2;
            if (n3 <= 255) {
                if (!bl) {
                    this.sAtts.payloadDataBuffer.put((byte)1);
                } else {
                    this.sAtts.payloadDataBuffer.put((byte)-127);
                }
                this.sAtts.payloadDataBuffer.put((byte)n3);
            } else if (n3 <= 65535) {
                if (!bl) {
                    this.sAtts.payloadDataBuffer.put((byte)2);
                } else {
                    this.sAtts.payloadDataBuffer.put((byte)-126);
                }
                this.sAtts.payloadDataBuffer.putShort((short)n3);
            } else if (n3 < 26) {
                T4CMAREngineNIO.valueToUNV(n2, this.tmpBuffer10);
                this.sAtts.payloadDataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            } else {
                if (!bl) {
                    this.sAtts.payloadDataBuffer.put((byte)4);
                } else {
                    this.sAtts.payloadDataBuffer.put((byte)-124);
                }
                this.sAtts.payloadDataBuffer.putInt(n3);
            }
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalUB4(long l2) throws IOException {
        this.prepareForWriting();
        if (this.sAtts.payloadDataBuffer.remaining() < 5) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        if (this.types.rep[2] != 1) {
            this.sAtts.payloadDataBuffer.putInt((int)l2);
        } else if (l2 == 0L) {
            this.sAtts.payloadDataBuffer.put((byte)0);
        } else if (l2 <= 255L) {
            this.sAtts.payloadDataBuffer.put((byte)1);
            this.sAtts.payloadDataBuffer.put((byte)l2);
        } else if (l2 <= 65535L) {
            this.sAtts.payloadDataBuffer.put((byte)2);
            this.sAtts.payloadDataBuffer.putShort((short)l2);
        } else if (l2 <= 0xFFFFFFL) {
            T4CMAREngineNIO.valueToUNV(l2, this.tmpBuffer10);
            this.sAtts.payloadDataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        } else {
            this.sAtts.payloadDataBuffer.put((byte)4);
            this.sAtts.payloadDataBuffer.putInt((int)l2);
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalSB8(long l2) throws IOException {
        this.prepareForWriting();
        if (this.sAtts.payloadDataBuffer.remaining() < 9) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        if (this.types.rep[3] != 1) {
            throw new IOException("TODO: SB8 in UNV representation only");
        }
        T4CMAREngineNIO.valueToUNV(l2, this.tmpBuffer10);
        this.sAtts.payloadDataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
    }

    final void marshalUB8(long l2) throws IOException {
        this.prepareForWriting();
        if (this.sAtts.payloadDataBuffer.remaining() < 9) {
            this.nsDataChannel.writeDataToSocketChannel();
        }
        if (l2 == 0L) {
            this.sAtts.payloadDataBuffer.put((byte)0);
        }
        if (this.types.rep[3] != 1) {
            throw new IOException("TODO: UB8 in UNV representation only");
        }
        this.tmpBuffer10[0] = 0;
        int n2 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            byte by = (byte)(l2 >>> 8 * (7 - i2) & 0xFFL);
            if (by == 0) continue;
            this.tmpBuffer10[++n2] = by;
        }
        this.tmpBuffer10[0] = (byte)n2;
        this.sAtts.payloadDataBuffer.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
    }

    @Override
    final void marshalB1Array(byte[] byArray) throws IOException {
        this.marshalB1Array(byArray, 0, byArray.length);
    }

    @Override
    final void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        this.prepareForWriting();
        this.bytesWrittenSoFar = 0;
        this.bytesToWriteInNextCall = 0;
        while (this.bytesWrittenSoFar < n3) {
            if (this.sAtts.payloadDataBuffer.remaining() == 0) {
                this.nsDataChannel.writeDataToSocketChannel();
            }
            this.bytesToWriteInNextCall = Math.min(this.sAtts.payloadDataBuffer.remaining(), n3 - this.bytesWrittenSoFar);
            this.sAtts.payloadDataBuffer.put(byArray, n2 + this.bytesWrittenSoFar, this.bytesToWriteInNextCall);
            this.bytesWrittenSoFar += this.bytesToWriteInNextCall;
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalSB2();
        return by;
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        this.prepareForReading();
        short s2 = (short)(this.sAtts.payloadDataBuffer.get() & 0xFF);
        return s2;
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        this.prepareForReading();
        if (this.types.rep[1] != 1 && this.sAtts.payloadDataBuffer.remaining() >= 2) {
            return this.sAtts.payloadDataBuffer.getShort();
        }
        short s2 = (short)this.unmarshalUB2();
        return s2;
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        int n2 = (int)this.buffer2Value((byte)1);
        return n2 & 0xFFFF;
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        this.prepareForReading();
        if (this.types.rep[2] != 1 && this.sAtts.payloadDataBuffer.remaining() >= 4) {
            return this.sAtts.payloadDataBuffer.getInt();
        }
        return (int)this.buffer2Value((byte)2);
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        return (long)this.unmarshalSB4() & 0xFFFFFFFFL;
    }

    @Override
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        this.getNBytes(byArray, 0, n2);
        return byArray;
    }

    @Override
    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        return this.getNBytes(byArray, n2, n3);
    }

    @Override
    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        int n5;
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        boolean bl = false;
        this.prepareForReading();
        for (n4 = 0; n4 < n3; n4 += this.sAtts.payloadDataBuffer.position() - n5) {
            if (!this.sAtts.payloadDataBuffer.hasRemaining()) {
                this.prepareForReading();
            }
            n5 = this.sAtts.payloadDataBuffer.position();
            this.sAtts.payloadDataBuffer.get(byArray, n2 + n4, Math.min(n3 - n4, this.sAtts.payloadDataBuffer.remaining()));
        }
        return n4;
    }

    @Override
    byte[] getNBytes(int n2) throws SQLException, IOException {
        return this.unmarshalNBytes(n2);
    }

    @Override
    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            this.prepareForReading();
            byArray2[n3] = this.sAtts.payloadDataBuffer.get();
            if (byArray2[n3++] != 0) continue;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    @Override
    final long buffer2Value(byte by) throws SQLException, IOException {
        long l2 = 0L;
        byte by2 = this.types.rep[by];
        int n2 = 0;
        boolean bl = false;
        if (by2 == 1) {
            this.prepareForReading();
            n2 = this.sAtts.payloadDataBuffer.get();
            if (n2 == 0) {
                return 0L;
            }
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
        } else {
            switch (by) {
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 4;
                    break;
                }
                case 3: {
                    n2 = 8;
                }
            }
        }
        if (this.sAtts.payloadDataBuffer.remaining() >= n2 && (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8)) {
            this.prepareForReading();
            l2 = n2 == 1 ? (long)this.sAtts.payloadDataBuffer.get() & 0xFFL : (n2 == 2 ? (long)this.sAtts.payloadDataBuffer.getShort() & 0xFFFFL : (n2 == 4 ? (long)this.sAtts.payloadDataBuffer.getInt() & 0xFFFFFFFFL : this.sAtts.payloadDataBuffer.getLong()));
        } else {
            this.unmarshalNBytes(this.tmpBuffer8, 0, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (by2 == 1 || by2 != 2) {
                    l2 |= ((long)this.tmpBuffer8[i2] & 0xFFL) << 8 * (n2 - i2 - 1);
                    continue;
                }
                l2 |= ((long)this.tmpBuffer8[i2] & 0xFFL) << 8 * i2;
            }
        }
        if (bl) {
            l2 *= -1L;
        }
        return l2;
    }

    @Override
    void setByteOrder(byte by) {
        if (by == 2) {
            this.sAtts.payloadDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.sAtts.payloadDataBuffer.order(ByteOrder.BIG_ENDIAN);
        }
    }

    @Override
    protected void flush() throws IOException {
        this.nsDataChannel.writeDataToSocketChannel();
        this.bytesReadyToGo = false;
    }

    @Override
    void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        this.net.writeZeroCopyIO(byArray, n2, n3);
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

