/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CacheClear;
import com.microsoft.sqlserver.jdbc.EncryptionKeyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

final class SQLServerSymmetricKeyCache {
    static Object lock = new Object();
    private final ConcurrentHashMap<String, SQLServerSymmetricKey> cache = new ConcurrentHashMap();
    private static final SQLServerSymmetricKeyCache instance = new SQLServerSymmetricKeyCache();
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final Logger aeLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerSymmetricKeyCache");

    private SQLServerSymmetricKeyCache() {
    }

    static SQLServerSymmetricKeyCache getInstance() {
        return instance;
    }

    ConcurrentHashMap<String, SQLServerSymmetricKey> getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLServerSymmetricKey getKey(EncryptionKeyInfo encryptionKeyInfo, SQLServerConnection sQLServerConnection) throws SQLServerException {
        SQLServerSymmetricKey sQLServerSymmetricKey = null;
        Object object = lock;
        synchronized (object) {
            String string = sQLServerConnection.getTrustedServerNameAE();
            assert (null != string) : "serverName should not be null in getKey.";
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = null;
            stringBuffer.append(":");
            try {
                stringBuffer.append(DatatypeConverter.printBase64Binary((byte[])new String(encryptionKeyInfo.encryptedKey, "UTF-8").getBytes()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
                Object[] objectArray = new Object[]{"UTF-8"};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            stringBuffer.append(":");
            stringBuffer.append(encryptionKeyInfo.keyStoreName);
            string2 = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (aeLogger.isLoggable(Level.FINE)) {
                aeLogger.fine("Checking trusted master key path...");
            }
            Boolean[] booleanArray = new Boolean[1];
            List<String> list = SQLServerConnection.getColumnEncryptionTrustedMasterKeyPaths(string, booleanArray);
            if (booleanArray[0].booleanValue() && (null == list || 0 == list.size() || !list.contains(encryptionKeyInfo.keyPath))) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UntrustedKeyPath"));
                Object[] objectArray = new Object[]{encryptionKeyInfo.keyPath, string};
                throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
            }
            if (aeLogger.isLoggable(Level.FINE)) {
                aeLogger.fine("Checking Symmetric key cache...");
            }
            if (!this.cache.containsKey(string2)) {
                SQLServerColumnEncryptionKeyStoreProvider sQLServerColumnEncryptionKeyStoreProvider = sQLServerConnection.getSystemColumnEncryptionKeyStoreProvider(encryptionKeyInfo.keyStoreName);
                if (null == sQLServerColumnEncryptionKeyStoreProvider) {
                    sQLServerColumnEncryptionKeyStoreProvider = SQLServerConnection.getGlobalSystemColumnEncryptionKeyStoreProvider(encryptionKeyInfo.keyStoreName);
                }
                if (null == sQLServerColumnEncryptionKeyStoreProvider) {
                    sQLServerColumnEncryptionKeyStoreProvider = SQLServerConnection.getGlobalCustomColumnEncryptionKeyStoreProvider(encryptionKeyInfo.keyStoreName);
                }
                if (null == sQLServerColumnEncryptionKeyStoreProvider) {
                    String string3 = sQLServerConnection.getAllSystemColumnEncryptionKeyStoreProviders();
                    String string4 = SQLServerConnection.getAllGlobalCustomSystemColumnEncryptionKeyStoreProviders();
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_UnrecognizedKeyStoreProviderName"));
                    Object[] objectArray = new Object[]{encryptionKeyInfo.keyStoreName, string3, string4};
                    throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
                }
                byte[] byArray = sQLServerColumnEncryptionKeyStoreProvider.decryptColumnEncryptionKey(encryptionKeyInfo.keyPath, encryptionKeyInfo.algorithmName, encryptionKeyInfo.encryptedKey);
                sQLServerSymmetricKey = new SQLServerSymmetricKey(byArray);
                long l = SQLServerConnection.getColumnEncryptionKeyCacheTtl();
                if (0L != l) {
                    this.cache.putIfAbsent(string2, sQLServerSymmetricKey);
                    if (aeLogger.isLoggable(Level.FINE)) {
                        aeLogger.fine("Adding encryption key to cache...");
                    }
                    scheduler.schedule(new CacheClear(string2), l, TimeUnit.SECONDS);
                }
            } else {
                sQLServerSymmetricKey = this.cache.get(string2);
            }
        }
        return sQLServerSymmetricKey;
    }
}

