/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBDoubleField
extends FBField {
    FBDoubleField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Double value = new Double(this.field.decodeDouble(this.getFieldData()));
        if (value > 127.0 || value < -128.0) {
            throw (SQLException)FBDoubleField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    @Override
    public short getShort() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Double value = new Double(this.field.decodeDouble(this.getFieldData()));
        if (value > 32767.0 || value < -32768.0) {
            throw (SQLException)FBDoubleField.createException(SHORT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    @Override
    public int getInt() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Double value = new Double(this.field.decodeDouble(this.getFieldData()));
        if (value > 2.147483647E9 || value < -2.147483648E9) {
            throw (SQLException)FBDoubleField.createException(INT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        if (this.getFieldData() == null) {
            return 0L;
        }
        Double value = new Double(this.field.decodeDouble(this.getFieldData()));
        if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            throw (SQLException)FBDoubleField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.longValue();
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0f;
        }
        Double value = new Double(this.field.decodeDouble(this.getFieldData()));
        float cValue = value.floatValue();
        if (cValue == Float.POSITIVE_INFINITY || cValue == Float.NEGATIVE_INFINITY) {
            throw (SQLException)FBDoubleField.createException(FLOAT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.floatValue();
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0;
        }
        double result = this.field.decodeDouble(this.getFieldData());
        if (this.field.sqlscale != 0) {
            BigDecimal tempValue = new BigDecimal(result);
            tempValue = tempValue.setScale(Math.abs(this.field.sqlscale), 6);
            result = tempValue.doubleValue();
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.getFieldData() == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        BigDecimal result = new BigDecimal(this.field.decodeDouble(this.getFieldData()));
        if (this.field.sqlscale != 0) {
            result = result.setScale(Math.abs(this.field.sqlscale), 6);
        }
        return result;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.getFieldData() == null) {
            return false;
        }
        return this.field.decodeDouble(this.getFieldData()) == 1.0;
    }

    @Override
    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeDouble(this.getFieldData()));
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setDouble(Double.parseDouble(value));
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBDoubleField.createException(STRING_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setDouble(value ? 1.0 : 0.0);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setFieldData(this.field.encodeDouble(value));
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (value.compareTo(new BigDecimal(Double.MAX_VALUE)) > 0 || value.compareTo(new BigDecimal(-1.7976931348623157E308)) < 0) {
            throw (SQLException)FBDoubleField.createException(BIGDECIMAL_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setDouble(value.doubleValue());
    }
}

