/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.odftoolkit.odfdom.type.OdfDataType;

public class ZeroToHundredPercent
implements OdfDataType {
    private double mN;

    public ZeroToHundredPercent(double n) throws IllegalArgumentException {
        if (n > 1.0 || n < 0.0) {
            throw new IllegalArgumentException("parameter is invalidate for datatype ZeroToHundredPercent");
        }
        this.mN = n;
    }

    public String toString() {
        return Double.toString(this.mN * 100.0) + "%";
    }

    public static ZeroToHundredPercent valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null || stringValue.length() == 0) {
            return new ZeroToHundredPercent(0.0);
        }
        int n = stringValue.indexOf("%");
        if (n != -1) {
            return new ZeroToHundredPercent(Double.valueOf(stringValue.substring(0, n)) / 100.0);
        }
        throw new IllegalArgumentException("parameter is invalidate for datatype ZeroToHundredPercent");
    }

    public double doubleValue() {
        return this.mN;
    }

    public static boolean isValid(Double doubleValue) {
        return doubleValue != null && doubleValue <= 1.0 && doubleValue >= 0.0;
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && stringValue.matches("^([0-9]?[0-9](\\.[0-9]*)?|100(\\.0*)?|\\.[0-9]+)%$");
    }
}

