/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.number;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.number.OdfNumber;
import org.odftoolkit.odfdom.doc.number.OdfNumberCurrencySymbol;
import org.odftoolkit.odfdom.doc.number.OdfNumberText;
import org.odftoolkit.odfdom.doc.style.OdfStyleMap;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfNumberCurrencyStyle
extends NumberCurrencyStyleElement {
    public OdfNumberCurrencyStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberCurrencyStyle(OdfFileDom ownerDoc, String currencySymbol, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.buildFromFormat(currencySymbol, format);
    }

    public void buildFromFormat(String currencySymbol, String format) {
        Pattern p = Pattern.compile("[#0,.]+");
        Matcher m = p.matcher(format);
        if (m.find()) {
            char ch;
            int pos;
            String preMatch = format.substring(0, m.start());
            String numberSpec = format.substring(m.start(), m.end());
            String postMatch = format.substring(m.end());
            this.processText(preMatch, currencySymbol);
            OdfNumber number = new OdfNumber((OdfFileDom)((Object)this.getOwnerDocument()));
            int nDigits = 0;
            for (pos = 0; pos < numberSpec.length() && (ch = numberSpec.charAt(pos)) != '.'; ++pos) {
                if (ch == ',') {
                    number.setNumberGroupingAttribute(new Boolean(true));
                    continue;
                }
                if (ch != '0') continue;
                ++nDigits;
            }
            number.setNumberMinIntegerDigitsAttribute(nDigits);
            if (pos < numberSpec.length()) {
                number.setNumberDecimalPlacesAttribute(numberSpec.length() - (pos + 1));
            }
            this.appendChild((Node)((Object)number));
            this.processText(postMatch, currencySymbol);
        }
    }

    private void processText(String text, String currencySymbol) {
        OdfFileDom dom = (OdfFileDom)((Object)this.getOwnerDocument());
        int currencyPos = text.indexOf(currencySymbol);
        if (currencyPos >= 0) {
            this.emitText(text.substring(0, currencyPos));
            OdfNumberCurrencySymbol cSymbol = new OdfNumberCurrencySymbol(dom);
            cSymbol.appendChild(dom.createTextNode(currencySymbol));
            this.appendChild((Node)((Object)cSymbol));
            this.emitText(text.substring(currencyPos + 1));
        } else {
            this.emitText(text);
        }
    }

    private void emitText(String textBuffer) {
        if (!textBuffer.equals("")) {
            OdfNumberText textElement = new OdfNumberText((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    public OdfNumberCurrencySymbol getCurrencySymbolElement() {
        OdfNumberCurrencySymbol cSymbol = null;
        NodeList list = this.getElementsByTagNameNS(OdfNamespaceNames.NUMBER.getNamespaceUri(), "currency-symbol");
        if (list.getLength() > 0) {
            cSymbol = (OdfNumberCurrencySymbol)((Object)list.item(0));
        }
        return cSymbol;
    }

    public void setCurrencyLocale(String language, String country) {
        OdfNumberCurrencySymbol cSymbol = this.getCurrencySymbolElement();
        cSymbol.setNumberCountryAttribute(country);
        cSymbol.setNumberLanguageAttribute(language);
    }

    public void setCurrencyLocale(String locale) {
        OdfNumberCurrencySymbol cSymbol = this.getCurrencySymbolElement();
        int pos = locale.indexOf(45);
        if (pos >= 0) {
            cSymbol.setNumberLanguageAttribute(locale.substring(0, pos));
            cSymbol.setNumberCountryAttribute(locale.substring(pos + 1));
        } else {
            cSymbol.setNumberLanguageAttribute(locale);
        }
    }

    public void setMapPositive(String mapName) {
        OdfStyleMap map = new OdfStyleMap((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()>0");
        this.appendChild((Node)((Object)map));
    }

    public void setMapNegative(String mapName) {
        OdfStyleMap map = new OdfStyleMap((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()<0");
        this.appendChild((Node)((Object)map));
    }
}

