/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOMarkerPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NIOResendPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

abstract class NIOPacket {
    final NIOHeader header;
    public SessionAtts session;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    NIOPacket(SessionAtts sessionAtts) {
        this.session = sessionAtts;
        this.header = new NIOHeader(sessionAtts);
    }

    NIOPacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        this.header = nIOHeader;
        this.session = sessionAtts;
    }

    abstract void readPayloadBuffer() throws IOException;

    final void readFromSocketChannel(boolean bl) throws IOException {
        this.readFromSocketChannel(bl, true);
    }

    final void readFromSocketChannel(boolean bl, boolean bl2) throws IOException {
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            int n2 = ((MQLNTAdapter)this.session.nt).readFromLocalQueue(this.session.buffer);
            if (n2 >= 8) {
                this.session.headerBuffer.position(0);
                this.session.headerBuffer.limit(8);
                this.header.readNSHeader();
            }
            this.session.payloadBuffer.clear();
            this.session.payloadBuffer.limit(this.header.length - 8);
        } else {
            if (bl) {
                this.header.readHeaderBuffer();
            }
            this.session.payloadBuffer.clear();
            this.session.payloadBuffer.limit(this.header.length - 8);
            while (this.session.payloadBuffer.hasRemaining()) {
                this.session.socketChannel.read(this.session.payloadBuffer);
            }
            this.session.payloadBuffer.rewind();
        }
        if (bl2 && this.header.type == 12) {
            this.session.markerPacket.readPayloadBuffer();
            this.processMarker();
            this.session.onBreakReset = this.session.markerPacket.isBreakPkt();
            throw new BreakNetException(500);
        }
    }

    protected void processMarker() throws IOException, NetException, BreakNetException {
    }

    final void writeToSocketChannel() throws IOException {
        this.header.length = this.session.payloadBuffer.position() + 8;
        this.header.fillHeaderBuffer();
        this.session.buffer.clear();
        this.session.buffer.limit(this.session.payloadBuffer.position() + 8);
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.session.buffer);
        } else {
            while (this.session.buffer.hasRemaining()) {
                this.session.socketChannel.write(this.session.buffer);
            }
        }
        this.session.payloadBuffer.clear();
    }

    static NIOPacket readNIOPacket(SessionAtts sessionAtts) throws IOException {
        NIOPacket nIOPacket = null;
        NIOHeader nIOHeader = new NIOHeader(sessionAtts);
        if (sessionAtts.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            int n2 = ((MQLNTAdapter)sessionAtts.nt).readFromLocalQueue(sessionAtts.buffer);
            if (n2 >= 8) {
                sessionAtts.headerBuffer.position(0);
                sessionAtts.headerBuffer.limit(8);
                nIOHeader.readNSHeader();
            }
            sessionAtts.payloadBuffer.clear();
            sessionAtts.payloadBuffer.limit(nIOHeader.length - 8);
            sessionAtts.buffer.position(nIOHeader.length);
        } else {
            nIOHeader.readHeaderBuffer();
        }
        switch (nIOHeader.type) {
            case 2: {
                nIOPacket = new NIOAcceptPacket(nIOHeader, sessionAtts);
                break;
            }
            case 5: {
                nIOPacket = new NIORedirectPacket(nIOHeader, sessionAtts);
                break;
            }
            case 4: {
                nIOPacket = new NIORefusePacket(nIOHeader, sessionAtts);
                break;
            }
            case 11: {
                nIOPacket = new NIOResendPacket(nIOHeader, sessionAtts);
                break;
            }
            case 12: {
                nIOPacket = new NIOMarkerPacket(nIOHeader, sessionAtts);
                break;
            }
            default: {
                throw new NetException(204);
            }
        }
        if (sessionAtts.networkType != NTAdapter.NetworkAdapterType.MSGQ) {
            nIOPacket.readFromSocketChannel(false);
        }
        nIOPacket.readPayloadBuffer();
        return nIOPacket;
    }

    void reinitialize(SessionAtts sessionAtts) throws NetException {
        this.session = sessionAtts;
    }

    void addFlags(int n2) throws NetException {
        this.header.flags |= n2;
    }

    void setPoolEnabled(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.addFlags(1);
        }
    }

    void setLargeSDU(boolean bl) throws IOException, NetException, BreakNetException {
        if (bl) {
            this.addFlags(32);
        }
    }
}

