/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.office;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.number.OdfNumberBooleanStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberTextStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.doc.style.OdfStyle;
import org.odftoolkit.odfdom.doc.style.OdfStylePageLayout;
import org.odftoolkit.odfdom.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfOfficeAutomaticStyles
extends OfficeAutomaticStylesElement {
    private static final long serialVersionUID = -2925910664631016175L;
    private HashMap<String, OdfStylePageLayout> mPageLayouts;
    private OdfStylesBase mStylesBaseImpl = new OdfStylesBase();

    public OdfOfficeAutomaticStyles(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfStyle newStyle(OdfStyleFamily styleFamily) {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfStyle newStyle = dom.newOdfElement(OdfStyle.class);
        newStyle.setStyleFamilyAttribute(styleFamily.getName());
        newStyle.setStyleNameAttribute(this.newUniqueStyleName(styleFamily));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfTextListStyle newListStyle() {
        OdfFileDom dom = (OdfFileDom)this.ownerDocument;
        OdfTextListStyle newStyle = dom.newOdfElement(OdfTextListStyle.class);
        newStyle.setStyleNameAttribute(this.newUniqueStyleName(OdfStyleFamily.List));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfStylePageLayout getPageLayout(String name) {
        if (this.mPageLayouts != null) {
            return this.mPageLayouts.get(name);
        }
        return null;
    }

    public OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        return this.mStylesBaseImpl.getStyle(name, familyType);
    }

    public Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        return this.mStylesBaseImpl.getStylesForFamily(familyType);
    }

    public OdfTextListStyle getListStyle(String name) {
        return this.mStylesBaseImpl.getListStyle(name);
    }

    public Iterable<OdfTextListStyle> getListStyles() {
        return this.mStylesBaseImpl.getListStyles();
    }

    public OdfNumberStyle getNumberStyle(String name) {
        return this.mStylesBaseImpl.getNumberStyle(name);
    }

    public Iterable<OdfNumberStyle> getNumberStyles() {
        return this.mStylesBaseImpl.getNumberStyles();
    }

    public OdfNumberDateStyle getDateStyle(String name) {
        return this.mStylesBaseImpl.getDateStyle(name);
    }

    public Iterable<OdfNumberDateStyle> getDateStyles() {
        return this.mStylesBaseImpl.getDateStyles();
    }

    public OdfNumberPercentageStyle getPercentageStyle(String name) {
        return this.mStylesBaseImpl.getPercentageStyle(name);
    }

    public Iterable<OdfNumberPercentageStyle> getPercentageStyles() {
        return this.mStylesBaseImpl.getPercentageStyles();
    }

    public OdfNumberCurrencyStyle getCurrencyStyle(String name) {
        return this.mStylesBaseImpl.getCurrencyStyle(name);
    }

    public Iterable<OdfNumberCurrencyStyle> getCurrencyStyles() {
        return this.mStylesBaseImpl.getCurrencyStyles();
    }

    public OdfNumberTimeStyle getTimeStyle(String name) {
        return this.mStylesBaseImpl.getTimeStyle(name);
    }

    public Iterable<OdfNumberTimeStyle> getTimeStyles() {
        return this.mStylesBaseImpl.getTimeStyles();
    }

    public OdfNumberBooleanStyle getBooleanStyle(String name) {
        return this.mStylesBaseImpl.getBooleanStyle(name);
    }

    public Iterable<OdfNumberBooleanStyle> getBooleanStyles() {
        return this.mStylesBaseImpl.getBooleanStyles();
    }

    public OdfNumberTextStyle getTextStyle(String name) {
        return this.mStylesBaseImpl.getTextStyle(name);
    }

    public Iterable<OdfNumberTextStyle> getTextStyles() {
        return this.mStylesBaseImpl.getTextStyles();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfStylePageLayout) {
            OdfStylePageLayout pageLayout = (OdfStylePageLayout)node;
            if (this.mPageLayouts == null) {
                this.mPageLayouts = new HashMap();
            }
            this.mPageLayouts.put(pageLayout.getStyleNameAttribute(), pageLayout);
        } else {
            this.mStylesBaseImpl.onOdfNodeInserted(node, refNode);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfStylePageLayout) {
            if (this.mPageLayouts != null) {
                OdfStylePageLayout pageLayout = (OdfStylePageLayout)node;
                this.mPageLayouts.remove(pageLayout.getStyleNameAttribute());
            }
        } else {
            this.mStylesBaseImpl.onOdfNodeRemoved(node);
        }
    }

    public void optimize() {
        Iterator<OdfStyle> iter = this.mStylesBaseImpl.getAllOdfStyles().iterator();
        TreeSet<OdfStyle> stylesSet = new TreeSet<OdfStyle>();
        while (iter.hasNext()) {
            OdfStyle found;
            OdfStyle cur = iter.next();
            if (cur.getStyleUserCount() < 1) continue;
            SortedSet<OdfStyle> tail = stylesSet.tailSet(cur);
            OdfStyle odfStyle = found = tail.size() > 0 ? tail.first() : null;
            if (found != null && found.equals(cur)) {
                Iterator<OdfStylableElement> styleUsersIter = cur.getStyleUsers().iterator();
                ArrayList<OdfStylableElement> styleUsers = new ArrayList<OdfStylableElement>();
                while (styleUsersIter.hasNext()) {
                    styleUsers.add(styleUsersIter.next());
                }
                for (OdfStylableElement elem : styleUsers) {
                    OdfStyle autoStyle = elem.getAutomaticStyle();
                    if (autoStyle == null) continue;
                    elem.setStyleName(found.getStyleNameAttribute());
                }
                continue;
            }
            stylesSet.add(cur);
        }
        OdfStyle style = OdfElement.findFirstChildNode(OdfStyle.class, (Node)((Object)this));
        while (style != null) {
            OdfStyle nextStyle = OdfElement.findNextChildNode(OdfStyle.class, (Node)((Object)style));
            if (style.getStyleUserCount() < 1) {
                this.removeChild((Node)((Object)style));
            }
            style = nextStyle;
        }
    }

    public OdfStyle makeStyleUnique(OdfStyle referenceStyle) {
        OdfStyle newStyle = null;
        newStyle = referenceStyle.getOwnerDocument() != this.getOwnerDocument() ? (OdfStyle)((Object)this.getOwnerDocument().importNode((Node)((Object)referenceStyle), true)) : (OdfStyle)((Object)referenceStyle.cloneNode(true));
        newStyle.setStyleNameAttribute(this.newUniqueStyleName(newStyle.getFamily()));
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    private String newUniqueStyleName(OdfStyleFamily styleFamily) {
        String unique_name;
        if (styleFamily.equals(OdfStyleFamily.List)) {
            while (this.getListStyle(unique_name = String.format("l%06x", (int)(Math.random() * 1.6777215E7))) != null) {
            }
        } else {
            while (this.getStyle(unique_name = String.format("a%06x", (int)(Math.random() * 1.6777215E7)), styleFamily) != null) {
            }
        }
        return unique_name;
    }
}

