/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.office;

import java.util.ArrayList;
import java.util.HashMap;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.doc.number.OdfNumberBooleanStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberTextStyle;
import org.odftoolkit.odfdom.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.doc.style.OdfStyle;
import org.odftoolkit.odfdom.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OdfStylesBase {
    private HashMap<OdfStyleFamily, ArrayList<OdfStyle>> mStyles;
    private ArrayList<OdfTextListStyle> mListStyles;
    private ArrayList<OdfNumberStyle> mNumberStyles;
    private ArrayList<OdfNumberDateStyle> mDateStyles;
    private ArrayList<OdfNumberPercentageStyle> mPercentageStyles;
    private ArrayList<OdfNumberCurrencyStyle> mCurrencyStyles;
    private ArrayList<OdfNumberTimeStyle> mTimeStyles;
    private ArrayList<OdfNumberBooleanStyle> mBooleanStyles;
    private ArrayList<OdfNumberTextStyle> mTextStyles;

    OdfStylesBase() {
    }

    OdfStyle getStyle(String name, OdfStyleFamily familyType) {
        ArrayList<OdfStyle> familyMap;
        if (this.mStyles != null && (familyMap = this.mStyles.get(familyType)) != null) {
            for (OdfStyle odfStyleStyle : familyMap) {
                if (!odfStyleStyle.getStyleNameAttribute().equals(name)) continue;
                return odfStyleStyle;
            }
        }
        return null;
    }

    Iterable<OdfStyle> getAllOdfStyles() {
        ArrayList<OdfStyle> allStyles = new ArrayList<OdfStyle>();
        if (this.mStyles != null) {
            for (OdfStyleFamily family : this.mStyles.keySet()) {
                ArrayList<OdfStyle> familySet = this.mStyles.get(family);
                if (familySet == null) continue;
                allStyles.addAll(familySet);
            }
        }
        return allStyles;
    }

    Iterable<OdfStyle> getStylesForFamily(OdfStyleFamily familyType) {
        ArrayList<OdfStyle> familyStyles;
        if (this.mStyles != null && (familyStyles = this.mStyles.get(familyType)) != null) {
            return familyStyles;
        }
        return new ArrayList<OdfStyle>();
    }

    OdfTextListStyle getListStyle(String name) {
        if (this.mListStyles != null) {
            for (OdfTextListStyle odfTextListStyle : this.mListStyles) {
                if (!odfTextListStyle.getStyleNameAttribute().equals(name)) continue;
                return odfTextListStyle;
            }
        }
        return null;
    }

    Iterable<OdfTextListStyle> getListStyles() {
        if (this.mListStyles != null) {
            return this.mListStyles;
        }
        return new ArrayList<OdfTextListStyle>();
    }

    OdfNumberStyle getNumberStyle(String name) {
        if (this.mNumberStyles != null) {
            for (OdfNumberStyle odfNumberStyle : this.mNumberStyles) {
                if (!odfNumberStyle.getStyleNameAttribute().equals(name)) continue;
                return odfNumberStyle;
            }
        }
        return null;
    }

    Iterable<OdfNumberStyle> getNumberStyles() {
        if (this.mNumberStyles != null) {
            return this.mNumberStyles;
        }
        return new ArrayList<OdfNumberStyle>();
    }

    OdfNumberDateStyle getDateStyle(String name) {
        if (this.mDateStyles != null) {
            for (OdfNumberDateStyle odfNumberDateStyle : this.mDateStyles) {
                if (!odfNumberDateStyle.getStyleNameAttribute().equals(name)) continue;
                return odfNumberDateStyle;
            }
        }
        return null;
    }

    Iterable<OdfNumberDateStyle> getDateStyles() {
        if (this.mDateStyles != null) {
            return this.mDateStyles;
        }
        return new ArrayList<OdfNumberDateStyle>();
    }

    OdfNumberPercentageStyle getPercentageStyle(String name) {
        if (this.mPercentageStyles != null) {
            for (OdfNumberPercentageStyle odfNumberPercentageStyle : this.mPercentageStyles) {
                if (!odfNumberPercentageStyle.getStyleNameAttribute().equals(name)) continue;
                return odfNumberPercentageStyle;
            }
        }
        return null;
    }

    Iterable<OdfNumberPercentageStyle> getPercentageStyles() {
        if (this.mPercentageStyles != null) {
            return this.mPercentageStyles;
        }
        return new ArrayList<OdfNumberPercentageStyle>();
    }

    OdfNumberCurrencyStyle getCurrencyStyle(String name) {
        if (this.mCurrencyStyles != null) {
            for (OdfNumberCurrencyStyle odfNumberCurrencyStyle : this.mCurrencyStyles) {
                if (!odfNumberCurrencyStyle.getStyleNameAttribute().equals(name)) continue;
                return odfNumberCurrencyStyle;
            }
        }
        return null;
    }

    Iterable<OdfNumberCurrencyStyle> getCurrencyStyles() {
        if (this.mCurrencyStyles != null) {
            return this.mCurrencyStyles;
        }
        return new ArrayList<OdfNumberCurrencyStyle>();
    }

    OdfNumberTimeStyle getTimeStyle(String name) {
        if (this.mTimeStyles != null) {
            for (OdfNumberTimeStyle odfNumberTimeStyle : this.mTimeStyles) {
                if (!odfNumberTimeStyle.getStyleNameAttribute().equals(name)) continue;
                return odfNumberTimeStyle;
            }
        }
        return null;
    }

    Iterable<OdfNumberTimeStyle> getTimeStyles() {
        if (this.mTimeStyles != null) {
            return this.mTimeStyles;
        }
        return new ArrayList<OdfNumberTimeStyle>();
    }

    OdfNumberBooleanStyle getBooleanStyle(String name) {
        if (this.mBooleanStyles != null) {
            for (OdfNumberBooleanStyle odfNumberBooleanStyle : this.mBooleanStyles) {
                if (!odfNumberBooleanStyle.getStyleNameAttribute().equals(name)) continue;
                return odfNumberBooleanStyle;
            }
        }
        return null;
    }

    Iterable<OdfNumberBooleanStyle> getBooleanStyles() {
        if (this.mBooleanStyles != null) {
            return this.mBooleanStyles;
        }
        return new ArrayList<OdfNumberBooleanStyle>();
    }

    OdfNumberTextStyle getTextStyle(String name) {
        if (this.mTextStyles != null) {
            for (OdfNumberTextStyle odfNumberTextStyle : this.mTextStyles) {
                if (!odfNumberTextStyle.getStyleNameAttribute().equals(name)) continue;
                return odfNumberTextStyle;
            }
        }
        return null;
    }

    Iterable<OdfNumberTextStyle> getTextStyles() {
        if (this.mTextStyles != null) {
            return this.mTextStyles;
        }
        return new ArrayList<OdfNumberTextStyle>();
    }

    void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfStyle) {
            ArrayList<OdfStyle> familyMap;
            OdfStyle style = (OdfStyle)node;
            if (this.mStyles == null) {
                this.mStyles = new HashMap();
            }
            if ((familyMap = this.mStyles.get(style.getFamily())) == null) {
                familyMap = new ArrayList();
                this.mStyles.put(style.getFamily(), familyMap);
            }
            OdfStylesBase.addStyleToList(familyMap, style);
        } else if (node instanceof OdfTextListStyle) {
            this.mListStyles = OdfStylesBase.addStyleToList(this.mListStyles, (OdfTextListStyle)node);
        } else if (node instanceof OdfNumberStyle) {
            this.mNumberStyles = OdfStylesBase.addStyleToList(this.mNumberStyles, (OdfNumberStyle)node);
        } else if (node instanceof OdfNumberDateStyle) {
            this.mDateStyles = OdfStylesBase.addStyleToList(this.mDateStyles, (OdfNumberDateStyle)node);
        } else if (node instanceof OdfNumberPercentageStyle) {
            this.mPercentageStyles = OdfStylesBase.addStyleToList(this.mPercentageStyles, (OdfNumberPercentageStyle)node);
        } else if (node instanceof OdfNumberCurrencyStyle) {
            this.mCurrencyStyles = OdfStylesBase.addStyleToList(this.mCurrencyStyles, (OdfNumberCurrencyStyle)node);
        } else if (node instanceof OdfNumberTimeStyle) {
            this.mTimeStyles = OdfStylesBase.addStyleToList(this.mTimeStyles, (OdfNumberTimeStyle)node);
        } else if (node instanceof OdfNumberBooleanStyle) {
            this.mBooleanStyles = OdfStylesBase.addStyleToList(this.mBooleanStyles, (OdfNumberBooleanStyle)node);
        } else if (node instanceof OdfNumberTextStyle) {
            this.mTextStyles = OdfStylesBase.addStyleToList(this.mTextStyles, (OdfNumberTextStyle)node);
        }
    }

    void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfStyle) {
            if (this.mStyles != null) {
                OdfStyle style = (OdfStyle)node;
                ArrayList<OdfStyle> familyMap = this.mStyles.get(style.getFamily());
                OdfStylesBase.removeOdfStyleFromList(familyMap, style);
                if (familyMap != null && familyMap.isEmpty()) {
                    this.mStyles.remove(style.getFamily());
                }
            }
        } else if (node instanceof OdfTextListStyle) {
            OdfStylesBase.removeStyleFromList(this.mListStyles, (OdfTextListStyle)node);
        } else if (node instanceof OdfNumberStyle) {
            OdfStylesBase.removeStyleFromList(this.mNumberStyles, (OdfNumberStyle)node);
        } else if (node instanceof OdfNumberDateStyle) {
            OdfStylesBase.removeStyleFromList(this.mDateStyles, (OdfNumberDateStyle)node);
        } else if (node instanceof OdfNumberPercentageStyle) {
            OdfStylesBase.removeStyleFromList(this.mPercentageStyles, (OdfNumberPercentageStyle)node);
        } else if (node instanceof OdfNumberCurrencyStyle) {
            OdfStylesBase.removeStyleFromList(this.mCurrencyStyles, (OdfNumberCurrencyStyle)node);
        } else if (node instanceof OdfNumberTimeStyle) {
            OdfStylesBase.removeStyleFromList(this.mTimeStyles, (OdfNumberTimeStyle)node);
        } else if (node instanceof OdfNumberBooleanStyle) {
            OdfStylesBase.removeStyleFromList(this.mBooleanStyles, (OdfNumberBooleanStyle)node);
        } else if (node instanceof OdfNumberTextStyle) {
            OdfStylesBase.removeStyleFromList(this.mTextStyles, (OdfNumberTextStyle)node);
        }
    }

    private static <T> ArrayList<T> addStyleToList(ArrayList<T> list, T style) {
        if (list == null) {
            list = new ArrayList();
        }
        list.add(style);
        return list;
    }

    private static <T> void removeStyleFromList(ArrayList<T> list, T style) {
        if (list != null) {
            list.remove(style);
        }
    }

    private static void removeOdfStyleFromList(ArrayList<OdfStyle> list, OdfStyle style) {
        if (list != null) {
            int index = 0;
            ArrayList<OdfStyle> removed = new ArrayList<OdfStyle>();
            while ((index = list.indexOf(style)) != -1) {
                OdfStyle removedStyle = list.remove(index);
                if (style.getStyleNameAttribute().equals(removedStyle.getStyleNameAttribute())) continue;
                removed.add(removedStyle);
            }
            list.addAll(removed);
        }
    }
}

