/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.office;

import java.util.ArrayList;
import java.util.Iterator;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.draw.OdfDrawPage;
import org.odftoolkit.odfdom.dom.element.office.OfficePresentationElement;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfOfficePresentation
extends OfficePresentationElement {
    private ArrayList<OdfDrawPage> mPages;

    public OdfOfficePresentation(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfDrawPage getPageAt(int index) {
        if (this.mPages != null || this.mPages.size() <= index) {
            return this.mPages.get(index);
        }
        return null;
    }

    public int getPageCount() {
        if (this.mPages != null) {
            return this.mPages.size();
        }
        return 0;
    }

    public OdfDrawPage getPage(String name) {
        if (this.mPages != null) {
            for (OdfDrawPage page : this.mPages) {
                if (!page.getDrawNameAttribute().equals(name)) continue;
                return page;
            }
        }
        return null;
    }

    public Iterator<OdfDrawPage> getPages() {
        if (this.mPages != null) {
            return this.mPages.iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    protected void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfDrawPage) {
            OdfDrawPage page = (OdfDrawPage)node;
            if (this.mPages == null) {
                this.mPages = new ArrayList();
            } else if (refNode != null) {
                int index = -1;
                OdfDrawPage refPage = OdfOfficePresentation.findPreviousChildNode(OdfDrawPage.class, (Node)((Object)node));
                if (refPage != null) {
                    index = this.mPages.indexOf(refPage);
                }
                this.mPages.add(index + 1, page);
                return;
            }
            this.mPages.add(page);
        }
    }

    @Override
    protected void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfDrawPage && this.mPages != null) {
            OdfDrawPage page = (OdfDrawPage)node;
            this.mPages.remove(page);
        }
    }
}

