/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import microsoft.sql.DateTimeOffset;

public class SQLServerBulkCopy
implements AutoCloseable {
    private static final String loggerClassName = "com.microsoft.sqlserver.jdbc.SQLServerBulkCopy";
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerBulkCopy");
    private SQLServerConnection connection;
    private SQLServerBulkCopyOptions copyOptions;
    private List<ColumnMapping> columnMappings;
    private boolean ownsConnection;
    private String destinationTableName;
    private ISQLServerBulkRecord sourceBulkRecord;
    private ResultSet sourceResultSet;
    private ResultSetMetaData sourceResultSetMetaData;
    private Map<Integer, BulkColumnMetaData> destColumnMetadata;
    private Map<Integer, BulkColumnMetaData> srcColumnMetadata;
    private int destColumnCount;
    private int srcColumnCount;
    private BulkTimeoutTimer timeoutTimer = null;

    public SQLServerBulkCopy(Connection connection) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "SQLServerBulkCopy", connection);
        if (null == connection || !connection.getClass().equals(SQLServerConnection.class)) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDestConnection"), null, false);
        }
        this.connection = (SQLServerConnection)connection;
        this.ownsConnection = false;
        this.copyOptions = new SQLServerBulkCopyOptions();
        this.initializeDefaults();
        loggerExternal.exiting(loggerClassName, "SQLServerBulkCopy");
    }

    public SQLServerBulkCopy(String string) throws SQLException {
        loggerExternal.entering(loggerClassName, "SQLServerBulkCopy", "connectionUrl not traced.");
        if (string == null || string.trim().equals("")) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_nullConnection"), null, 0, false);
        }
        this.ownsConnection = true;
        SQLServerDriver sQLServerDriver = new SQLServerDriver();
        this.connection = (SQLServerConnection)sQLServerDriver.connect(string, null);
        if (null == this.connection) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_invalidConnection"), null, 0, false);
        }
        this.copyOptions = new SQLServerBulkCopyOptions();
        this.initializeDefaults();
        loggerExternal.exiting(loggerClassName, "SQLServerBulkCopy");
    }

    public void addColumnMapping(int n, int n2) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{n, n2});
        if (0 >= n) {
            this.throwInvalidArgument("sourceColumn");
        } else if (0 >= n2) {
            this.throwInvalidArgument("destinationColumn");
        }
        this.columnMappings.add(new ColumnMapping(n, n2));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void addColumnMapping(int n, String string) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{n, string});
        if (0 >= n) {
            this.throwInvalidArgument("sourceColumn");
        } else if (null == string || string.isEmpty()) {
            this.throwInvalidArgument("destinationColumn");
        }
        this.columnMappings.add(new ColumnMapping(n, string.trim()));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void addColumnMapping(String string, int n) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{string, n});
        if (0 >= n) {
            this.throwInvalidArgument("destinationColumn");
        } else if (null == string || string.isEmpty()) {
            this.throwInvalidArgument("sourceColumn");
        }
        this.columnMappings.add(new ColumnMapping(string.trim(), n));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void addColumnMapping(String string, String string2) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMapping", new Object[]{string, string2});
        if (null == string || string.isEmpty()) {
            this.throwInvalidArgument("sourceColumn");
        } else if (null == string2 || string2.isEmpty()) {
            this.throwInvalidArgument("destinationColumn");
        }
        this.columnMappings.add(new ColumnMapping(string.trim(), string2.trim()));
        loggerExternal.exiting(loggerClassName, "addColumnMapping");
    }

    public void clearColumnMappings() {
        loggerExternal.entering(loggerClassName, "clearColumnMappings");
        this.columnMappings.clear();
        loggerExternal.exiting(loggerClassName, "clearColumnMappings");
    }

    @Override
    public void close() {
        loggerExternal.entering(loggerClassName, "close");
        if (this.ownsConnection) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        loggerExternal.exiting(loggerClassName, "close");
    }

    public String getDestinationTableName() {
        return this.destinationTableName;
    }

    public void setDestinationTableName(String string) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "setDestinationTableName", string);
        if (null == string || 0 == string.trim().length()) {
            this.throwInvalidArgument("tableName");
        }
        this.destinationTableName = string.trim();
        loggerExternal.exiting(loggerClassName, "setDestinationTableName");
    }

    public SQLServerBulkCopyOptions getBulkCopyOptions() {
        return this.copyOptions;
    }

    public void setBulkCopyOptions(SQLServerBulkCopyOptions sQLServerBulkCopyOptions) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "updateBulkCopyOptions", sQLServerBulkCopyOptions);
        if (!this.ownsConnection && sQLServerBulkCopyOptions.isUseInternalTransaction()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidTransactionOption"), null, false);
        }
        this.copyOptions = sQLServerBulkCopyOptions;
        loggerExternal.exiting(loggerClassName, "updateBulkCopyOptions");
    }

    public void writeToServer(ResultSet resultSet) throws SQLServerException {
        this.writeResultSet(resultSet, false);
    }

    public void writeToServer(RowSet rowSet) throws SQLServerException {
        this.writeResultSet(rowSet, true);
    }

    private void writeResultSet(ResultSet resultSet, boolean bl) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "writeToServer");
        if (null == resultSet) {
            this.throwInvalidArgument("sourceData");
        }
        try {
            if (bl) {
                if (!resultSet.isBeforeFirst()) {
                    resultSet.beforeFirst();
                }
            } else if (resultSet.isClosed()) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_resultsetClosed"), null, false);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(null, sQLException.getMessage(), null, 0, false);
        }
        this.sourceResultSet = resultSet;
        this.sourceBulkRecord = null;
        try {
            this.sourceResultSetMetaData = this.sourceResultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
        }
        this.writeToServer();
        loggerExternal.exiting(loggerClassName, "writeToServer");
    }

    public void writeToServer(ISQLServerBulkRecord iSQLServerBulkRecord) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "writeToServer");
        if (null == iSQLServerBulkRecord) {
            this.throwInvalidArgument("sourceData");
        }
        this.sourceBulkRecord = iSQLServerBulkRecord;
        this.sourceResultSet = null;
        this.writeToServer();
        loggerExternal.exiting(loggerClassName, "writeToServer");
    }

    private void initializeDefaults() {
        this.columnMappings = new LinkedList<ColumnMapping>();
        this.destinationTableName = null;
        this.sourceBulkRecord = null;
        this.sourceResultSet = null;
        this.sourceResultSetMetaData = null;
        this.srcColumnCount = 0;
        this.srcColumnMetadata = null;
        this.destColumnMetadata = null;
        this.destColumnCount = 0;
    }

    private void sendBulkLoadBCP() throws SQLServerException {
        final class InsertBulk
        extends TDSCommand {
            InsertBulk() {
                super("InsertBulk", 0);
                int n = SQLServerBulkCopy.this.copyOptions.getBulkCopyTimeout();
                SQLServerBulkCopy.this.timeoutTimer = n > 0 ? new BulkTimeoutTimer(n, this) : null;
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                if (null != SQLServerBulkCopy.this.timeoutTimer) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": Starting bulk timer...");
                    }
                    SQLServerBulkCopy.this.timeoutTimer.start();
                }
                try {
                    while (SQLServerBulkCopy.this.doInsertBulk(this)) {
                    }
                }
                catch (SQLServerException sQLServerException) {
                    Throwable throwable = sQLServerException;
                    while (null != throwable.getCause()) {
                        throwable = throwable.getCause();
                    }
                    if (throwable instanceof SQLException) {
                        SQLServerBulkCopy.this.checkForTimeoutException(throwable, SQLServerBulkCopy.this.timeoutTimer);
                    }
                    throw sQLServerException;
                }
                if (null != SQLServerBulkCopy.this.timeoutTimer) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.toString() + ": Stopping bulk timer...");
                    }
                    SQLServerBulkCopy.this.timeoutTimer.stop();
                }
                return true;
            }
        }
        this.connection.executeCommand(new InsertBulk());
    }

    private final void writeColumnMetaDataColumnData(TDSWriter tDSWriter, int n) throws SQLServerException {
        boolean bl;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        SQLCollation sQLCollation = null;
        SSType sSType = null;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        tDSWriter.writeBytes(byArray);
        byte[] byArray2 = new byte[2];
        int n7 = this.columnMappings.get((int)n).destinationColumnOrdinal;
        byArray2 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n7)).flags;
        tDSWriter.writeBytes(byArray2);
        n4 = this.columnMappings.get((int)n).sourceColumnOrdinal;
        n5 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n4)).jdbcType;
        n2 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n4)).precision;
        n3 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n4)).scale;
        boolean bl2 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n4)).isNullable;
        sSType = this.destColumnMetadata.get((Object)Integer.valueOf((int)n7)).ssType;
        n6 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n7)).precision;
        n2 = this.validateSourcePrecision(n2, n5, n6);
        sQLCollation = this.destColumnMetadata.get((Object)Integer.valueOf((int)n7)).collation;
        if (null == sQLCollation) {
            sQLCollation = this.connection.getDatabaseCollation();
        }
        if (-15 == n5 || -9 == n5 || -16 == n5) {
            bl = 4000 < n2 || 4000 < n6;
        } else {
            boolean bl3 = bl = 8000 < n2 || 8000 < n6;
        }
        if (!(1 != n5 && 12 != n5 && -1 != n5 || SSType.BINARY != sSType && SSType.VARBINARY != sSType && SSType.VARBINARYMAX != sSType && SSType.IMAGE != sSType)) {
            if (bl) {
                tDSWriter.writeByte((byte)-91);
            } else {
                tDSWriter.writeByte((byte)(SSType.BINARY == sSType ? 173 : 165));
            }
            tDSWriter.writeShort((short)n2);
        } else {
            block0 : switch (n5) {
                case 4: {
                    if (!bl2) {
                        tDSWriter.writeByte(TDSType.INT4.byteValue());
                        break;
                    }
                    tDSWriter.writeByte(TDSType.INTN.byteValue());
                    tDSWriter.writeByte((byte)4);
                    break;
                }
                case -5: {
                    if (!bl2) {
                        tDSWriter.writeByte(TDSType.INT8.byteValue());
                        break;
                    }
                    tDSWriter.writeByte(TDSType.INTN.byteValue());
                    tDSWriter.writeByte((byte)8);
                    break;
                }
                case -7: {
                    if (!bl2) {
                        tDSWriter.writeByte(TDSType.BIT1.byteValue());
                        break;
                    }
                    tDSWriter.writeByte(TDSType.BITN.byteValue());
                    tDSWriter.writeByte((byte)1);
                    break;
                }
                case 5: {
                    if (!bl2) {
                        tDSWriter.writeByte(TDSType.INT2.byteValue());
                        break;
                    }
                    tDSWriter.writeByte(TDSType.INTN.byteValue());
                    tDSWriter.writeByte((byte)2);
                    break;
                }
                case -6: {
                    if (!bl2) {
                        tDSWriter.writeByte(TDSType.INT1.byteValue());
                        break;
                    }
                    tDSWriter.writeByte(TDSType.INTN.byteValue());
                    tDSWriter.writeByte((byte)1);
                    break;
                }
                case 8: {
                    if (!bl2) {
                        tDSWriter.writeByte(TDSType.FLOAT8.byteValue());
                        break;
                    }
                    tDSWriter.writeByte(TDSType.FLOATN.byteValue());
                    tDSWriter.writeByte((byte)8);
                    break;
                }
                case 7: {
                    if (!bl2) {
                        tDSWriter.writeByte(TDSType.FLOAT4.byteValue());
                        break;
                    }
                    tDSWriter.writeByte(TDSType.FLOATN.byteValue());
                    tDSWriter.writeByte((byte)4);
                    break;
                }
                case 2: 
                case 3: {
                    if (3 == n5) {
                        tDSWriter.writeByte(TDSType.DECIMALN.byteValue());
                    } else {
                        tDSWriter.writeByte(TDSType.NUMERICN.byteValue());
                    }
                    tDSWriter.writeByte((byte)17);
                    tDSWriter.writeByte((byte)n2);
                    tDSWriter.writeByte((byte)n3);
                    break;
                }
                case 1: {
                    tDSWriter.writeByte(TDSType.BIGCHAR.byteValue());
                    tDSWriter.writeShort((short)n2);
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                case -15: {
                    tDSWriter.writeByte(TDSType.NCHAR.byteValue());
                    tDSWriter.writeShort((short)(2 * n2));
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                case -1: 
                case 12: {
                    tDSWriter.writeByte(TDSType.BIGVARCHAR.byteValue());
                    if (bl) {
                        tDSWriter.writeShort((short)-1);
                    } else {
                        tDSWriter.writeShort((short)n2);
                    }
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                case -16: 
                case -9: {
                    tDSWriter.writeByte(TDSType.NVARCHAR.byteValue());
                    if (bl) {
                        tDSWriter.writeShort((short)-1);
                    } else {
                        tDSWriter.writeShort((short)(2 * n2));
                    }
                    sQLCollation.writeCollation(tDSWriter);
                    break;
                }
                case -2: {
                    tDSWriter.writeByte(TDSType.BIGBINARY.byteValue());
                    tDSWriter.writeShort((short)n2);
                    break;
                }
                case -4: 
                case -3: {
                    tDSWriter.writeByte(TDSType.BIGVARBINARY.byteValue());
                    if (bl) {
                        tDSWriter.writeShort((short)-1);
                        break;
                    }
                    tDSWriter.writeShort((short)n2);
                    break;
                }
                case 93: {
                    switch (sSType) {
                        case SMALLDATETIME: {
                            if (!bl2) {
                                tDSWriter.writeByte(TDSType.DATETIME4.byteValue());
                                break block0;
                            }
                            tDSWriter.writeByte(TDSType.DATETIMEN.byteValue());
                            tDSWriter.writeByte((byte)n3);
                            break block0;
                        }
                        case DATETIME: {
                            if (!bl2) {
                                tDSWriter.writeByte(TDSType.DATETIME8.byteValue());
                                break block0;
                            }
                            tDSWriter.writeByte(TDSType.DATETIMEN.byteValue());
                            tDSWriter.writeByte((byte)n3);
                            break block0;
                        }
                    }
                    tDSWriter.writeByte(TDSType.DATETIME2N.byteValue());
                    tDSWriter.writeByte((byte)n3);
                    break;
                }
                case 91: {
                    tDSWriter.writeByte(TDSType.DATEN.byteValue());
                    break;
                }
                case 92: {
                    tDSWriter.writeByte(TDSType.TIMEN.byteValue());
                    tDSWriter.writeByte((byte)n3);
                    break;
                }
                case -155: 
                case 2013: 
                case 2014: {
                    tDSWriter.writeByte(TDSType.DATETIMEOFFSETN.byteValue());
                    tDSWriter.writeByte((byte)n3);
                    break;
                }
                default: {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
                    String string = JDBCType.of(n5).toString().toLowerCase();
                    throw new SQLServerException(messageFormat.format(new Object[]{string}), null, 0, null);
                }
            }
        }
        int n8 = this.columnMappings.get((int)n).destinationColumnName.length();
        String string = this.columnMappings.get((int)n).destinationColumnName;
        byte[] byArray3 = new byte[2 * n8];
        for (int i = 0; i < n8; ++i) {
            char c = string.charAt(i);
            byArray3[2 * i] = (byte)(c & 0xFF);
            byArray3[2 * i + 1] = (byte)(c >> 8 & 0xFF);
        }
        tDSWriter.writeByte((byte)n8);
        tDSWriter.writeBytes(byArray3);
    }

    private final void writeColumnMetaData(TDSWriter tDSWriter) throws SQLServerException {
        tDSWriter.writeByte((byte)-127);
        byte[] byArray = new byte[]{(byte)(this.columnMappings.size() & 0xFF), (byte)(this.columnMappings.size() >> 8 & 0xFF)};
        tDSWriter.writeBytes(byArray);
        for (int i = 0; i < this.columnMappings.size(); ++i) {
            this.writeColumnMetaDataColumnData(tDSWriter, i);
        }
    }

    private void checkForTimeoutException(SQLException sQLException, BulkTimeoutTimer bulkTimeoutTimer) throws SQLServerException {
        if (null != sQLException.getSQLState() && sQLException.getSQLState().equals(SQLState.STATEMENT_CANCELED.getSQLStateCode()) && bulkTimeoutTimer.expired()) {
            if (this.copyOptions.isUseInternalTransaction()) {
                this.connection.rollback();
            }
            throw new SQLServerException(SQLServerException.getErrString("R_queryTimedOut"), SQLState.STATEMENT_CANCELED, DriverError.NOT_SET, null);
        }
    }

    private void validateDataTypeConversions() throws SQLServerException {
        int n = this.columnMappings.size();
        for (int i = 0; i < n; ++i) {
            SSType sSType;
            JDBCType jDBCType = JDBCType.of(this.srcColumnMetadata.get((Object)Integer.valueOf((int)this.columnMappings.get((int)i).sourceColumnOrdinal)).jdbcType);
            if (jDBCType.convertsTo(sSType = this.destColumnMetadata.get((Object)Integer.valueOf((int)this.columnMappings.get((int)i).destinationColumnOrdinal)).ssType)) continue;
            DataTypes.throwConversionError(jDBCType.toString(), sSType.toString());
        }
    }

    private static final Boolean isCharType(int n) {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static final Boolean isBinaryType(SSType sSType) {
        switch (sSType) {
            case BINARY: 
            case VARBINARY: 
            case VARBINARYMAX: 
            case IMAGE: {
                return true;
            }
        }
        return false;
    }

    private String getDestTypeFromSrcType(int n, int n2) throws SQLServerException {
        boolean bl;
        SSType sSType = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).ssType;
        int n3 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).jdbcType;
        int n4 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).precision;
        int n5 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).precision;
        int n6 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).scale;
        n4 = this.validateSourcePrecision(n4, n3, n5);
        if (-15 == n3 || -9 == n3 || -16 == n3) {
            bl = 4000 < n4 || 4000 < n5;
        } else {
            boolean bl2 = bl = 8000 < n4 || 8000 < n5;
        }
        if (SQLServerBulkCopy.isCharType(n3).booleanValue() && SQLServerBulkCopy.isBinaryType(sSType).booleanValue()) {
            if (bl) {
                return "varbinary(max)";
            }
            return sSType.toString() + "(" + (8000 < n5 ? "max" : Integer.valueOf(n5)) + ")";
        }
        switch (n3) {
            case 4: {
                return "int";
            }
            case 5: {
                return "smallint";
            }
            case -5: {
                return "bigint";
            }
            case -7: {
                return "bit";
            }
            case -6: {
                return "tinyint";
            }
            case 8: {
                return "float";
            }
            case 7: {
                return "real";
            }
            case 3: {
                return "decimal(" + n4 + ", " + n6 + ")";
            }
            case 2: {
                return "numeric(" + n4 + ", " + n6 + ")";
            }
            case 1: {
                return "char(" + n4 + ")";
            }
            case -15: {
                return "NCHAR(" + n4 + ")";
            }
            case -1: 
            case 12: {
                if (bl) {
                    return "varchar(max)";
                }
                return "varchar(" + n4 + ")";
            }
            case -16: 
            case -9: {
                if (bl) {
                    return "NVARCHAR(MAX)";
                }
                return "NVARCHAR(" + n4 + ")";
            }
            case -2: {
                return "binary(" + n4 + ")";
            }
            case -4: 
            case -3: {
                if (bl) {
                    return "varbinary(max)";
                }
                return "varbinary(" + n4 + ")";
            }
            case 93: {
                switch (sSType) {
                    case SMALLDATETIME: {
                        return "smalldatetime";
                    }
                    case DATETIME: {
                        return "datetime";
                    }
                }
                return "datetime2(" + n6 + ")";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time(" + n6 + ")";
            }
            case -155: 
            case 2013: 
            case 2014: {
                return "datetimeoffset(" + n6 + ")";
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
        Object[] objectArray = new Object[]{JDBCType.of(n3).toString().toLowerCase()};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
        return null;
    }

    private final String createInsertBulkCommand() throws SQLServerException {
        Iterator iterator;
        StringBuilder stringBuilder = new StringBuilder();
        Vector<String> vector = new Vector<String>();
        String string = " , ";
        stringBuilder.append("INSERT BULK " + this.destinationTableName + " (");
        for (int i = 0; i < this.columnMappings.size(); ++i) {
            if (i == this.columnMappings.size() - 1) {
                string = " ) ";
            }
            ColumnMapping columnMapping = this.columnMappings.get(i);
            String string2 = this.destColumnMetadata.get((Object)Integer.valueOf((int)this.columnMappings.get((int)i).destinationColumnOrdinal)).collationName;
            String string3 = "";
            String string4 = this.getDestTypeFromSrcType(columnMapping.sourceColumnOrdinal, columnMapping.destinationColumnOrdinal).toUpperCase();
            if (null != string2 && string2.trim().length() > 0 && null != string4 && (string4.toLowerCase().trim().startsWith("char") || string4.toLowerCase().trim().startsWith("varchar"))) {
                string3 = " COLLATE " + string2;
            }
            stringBuilder.append("[" + columnMapping.destinationColumnName + "] " + string4 + string3 + string);
        }
        if (this.copyOptions.isCheckConstraints()) {
            vector.add("CHECK_CONSTRAINTS");
        }
        if (this.copyOptions.isFireTriggers()) {
            vector.add("FIRE_TRIGGERS");
        }
        if (this.copyOptions.isKeepNulls()) {
            vector.add("KEEP_NULLS");
        }
        if (this.copyOptions.getBatchSize() > 0) {
            vector.add("ROWS_PER_BATCH = " + this.copyOptions.getBatchSize());
        }
        if (this.copyOptions.isTableLock()) {
            vector.add("TABLOCK");
        }
        if ((iterator = vector.iterator()).hasNext()) {
            stringBuilder.append(" with (");
            while (iterator.hasNext()) {
                stringBuilder.append(((String)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
        }
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.finer(this.toString() + " TDSCommand: " + stringBuilder);
        }
        return stringBuilder.toString();
    }

    private final boolean doInsertBulk(TDSCommand tDSCommand) throws SQLServerException {
        if (this.copyOptions.isUseInternalTransaction()) {
            this.connection.setAutoCommit(false);
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)1);
        String string = this.createInsertBulkCommand();
        tDSWriter.writeString(string);
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
        tDSWriter = tDSCommand.startRequest((byte)7);
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.writeColumnMetaData(tDSWriter);
            bl2 = this.writeBatchData(tDSWriter);
        }
        catch (SQLServerException sQLServerException) {
            bl = true;
            throw sQLServerException;
        }
        finally {
            block12: {
                try {
                    this.writePacketDataDone(tDSWriter);
                    TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
                }
                catch (SQLServerException sQLServerException) {
                    if (bl) break block12;
                    throw sQLServerException;
                }
            }
        }
        if (this.copyOptions.isUseInternalTransaction()) {
            this.connection.commit();
        }
        return bl2;
    }

    private final void writePacketDataDone(TDSWriter tDSWriter) throws SQLServerException {
        tDSWriter.writeByte((byte)-3);
        tDSWriter.writeLong(0L);
        tDSWriter.writeInt(0);
    }

    private void throwInvalidArgument(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] objectArray = new Object[]{string};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
    }

    private void throwInvalidJavaToJDBC(String string, int n) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
        throw new SQLServerException(messageFormat.format(new Object[]{string, n}), null, 0, null);
    }

    private void writeToServer() throws SQLServerException {
        if (this.connection.isClosed()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), "08003", false);
        }
        long l = System.currentTimeMillis();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.finer(this.toString() + " Start writeToServer: " + l);
        }
        this.getDestinationMetadata();
        this.getSourceMetadata();
        this.validateColumnMappings();
        this.validateDataTypeConversions();
        this.sendBulkLoadBCP();
        long l2 = System.currentTimeMillis();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.finer(this.toString() + " End writeToServer: " + l2);
            int n = (int)((l2 - l) / 1000L);
            loggerExternal.finer(this.toString() + "Time elapsed: " + n + " seconds");
        }
    }

    private void getDestinationMetadata() throws SQLServerException {
        if (null == this.destinationTableName) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_invalidDestinationTable"), null, false);
        }
        try {
            SQLServerResultSet sQLServerResultSet = ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal("SET FMTONLY ON SELECT * FROM " + this.destinationTableName + " SET FMTONLY OFF ");
            this.destColumnCount = sQLServerResultSet.getMetaData().getColumnCount();
            this.destColumnMetadata = new HashMap<Integer, BulkColumnMetaData>();
            for (int i = 1; i <= this.destColumnCount; ++i) {
                SQLServerResultSet sQLServerResultSet2 = ((SQLServerStatement)this.connection.createStatement()).executeQueryInternal("select collation_name from sys.columns where name='" + sQLServerResultSet.getColumn(i).getColumnName() + "' and object_id=OBJECT_ID('" + this.destinationTableName + "')");
                if (sQLServerResultSet2.next()) {
                    this.destColumnMetadata.put(i, new BulkColumnMetaData(sQLServerResultSet.getColumn(i), sQLServerResultSet2.getString("collation_name")));
                    continue;
                }
                this.destColumnMetadata.put(i, new BulkColumnMetaData(sQLServerResultSet.getColumn(i)));
            }
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
        }
    }

    private void getSourceMetadata() throws SQLServerException {
        this.srcColumnMetadata = new HashMap<Integer, BulkColumnMetaData>();
        if (null != this.sourceResultSet) {
            try {
                this.srcColumnCount = this.sourceResultSetMetaData.getColumnCount();
                for (int i = 1; i <= this.srcColumnCount; ++i) {
                    this.srcColumnMetadata.put(i, new BulkColumnMetaData(this.sourceResultSetMetaData.getColumnName(i), 0 != this.sourceResultSetMetaData.isNullable(i), this.sourceResultSetMetaData.getPrecision(i), this.sourceResultSetMetaData.getScale(i), this.sourceResultSetMetaData.getColumnType(i)));
                }
            }
            catch (SQLException sQLException) {
                throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
            }
        } else if (null != this.sourceBulkRecord) {
            Set<Integer> set = this.sourceBulkRecord.getColumnOrdinals();
            this.srcColumnCount = set.size();
            if (0 == this.srcColumnCount) {
                throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), null);
            }
            for (int n : set) {
                this.srcColumnMetadata.put(n, new BulkColumnMetaData(this.sourceBulkRecord.getColumnName(n), true, this.sourceBulkRecord.getPrecision(n), this.sourceBulkRecord.getScale(n), this.sourceBulkRecord.getColumnType(n)));
            }
        } else {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), null);
        }
    }

    private int validateSourcePrecision(int n, int n2, int n3) {
        if (1 > n && SQLServerBulkCopy.isCharType(n2).booleanValue()) {
            n = n3;
        }
        return n;
    }

    private void validateColumnMappings() throws SQLServerException {
        block27: {
            try {
                boolean bl;
                ColumnMapping columnMapping;
                int n;
                if (this.columnMappings.isEmpty()) {
                    if (this.destColumnCount != this.srcColumnCount) {
                        throw new SQLServerException(SQLServerException.getErrString("R_schemaMismatch"), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                    }
                    for (int i = 1; i <= this.srcColumnCount; ++i) {
                        if (this.destColumnMetadata.get((Object)Integer.valueOf((int)i)).isIdentity && !this.copyOptions.isKeepIdentity()) continue;
                        ColumnMapping columnMapping2 = new ColumnMapping(i, i);
                        columnMapping2.destinationColumnName = this.destColumnMetadata.get((Object)Integer.valueOf((int)i)).columnName;
                        this.columnMappings.add(columnMapping2);
                    }
                    if (null != this.sourceBulkRecord) {
                        Set<Integer> set = this.sourceBulkRecord.getColumnOrdinals();
                        Iterator<Integer> iterator = set.iterator();
                        int n2 = 1;
                        while (iterator.hasNext()) {
                            int n3 = iterator.next();
                            if (n2 != n3) {
                                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                                Object[] objectArray = new Object[]{n3};
                                throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                            }
                            ++n2;
                        }
                    }
                    break block27;
                }
                int n4 = this.columnMappings.size();
                for (n = 0; n < n4; ++n) {
                    columnMapping = this.columnMappings.get(n);
                    if (-1 == columnMapping.destinationColumnOrdinal) {
                        bl = false;
                        for (int i = 1; i <= this.destColumnCount; ++i) {
                            if (!this.destColumnMetadata.get((Object)Integer.valueOf((int)i)).columnName.equals(columnMapping.destinationColumnName)) continue;
                            bl = true;
                            columnMapping.destinationColumnOrdinal = i;
                            break;
                        }
                        if (bl) continue;
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                        Object[] objectArray = new Object[]{columnMapping.destinationColumnName};
                        throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                    }
                    if (0 > columnMapping.destinationColumnOrdinal || this.destColumnCount < columnMapping.destinationColumnOrdinal) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                        Object[] objectArray = new Object[]{columnMapping.destinationColumnOrdinal};
                        throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                    }
                    columnMapping.destinationColumnName = this.destColumnMetadata.get((Object)Integer.valueOf((int)columnMapping.destinationColumnOrdinal)).columnName;
                }
                for (n = 0; n < n4; ++n) {
                    columnMapping = this.columnMappings.get(n);
                    if (-1 == columnMapping.sourceColumnOrdinal) {
                        bl = false;
                        if (null != this.sourceResultSet) {
                            int n5 = this.sourceResultSetMetaData.getColumnCount();
                            for (int i = 1; i <= n5; ++i) {
                                if (!this.sourceResultSetMetaData.getColumnName(i).equals(columnMapping.sourceColumnName)) continue;
                                bl = true;
                                columnMapping.sourceColumnOrdinal = i;
                                break;
                            }
                        } else {
                            Set<Integer> set = this.sourceBulkRecord.getColumnOrdinals();
                            for (int n6 : set) {
                                if (!this.sourceBulkRecord.getColumnName(n6).equals(columnMapping.sourceColumnName)) continue;
                                bl = true;
                                columnMapping.sourceColumnOrdinal = n6;
                                break;
                            }
                        }
                        if (!bl) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                            Object[] objectArray = new Object[]{columnMapping.sourceColumnName};
                            throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                        }
                    } else {
                        bl = true;
                        if (null != this.sourceResultSet) {
                            int n7 = this.sourceResultSetMetaData.getColumnCount();
                            if (0 < columnMapping.sourceColumnOrdinal && n7 >= columnMapping.sourceColumnOrdinal) {
                                bl = false;
                            }
                        } else if (this.srcColumnMetadata.containsKey(columnMapping.sourceColumnOrdinal)) {
                            bl = false;
                        }
                        if (bl) {
                            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                            Object[] objectArray = new Object[]{columnMapping.sourceColumnOrdinal};
                            throw new SQLServerException(messageFormat.format(objectArray), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
                        }
                    }
                    if (!this.destColumnMetadata.get((Object)Integer.valueOf((int)columnMapping.destinationColumnOrdinal)).isIdentity || this.copyOptions.isKeepIdentity()) continue;
                    this.columnMappings.remove(n);
                    --n4;
                    --n;
                }
            }
            catch (SQLException sQLException) {
                if (null != sQLException.getSQLState() && sQLException.getSQLState().equals(SQLState.COL_NOT_FOUND.getSQLStateCode())) {
                    throw (SQLServerException)sQLException;
                }
                throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveColMeta"), sQLException);
            }
        }
        if (this.columnMappings.isEmpty()) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_BulkColumnMappingsIsEmpty"), null, 0, false);
        }
    }

    private void writeNullToTdsWriter(TDSWriter tDSWriter, int n, boolean bl) throws SQLServerException {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                if (bl) {
                    tDSWriter.writeLong(-1L);
                } else {
                    tDSWriter.writeByte((byte)-1);
                    tDSWriter.writeByte((byte)-1);
                }
                return;
            }
            case -155: 
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                tDSWriter.writeByte((byte)0);
                return;
            }
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
        Object[] objectArray = new Object[]{JDBCType.of(n).toString().toLowerCase()};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
    }

    private void writeColumnToTdsWriter(TDSWriter tDSWriter, int n, int n2, int n3, boolean bl, int n4, boolean bl2, Object object) throws SQLServerException {
        SSType sSType = this.destColumnMetadata.get((Object)Integer.valueOf((int)n4)).ssType;
        n = this.validateSourcePrecision(n, n3, this.destColumnMetadata.get((Object)Integer.valueOf((int)n4)).precision);
        block6 : switch (n3) {
            case 4: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)4);
                }
                tDSWriter.writeInt((Integer)object);
                break;
            }
            case 5: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)2);
                }
                tDSWriter.writeShort(((Number)object).shortValue());
                break;
            }
            case -5: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)8);
                }
                tDSWriter.writeLong((Long)object);
                break;
            }
            case -7: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)1);
                }
                tDSWriter.writeByte((byte)((Boolean)object != false ? 1 : 0));
                break;
            }
            case -6: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)1);
                }
                tDSWriter.writeByte((byte)(((Number)object).shortValue() & 0xFF));
                break;
            }
            case 8: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)8);
                }
                tDSWriter.writeDouble((Double)object);
                break;
            }
            case 7: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (bl) {
                    tDSWriter.writeByte((byte)4);
                }
                tDSWriter.writeReal(Float.valueOf(((Float)object).floatValue()));
                break;
            }
            case 2: 
            case 3: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                tDSWriter.writeBigDecimal((BigDecimal)object, n3, n);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (bl2) {
                    if (null == object) {
                        this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                        break;
                    }
                    tDSWriter.writeLong(-2L);
                    try {
                        Reader reader = null;
                        reader = object instanceof Reader ? (Reader)object : new StringReader(object.toString());
                        if (SSType.BINARY == sSType || SSType.VARBINARY == sSType || SSType.VARBINARYMAX == sSType || SSType.IMAGE == sSType) {
                            tDSWriter.writeNonUnicodeReader(reader, -1L, true, null);
                        } else {
                            SQLCollation sQLCollation = this.destColumnMetadata.get((Object)Integer.valueOf((int)n4)).collation;
                            if (null != sQLCollation) {
                                tDSWriter.writeNonUnicodeReader(reader, -1L, false, sQLCollation.getCharset());
                            } else {
                                tDSWriter.writeNonUnicodeReader(reader, -1L, false, null);
                            }
                        }
                        reader.close();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), iOException);
                    }
                }
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                String string = object.toString();
                if (SSType.BINARY == sSType || SSType.VARBINARY == sSType) {
                    byte[] byArray = null;
                    try {
                        byArray = ParameterUtils.HexToBin(string);
                    }
                    catch (SQLServerException sQLServerException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLServerException);
                    }
                    tDSWriter.writeShort((short)byArray.length);
                    tDSWriter.writeBytes(byArray);
                    break;
                }
                try {
                    tDSWriter.writeShort((short)string.length());
                    SQLCollation sQLCollation = this.destColumnMetadata.get((Object)Integer.valueOf((int)n4)).collation;
                    if (null != sQLCollation) {
                        tDSWriter.writeBytes(string.getBytes(this.destColumnMetadata.get((Object)Integer.valueOf((int)n4)).collation.getCharset()));
                        break;
                    }
                    tDSWriter.writeBytes(string.getBytes());
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(SQLServerException.getErrString("R_encodingErrorWritingTDS"), unsupportedEncodingException);
                }
            }
            case -16: 
            case -15: 
            case -9: {
                if (bl2) {
                    if (null == object) {
                        this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                        break;
                    }
                    tDSWriter.writeLong(-2L);
                    try {
                        Reader reader = null;
                        reader = object instanceof Reader ? (Reader)object : new StringReader(object.toString());
                        tDSWriter.writeReader(reader, -1L, true);
                        reader.close();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), iOException);
                    }
                }
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                int n5 = object.toString().length();
                byte[] byArray = new byte[]{(byte)(2 * n5 & 0xFF), (byte)(2 * n5 >> 8 & 0xFF)};
                tDSWriter.writeBytes(byArray);
                tDSWriter.writeString(object.toString());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray;
                if (bl2) {
                    if (null == object) {
                        this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                        break;
                    }
                    tDSWriter.writeLong(-2L);
                    try {
                        InputStream inputStream = null;
                        inputStream = object instanceof InputStream ? (InputStream)object : new ByteArrayInputStream(ParameterUtils.HexToBin(object.toString()));
                        tDSWriter.writeStream(inputStream, -1L, true);
                        inputStream.close();
                        break;
                    }
                    catch (IOException iOException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), iOException);
                    }
                }
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (object instanceof byte[]) {
                    byArray = (byte[])object;
                } else {
                    try {
                        byArray = ParameterUtils.HexToBin(object.toString());
                    }
                    catch (SQLServerException sQLServerException) {
                        throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLServerException);
                    }
                }
                tDSWriter.writeShort((short)byArray.length);
                tDSWriter.writeBytes(byArray);
                break;
            }
            case 93: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                switch (sSType) {
                    case SMALLDATETIME: {
                        if (bl) {
                            tDSWriter.writeByte((byte)4);
                        }
                        tDSWriter.writeSmalldatetime(object.toString());
                        break block6;
                    }
                    case DATETIME: {
                        if (bl) {
                            tDSWriter.writeByte((byte)8);
                        }
                        tDSWriter.writeDatetime(object.toString());
                        break block6;
                    }
                }
                if (bl) {
                    if (2 >= n2) {
                        tDSWriter.writeByte((byte)6);
                    } else if (4 >= n2) {
                        tDSWriter.writeByte((byte)7);
                    } else {
                        tDSWriter.writeByte((byte)8);
                    }
                }
                String string = object.toString();
                tDSWriter.writeTime(Timestamp.valueOf(string), n2);
                tDSWriter.writeDate(string.substring(0, string.lastIndexOf(32)));
                break;
            }
            case 91: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                tDSWriter.writeByte((byte)3);
                tDSWriter.writeDate(object.toString());
                break;
            }
            case 92: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)3);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)4);
                } else {
                    tDSWriter.writeByte((byte)5);
                }
                tDSWriter.writeTime((Timestamp)object, n2);
                break;
            }
            case 2013: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)8);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)9);
                } else {
                    tDSWriter.writeByte((byte)10);
                }
                tDSWriter.writeOffsetTimeWithTimezone((OffsetTime)object, n2);
                break;
            }
            case 2014: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)8);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)9);
                } else {
                    tDSWriter.writeByte((byte)10);
                }
                tDSWriter.writeOffsetDateTimeWithTimezone((OffsetDateTime)object, n2);
                break;
            }
            case -155: {
                if (null == object) {
                    this.writeNullToTdsWriter(tDSWriter, n3, bl2);
                    break;
                }
                if (2 >= n2) {
                    tDSWriter.writeByte((byte)8);
                } else if (4 >= n2) {
                    tDSWriter.writeByte((byte)9);
                } else {
                    tDSWriter.writeByte((byte)10);
                }
                tDSWriter.writeDateTimeOffset((DateTimeOffset)object, n2, sSType);
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
                Object[] objectArray = new Object[]{JDBCType.of(n3).toString().toLowerCase()};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
            }
        }
    }

    private Object readColumnFromResultSet(int n, int n2, boolean bl) throws SQLServerException {
        Object var4_4 = null;
        try {
            switch (n2) {
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    return this.sourceResultSet.getObject(n);
                }
                case 2: 
                case 3: {
                    return this.sourceResultSet.getBigDecimal(n);
                }
                case -1: 
                case 1: 
                case 12: {
                    if (bl) {
                        return this.sourceResultSet.getCharacterStream(n);
                    }
                    return this.sourceResultSet.getString(n);
                }
                case -16: 
                case -15: 
                case -9: {
                    if (bl) {
                        return this.sourceResultSet.getNCharacterStream(n);
                    }
                    return this.sourceResultSet.getObject(n);
                }
                case -4: 
                case -3: 
                case -2: {
                    if (bl) {
                        return this.sourceResultSet.getBinaryStream(n);
                    }
                    return this.sourceResultSet.getBytes(n);
                }
                case 93: {
                    return this.sourceResultSet.getTimestamp(n);
                }
                case 91: {
                    return this.sourceResultSet.getDate(n);
                }
                case 92: {
                    return this.sourceResultSet.getTimestamp(n);
                }
                case -155: {
                    return ((SQLServerResultSet)this.sourceResultSet).getDateTimeOffset(n);
                }
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_BulkTypeNotSupported"));
            Object[] objectArray = new Object[]{JDBCType.of(n2).toString().toLowerCase()};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
            return null;
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLException);
        }
    }

    private final void writeColumn(TDSWriter tDSWriter, int n, int n2, Object object) throws SQLServerException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Object var9_9 = null;
        boolean bl = false;
        n3 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).precision;
        n4 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).scale;
        n6 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).jdbcType;
        boolean bl2 = this.srcColumnMetadata.get((Object)Integer.valueOf((int)n)).isNullable;
        n5 = this.destColumnMetadata.get((Object)Integer.valueOf((int)n2)).precision;
        if (-15 == n6 || -9 == n6 || -16 == n6) {
            bl = 4000 < n3 || 4000 < n5;
        } else {
            boolean bl3 = bl = 8000 < n3 || 8000 < n5;
        }
        if (null != this.sourceResultSet) {
            object = this.readColumnFromResultSet(n, n6, bl);
        }
        this.writeColumnToTdsWriter(tDSWriter, n3, n4, n6, bl2, n2, bl, object);
    }

    private boolean goToNextRow() throws SQLServerException {
        try {
            if (null != this.sourceResultSet) {
                return this.sourceResultSet.next();
            }
            return this.sourceBulkRecord.next();
        }
        catch (SQLException sQLException) {
            throw new SQLServerException(SQLServerException.getErrString("R_unableRetrieveSourceData"), sQLException);
        }
    }

    private final boolean writeBatchData(TDSWriter tDSWriter) throws SQLServerException {
        int n = this.copyOptions.getBatchSize();
        int n2 = 0;
        while (0 == n || n2 < n) {
            if (!this.goToNextRow()) {
                return false;
            }
            tDSWriter.writeByte((byte)-47);
            int n3 = this.columnMappings.size();
            if (null != this.sourceResultSet) {
                for (int i = 0; i < n3; ++i) {
                    this.writeColumn(tDSWriter, this.columnMappings.get((int)i).sourceColumnOrdinal, this.columnMappings.get((int)i).destinationColumnOrdinal, null);
                }
            } else {
                Object[] objectArray = this.sourceBulkRecord.getRowData();
                for (int i = 0; i < n3; ++i) {
                    this.writeColumn(tDSWriter, this.columnMappings.get((int)i).sourceColumnOrdinal, this.columnMappings.get((int)i).destinationColumnOrdinal, objectArray[this.columnMappings.get((int)i).sourceColumnOrdinal - 1]);
                }
            }
            ++n2;
        }
        return true;
    }

    private final class BulkTimeoutTimer
    implements Runnable {
        private final int timeoutSeconds;
        private int secondsRemaining;
        private final TDSCommand command;
        private Thread timerThread;
        private volatile boolean canceled = false;

        BulkTimeoutTimer(int n, TDSCommand tDSCommand) {
            assert (n > 0);
            assert (null != tDSCommand);
            this.timeoutSeconds = n;
            this.secondsRemaining = n;
            this.command = tDSCommand;
        }

        final void start() {
            this.timerThread = new Thread(this);
            this.timerThread.setDaemon(true);
            this.timerThread.start();
        }

        final void stop() {
            this.canceled = true;
            this.timerThread.interrupt();
        }

        final boolean expired() {
            return this.secondsRemaining <= 0;
        }

        @Override
        public void run() {
            try {
                do {
                    if (this.canceled) {
                        return;
                    }
                    Thread.sleep(1000L);
                } while (--this.secondsRemaining > 0);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            try {
                this.command.interrupt(SQLServerException.getErrString("R_queryTimedOut"));
            }
            catch (SQLServerException sQLServerException) {
                this.command.log(Level.FINE, "Command could not be timed out. Reason: " + sQLServerException.getMessage());
            }
        }
    }

    class BulkColumnMetaData {
        String columnName;
        SSType ssType = null;
        int jdbcType;
        String sqlServerType = null;
        TDSType tdsType = null;
        int precision;
        int scale;
        SQLCollation collation;
        byte[] flags = new byte[2];
        boolean isIdentity = false;
        boolean isNullable;
        String collationName;

        public BulkColumnMetaData(Column column) throws SQLServerException {
            TypeInfo typeInfo = column.getTypeInfo();
            this.columnName = column.getColumnName();
            this.ssType = typeInfo.getSSType();
            this.sqlServerType = typeInfo.getSSTypeName();
            this.tdsType = TDSType.INT8;
            this.flags = typeInfo.getFlags();
            this.isIdentity = typeInfo.isIdentity();
            this.isNullable = typeInfo.isNullable();
            this.precision = typeInfo.getPrecision();
            this.scale = typeInfo.getScale();
            this.collation = typeInfo.getSQLCollation();
            this.jdbcType = this.ssType.getJDBCType().getIntValue();
        }

        public BulkColumnMetaData(String string, boolean bl, int n, int n2, int n3) throws SQLServerException {
            this.columnName = string;
            this.isNullable = bl;
            this.precision = n;
            this.scale = n2;
            this.jdbcType = n3;
        }

        public BulkColumnMetaData(Column column, String string) throws SQLServerException {
            this(column);
            this.collationName = string;
        }
    }

    private class ColumnMapping {
        public String sourceColumnName = null;
        public int sourceColumnOrdinal = -1;
        public String destinationColumnName = null;
        public int destinationColumnOrdinal = -1;

        public ColumnMapping(String string, String string2) {
            this.sourceColumnName = string;
            this.destinationColumnName = string2;
        }

        public ColumnMapping(String string, int n) {
            this.sourceColumnName = string;
            this.destinationColumnOrdinal = n;
        }

        public ColumnMapping(int n, String string) {
            this.sourceColumnOrdinal = n;
            this.destinationColumnName = string;
        }

        public ColumnMapping(int n, int n2) {
            this.sourceColumnOrdinal = n;
            this.destinationColumnOrdinal = n2;
        }
    }
}

