/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputBinary
extends RowInputBase
implements RowInputInterface {
    public boolean ignoreDataErrors;
    private RowOutputBinary out;

    public RowInputBinary(byte[] byArray) {
        super(byArray);
    }

    public RowInputBinary(RowOutputBinary rowOutputBinary) {
        super(rowOutputBinary.getBuffer());
        this.out = rowOutputBinary;
    }

    @Override
    public void readFully(byte[] byArray) {
        try {
            super.readFully(byArray);
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public long readLong() {
        try {
            return super.readLong();
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public int readInt() {
        try {
            return super.readInt();
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public short readShort() {
        try {
            return super.readShort();
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public char readChar() {
        try {
            return super.readChar();
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public byte readByte() {
        try {
            return super.readByte();
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return super.readBoolean();
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public int readType() {
        return this.readShort();
    }

    @Override
    public String readString() {
        try {
            int n = this.readInt();
            if (n < 0) {
                throw Error.error(467, "RowInputBinary - negative length");
            }
            String string = StringConverter.readUTF(this.buffer, this.pos, n);
            string = ValuePool.getString(string);
            this.pos += n;
            return string;
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 467, "RowInputBinary");
        }
    }

    @Override
    public boolean readNull() {
        byte by = this.readByte();
        return by == 0;
    }

    @Override
    protected String readChar(Type type) {
        return this.readString();
    }

    @Override
    protected Integer readSmallint() {
        return ValuePool.getInt(this.readShort());
    }

    @Override
    protected Integer readInteger() {
        return ValuePool.getInt(this.readInt());
    }

    @Override
    protected Long readBigint() {
        return ValuePool.getLong(this.readLong());
    }

    @Override
    protected Double readReal() {
        return ValuePool.getDouble(this.readLong());
    }

    @Override
    protected BigDecimal readDecimal(Type type) {
        byte[] byArray = this.readByteArray();
        int n = this.readInt();
        BigInteger bigInteger = new BigInteger(byArray);
        return ValuePool.getBigDecimal(new BigDecimal(bigInteger, n));
    }

    @Override
    protected Boolean readBoole() {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected TimeData readTime(Type type) {
        if (type.typeCode == 92) {
            return new TimeData(this.readInt(), this.readInt(), 0);
        }
        return new TimeData(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    protected TimestampData readDate(Type type) {
        long l = this.readLong();
        return new TimestampData(l);
    }

    @Override
    protected TimestampData readTimestamp(Type type) {
        if (type.typeCode == 93) {
            return new TimestampData(this.readLong(), this.readInt());
        }
        return new TimestampData(this.readLong(), this.readInt(), this.readInt());
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) {
        long l = this.readLong();
        return new IntervalMonthData(l, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) {
        long l = this.readLong();
        int n = this.readInt();
        return new IntervalSecondData(l, n, (IntervalType)type);
    }

    @Override
    protected Object readOther() {
        return new JavaObjectData(this.readByteArray());
    }

    @Override
    protected BinaryData readBit() {
        int n = this.readInt();
        byte[] byArray = new byte[(n + 7) / 8];
        this.readFully(byArray);
        return BinaryData.getBitData(byArray, n);
    }

    @Override
    protected BinaryData readBinary() {
        return new BinaryData(this.readByteArray(), false);
    }

    @Override
    protected ClobData readClob() {
        long l = this.readLong();
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() {
        long l = this.readLong();
        return new BlobDataID(l);
    }

    @Override
    protected Object[] readArray(Type type) {
        type = type.collectionBaseType();
        int n = this.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readData(type);
        }
        return objectArray;
    }

    public int[] readIntArray() throws IOException {
        int n = this.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.readNull()) continue;
            nArray[i] = this.readInt();
        }
        return nArray;
    }

    @Override
    public Object[] readData(Type[] typeArray) {
        if (this.ignoreDataErrors) {
            return new Object[typeArray.length];
        }
        return super.readData(typeArray);
    }

    public byte[] readByteArray() {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public char[] readCharArray() throws IOException {
        int n = this.readInt();
        char[] cArray = new char[n];
        if (this.count - this.pos < cArray.length) {
            this.pos = this.count;
            throw new EOFException();
        }
        for (int i = 0; i < cArray.length; ++i) {
            int n2 = this.buffer[this.pos++] & 0xFF;
            int n3 = this.buffer[this.pos++] & 0xFF;
            cArray[i] = (char)((n2 << 8) + n3);
        }
        return cArray;
    }

    public void resetRow(int n) {
        if (this.out != null) {
            this.out.reset(n);
            this.buffer = this.out.getBuffer();
        }
        super.reset();
    }

    @Override
    public void resetRow(long l, int n) {
        if (this.out != null) {
            this.out.reset(n);
            this.buffer = this.out.getBuffer();
        }
        super.resetRow(l, n);
    }
}

