/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.number;

import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.number.OdfNumberAmPm;
import org.odftoolkit.odfdom.doc.number.OdfNumberDay;
import org.odftoolkit.odfdom.doc.number.OdfNumberDayOfWeek;
import org.odftoolkit.odfdom.doc.number.OdfNumberEra;
import org.odftoolkit.odfdom.doc.number.OdfNumberHours;
import org.odftoolkit.odfdom.doc.number.OdfNumberMinutes;
import org.odftoolkit.odfdom.doc.number.OdfNumberMonth;
import org.odftoolkit.odfdom.doc.number.OdfNumberQuarter;
import org.odftoolkit.odfdom.doc.number.OdfNumberSeconds;
import org.odftoolkit.odfdom.doc.number.OdfNumberText;
import org.odftoolkit.odfdom.doc.number.OdfNumberWeekOfYear;
import org.odftoolkit.odfdom.doc.number.OdfNumberYear;
import org.odftoolkit.odfdom.dom.attribute.number.NumberFormatSourceAttribute;
import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.w3c.dom.Node;

public class OdfNumberDateStyle
extends NumberDateStyleElement {
    private String styleName;
    private String calendarName;

    public OdfNumberDateStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    OdfNumberDateStyle(OdfFileDom ownerDoc, String format, String styleName) {
        this(ownerDoc, format, styleName, null);
    }

    public OdfNumberDateStyle(OdfFileDom ownerDoc, String format, String styleName, String calendarName) {
        super(ownerDoc);
        this.styleName = styleName;
        this.calendarName = calendarName;
        this.buildFromFormat(format);
    }

    public void buildFromFormat(String format) {
        String actionChars = "GyQMwdEaHhms";
        int actionCount = 0;
        String textBuffer = "";
        boolean endQuote = false;
        int i = 0;
        this.setStyleNameAttribute(this.styleName);
        this.setNumberFormatSourceAttribute(NumberFormatSourceAttribute.Value.LANGUAGE.toString());
        while (i < format.length()) {
            char ch = format.charAt(i);
            if (actionChars.indexOf(ch) >= 0) {
                this.appendText(textBuffer);
                textBuffer = "";
                actionCount = 0;
                while (i < format.length() && format.charAt(i) == ch) {
                    ++actionCount;
                    ++i;
                }
                this.processChar(ch, actionCount);
                continue;
            }
            if (ch == '\'') {
                endQuote = false;
                ++i;
                while (i < format.length() && !endQuote) {
                    ch = format.charAt(i);
                    if (ch == '\'') {
                        if (i + 1 < format.length() && format.charAt(i + 1) == '\'') {
                            ++i;
                            textBuffer = textBuffer + "'";
                        } else {
                            endQuote = true;
                        }
                    } else {
                        textBuffer = textBuffer + ch;
                    }
                    ++i;
                }
                continue;
            }
            textBuffer = textBuffer + ch;
            ++i;
        }
        this.appendText(textBuffer);
    }

    private void appendText(String textBuffer) {
        OdfNumberText textElement = null;
        if (!textBuffer.equals("")) {
            textElement = new OdfNumberText((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    private void processChar(char ch, int count) {
        OdfFileDom ownerDoc = (OdfFileDom)((Object)this.getOwnerDocument());
        switch (ch) {
            case 'G': {
                OdfNumberEra era = new OdfNumberEra(ownerDoc);
                era.setNumberStyleAttribute(this.isLongIf(count > 3));
                if (this.calendarName != null) {
                    era.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)era));
                break;
            }
            case 'y': {
                OdfNumberYear year = new OdfNumberYear(ownerDoc);
                year.setNumberStyleAttribute(this.isLongIf(count > 3));
                if (this.calendarName != null) {
                    year.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)year));
                break;
            }
            case 'Q': {
                OdfNumberQuarter quarter = new OdfNumberQuarter(ownerDoc);
                quarter.setNumberStyleAttribute(this.isLongIf(count > 2));
                if (this.calendarName != null) {
                    quarter.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)quarter));
                break;
            }
            case 'M': {
                OdfNumberMonth month = new OdfNumberMonth(ownerDoc);
                month.setNumberTextualAttribute(count > 2);
                month.setNumberStyleAttribute(this.isLongIf(count % 2 == 0));
                if (this.calendarName != null) {
                    month.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)month));
                break;
            }
            case 'w': {
                OdfNumberWeekOfYear weekOfYear = new OdfNumberWeekOfYear(ownerDoc);
                if (this.calendarName != null) {
                    weekOfYear.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)weekOfYear));
                break;
            }
            case 'd': {
                OdfNumberDay day = new OdfNumberDay(ownerDoc);
                day.setNumberStyleAttribute(this.isLongIf(count > 1));
                if (this.calendarName != null) {
                    day.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)day));
                break;
            }
            case 'E': {
                OdfNumberDayOfWeek dayOfWeek = new OdfNumberDayOfWeek(ownerDoc);
                dayOfWeek.setNumberStyleAttribute(this.isLongIf(count > 3));
                if (this.calendarName != null) {
                    dayOfWeek.setNumberCalendarAttribute(this.calendarName);
                }
                this.appendChild((Node)((Object)dayOfWeek));
                break;
            }
            case 'a': {
                OdfNumberAmPm ampm = new OdfNumberAmPm(ownerDoc);
                this.appendChild((Node)((Object)ampm));
                break;
            }
            case 'H': 
            case 'h': {
                OdfNumberHours hours = new OdfNumberHours(ownerDoc);
                hours.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)hours));
                break;
            }
            case 'm': {
                OdfNumberMinutes minutes = new OdfNumberMinutes(ownerDoc);
                minutes.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)minutes));
                break;
            }
            case 's': {
                OdfNumberSeconds seconds = new OdfNumberSeconds(ownerDoc);
                seconds.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)seconds));
            }
        }
    }

    private String isLongIf(boolean isLong) {
        return isLong ? "long" : "short";
    }
}

