/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.net.URI;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfElementFactory;
import org.odftoolkit.odfdom.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.doc.draw.OdfDrawImage;
import org.odftoolkit.odfdom.doc.office.OdfOfficeText;
import org.odftoolkit.odfdom.doc.text.OdfTextParagraph;
import org.w3c.dom.Node;

public class OdfTextDocument
extends OdfDocument {
    private static String EMPTY_TEXT_DOCUMENT_PATH = "/OdfTextDocument.odt";
    private static OdfDocument.Resource EMPTY_TEXT_DOCUMENT_RESOURCE = new OdfDocument.Resource(EMPTY_TEXT_DOCUMENT_PATH);
    private static final String TO_STRING_METHOD_TOKEN = "\n" + (Object)((Object)OdfDocument.OdfMediaType.TEXT) + " - ID: ";

    public static OdfTextDocument newTextDocument() throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE);
    }

    protected OdfTextDocument() {
    }

    public String getMediaType() {
        return OdfDocument.OdfMediaType.TEXT.toString();
    }

    public OdfOfficeText getContentRoot() throws Exception {
        return (OdfOfficeText)super.getContentRoot();
    }

    public OdfDrawImage newImage(URI imageURL) throws Exception {
        OdfFileDom odfDom = this.getContentDom();
        OdfOfficeText odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)((Object)n) : this.newParagraph();
        OdfDrawFrame odfFrame = (OdfDrawFrame)OdfElementFactory.newOdfElement(odfDom, OdfDrawFrame.ELEMENT_NAME);
        para.appendChild((Node)((Object)odfFrame));
        OdfDrawImage image = (OdfDrawImage)OdfElementFactory.newOdfElement(odfDom, OdfDrawImage.ELEMENT_NAME);
        odfFrame.appendChild((Node)((Object)image));
        image.insertImage(imageURL);
        return image;
    }

    public OdfTextParagraph newParagraph(String text) throws Exception {
        OdfTextParagraph para = this.newParagraph();
        para.addContent(text);
        return para;
    }

    public OdfTextParagraph newParagraph() throws Exception {
        OdfOfficeText odfText = this.getContentRoot();
        return (OdfTextParagraph)odfText.newTextPElement();
    }

    public OdfTextParagraph addText(String text) throws Exception {
        OdfOfficeText odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)((Object)n) : this.newParagraph();
        para.addContent(text);
        return para;
    }

    public String toString() {
        return TO_STRING_METHOD_TOKEN + this.hashCode() + " " + this.getPackage().getBaseURI();
    }
}

