/*	Roast+ License

//	### C compilable ###
*/

#include "roast_file.h"

/*
#ifdef WIN32
	#include <sys/stat.h>

	#define stat _stat
	
	typedef struct _stat stat_t;
#else
	typedef struct stat  stat_t;
#endif
*/

#ifdef ROAST_WIN32
	#include <sys/stat.h>
#else
	#include <sys/types.h>
	#include <sys/stat.h>
	#include <unistd.h>
#endif


__ROAST_EXTERN_C_START

/**/


/*	statʉ	*/
ROAST_BOOL _roast_file_stat32( const char *path, _roast_filestat_t *p_stat_out )
{
#ifdef ROAST_WIN32
  #ifdef __stat64
	return _stat32(path,p_stat_out) == 0 ? ROAST_TRUE : ROAST_FALSE;
  #else
	return _stat(path,p_stat_out) == 0 ? ROAST_TRUE : ROAST_FALSE;
  #endif
#else/* UNIX / Linux */
	return stat(path,p_stat_out) == 0 ? ROAST_TRUE : ROAST_FALSE;
#endif
}


/**/


/*	mode擾  */
_roast_stat_mode _roast_get_file_mode( const char* filename )
{
	ROAST_FILE_STAT stt;
	
	if ( _roast_file_stat32(filename, &stt) != ROAST_TRUE )
		return _ROAST_STAT_MODE_ERROR;
	
	return stt.st_mode;
}


/*	st_size擾  */
long roast_filesize32( const char* filename )
{
	ROAST_FILE_STAT stt;
	
	if ( _roast_file_stat32(filename, &stt) != ROAST_TRUE )
		return _ROAST_STAT_MODE_ERROR;
	
	return stt.st_size;
}


/*

    time_t    st_atime;   * ŏIANZX *  NTFS ł͗LłAFAT tH[}bg̃fBXN hCuł͖łB
    time_t    st_mtime;   * ŏIC *  
    time_t    st_ctime;   * ŏIԕύX *  NTFS ł͗LłAFAT tH[}bg̃fBXN hCuł͖łB
*/

/**/


__ROAST_EXTERN_C_END

