/*	Roast+ License

//	### C compilable ###
*/
#include <stdlib.h>
#include "roast_env.h"


#ifdef ROAST_WIN32
	#include <windows.h>
#endif /* WIN32 */



__ROAST_EXTERN_C_START


/*	roast_getenv

	A^const char*ɂȂĂ邾B
	Proast_`envœꂵ̂ƁASɂȂĂA炢B
	݂ȂꍇNULLԂB
*/
const char* roast_getenv(const char *name)
{
	return getenv(name);	/* Windows/UNIXn */
}


/*  roast_setenv

	ϐ̐ݒsBputenvƈقȂA񂪃Rs[邽߁A
	ݒ肵obt@JĂȂB
*/
/*
@setenv() ֐́Aname ݂Ȃꍇϐ name ɒl value ݒ肵AɒǉB
name ɑ݂ꍇAoverwrite  0 ȊOȂ΂̒l value ɕύXA
overwrite  0 Ȃ name ̒lύXȂB̊֐́A (putenv(3) ƈႢ) name 
value ɂQƂ镶̃Rs[sB

unsetenv() ֐́Aϐ name 폜B name ɂȂꍇÅ֐͐A͕ύXȂB   

@Ԃl
setenv() ֐́A 0 ԂBɏ\ȋ󂫂ꍇ -1 ԂB 
unsetenv() ֐́A 0 ԂBG[̏ꍇ -1 ԂA errno ݒ肵ăG[̌B

nameɕsȕi=Ƃj܂܂ĂƃG[ɂȂB

setenv()  unsetenv() Ggg (ē\) ł邱ƂvĂȂB 
*/
int roast_setenv(const char *name, const char *value, int overwrite)
{
//#ifdef ROAST_VCPP
#ifdef ROAST_WIN32
	if ( !overwrite ){
		if ( roast_getenv(name) != NULL )
			return -1;
	}
	//	getenvā[
	
	return ROAST_WINBOOL_TO_CSTDRET2(
		SetEnvironmentVariable(name, value),	/* valueNULLȂ폜 */
		-1);
#else
	return setenv(name, value, overwrite);
#endif
}



/*	roast_unsetenv	*/
int roast_unsetenv(const char *name)
{
/*#ifdef ROAST_VCPP*/
#ifdef ROAST_WIN32
	/*return ROAST_WINBOOL_TO_CSTDRET2(
		FreeEnvironmentStrings(name),
		-1);*/
	return ROAST_WINBOOL_TO_CSTDRET2(
		SetEnvironmentVariable(name, NULL),	/* valueNULLȂ폜 */
		-1);
#else
	return unsetenv(name);
#endif
}

  


__ROAST_EXTERN_C_END
