/*	Roast+ License

//	### C compilable ###

//	t@Cn֐
*/
#ifndef __SFJP_OPENMGL_roast_file_H__
#define __SFJP_OPENMGL_roast_file_H__

#include "roast_common.h"
#include "roast_bufsafe.h"	/*	roast_auto_append_filesep	*/
#include "roast_str.h"		/*	roast_auto_append_filesep	*/

#include <stdio.h>


#define ROAST_DIR_SEP_CHAR_WIN		'\\'
#define ROAST_DIR_SEP_CHAR_LIN		'/'
#define ROAST_DIR_SEP_CHAR_LINUX	'/'
#define ROAST_DIR_SEP_CHAR_UNIX		'/'

#define ROAST_DIR_SEP_STR_WIN		"\\"
#define ROAST_DIR_SEP_STR_LIN		"/"
#define ROAST_DIR_SEP_STR_LINUX		"/"
#define ROAST_DIR_SEP_STR_UNIX		"/"


/*=============================================================================*/

#ifdef ROAST_WIN32
  
  #include <sys/stat.h>

  #ifdef __stat64
	typedef struct _stat32		_roast_filestat_t, ROAST_FILE_STAT, _ROAST_FILE_STAT;
  #else
	typedef struct _stat		_roast_filestat_t, ROAST_FILE_STAT, _ROAST_FILE_STAT;
  #endif
	typedef unsigned long		_roast_filestat_mode, _roast_stat_mode, ROAST_STAT_MODE, _ROAST_STAT_MODE;


	#define ROAST_DIR_SEP_CHAR	ROAST_DIR_SEP_CHAR_WIN
	#define ROAST_DIR_SEP_STR	ROAST_DIR_SEP_STR_WIN

	#define ROAST_MAX_PATH		(32000+1)


#else/* UNIX/Linux */

	#include <sys/types.h>
	#include <sys/stat.h>
	#include <unistd.h>

	typedef struct stat			_roast_filestat_t, ROAST_FILE_STAT, _ROAST_FILE_STAT;
	typedef mode_t				_roast_filestat_mode, _roast_stat_mode, ROAST_STAT_MODE, _ROAST_STAT_MODE;


	#define ROAST_DIR_SEP_CHAR	ROAST_DIR_SEP_CHAR_LINUX
	#define ROAST_DIR_SEP_STR	ROAST_DIR_SEP_STR_LINUX

	#define ROAST_MAX_PATH		(1024+1)

#endif


#define _ROAST_STAT_MODE_ERROR	(0xffffffff)

/*
#ifdef ROAST_WIN32
	#define ROAST_DIR_SEP_CHAR	'\\'
#else
	#define ROAST_DIR_SEP_CHAR	'/'
#endif


/*************************************************************************/


__ROAST_EXTERN_C_START

/**/

/*	roast_file.c	*/

ROAST_BOOL roast_mkdir( const char* filename, unsigned long mode );



/*============================================================*/

/*	roast_file__str.c	*/




/*	\/̘A𖳂	*/
char* RoastDeleteRedundancyFileSep( char *szStr, unsigned int nStrBufSize );


/*	.\Ƃ..\Ƃ̂	*/
char* roast_fix_path( char* path, unsigned int bufsize );
#define roast_path_fix(path,bufsize)	roast_fix_path(path,bufsize);
#define RoastFixPath(path,bufsize)		roast_fix_path(path,bufsize);
#define RoastPathFix(path,bufsize)		roast_fix_path(path,bufsize);


/*	t@CpX؂蕶tĂȂ玩Iɕt	*/
/*	zIȐ錾
	char* roast_auto_append_filesep( char* path, unsigned int bufsize );

	bufsize𒴂Ȃ͈͂ŕtBpath𕜋AB
*/
#define roast_auto_append_filesep( path, bufsize )	\
	(( ROAST_LAST_CHAR(path) != ROAST_DIR_SEP_CHAR_WIN &&	\
	   ROAST_LAST_CHAR(path) != ROAST_DIR_SEP_CHAR_LIN ) ?	\
	  roast_safe_strcat( path, ROAST_DIR_SEP_STR, bufsize ) : path )


/*	tɎIɍ폜	*/
/*	zIȐ錾
	char* roast_auto_remove_last_filesep( char* path );

	path𕜋AB
*/
#define roast_auto_remove_last_filesep( path )	\
	(( ROAST_LAST_CHAR(path) == ROAST_DIR_SEP_CHAR_WIN ||	\
	   ROAST_LAST_CHAR(path) == ROAST_DIR_SEP_CHAR_LIN ) ?	\
	  ROAST_REMOVE_LAST_CHAR( path ), path : path )
#define roast_remove_last_filesep( path )	roast_auto_remove_last_filesep(path)
#define RoastRemoveLastFileSep( path )		roast_auto_remove_last_filesep(path)



/*	tpX擾	*/
/*	./../	*/
const char* roast_fullpath( const char* filename, char* fullpathout, unsigned int bufsize );


#define roast_del_rfs			RoastDeleteRedundancyFileSep
#define roast_drfs				RoastDeleteRedundancyFileSep
#define roast_del_red_file_sep	RoastDeleteRedundancyFileSep



/*============================================================*/

/*	roast_file__stat.c	*/

ROAST_BOOL _roast_file_stat32( const char *path, _roast_filestat_t *p_stat_out );
_roast_stat_mode _roast_get_file_mode( const char* filename );
long roast_filesize32( const char* filename );

#define roast_filesize	roast_filesize32



/*============================================================*/

/*	roast_file__access.c	*/


/*	t@C̑ݗL𒲂ׂ
//	ret:  ROAST_TRUE:  /  ROAST_FALSE:݂Ȃ	*/
ROAST_BOOL roast_exist_file( const char* filename );	

/*	t@Cǂ߂H  */
ROAST_BOOL roast_canread( const char* filename );

/*	t@C߂H	*/
ROAST_BOOL roast_canwrite( const char* filename );

/*	soH	*/
ROAST_BOOL roast_canexec( const char* filename );




/*============================================================*/

/*	Windows: roast_file_win32__windows_h.c	*/
/*	Linux:   roast_file_unix__isdirectory.c	*/


ROAST_BOOL roast_is_directory( const char* filename );
ROAST_BOOL roast_is_file( const char* filename );
ROAST_BOOL roast_is_directory_ex( const char* filename, ROAST_BOOL *pbRetIs );
ROAST_BOOL roast_is_file_ex( const char* filename, ROAST_BOOL *pbRetIs );


/*	Windows: roast_file_win32__windows_h.c	*/
char* RoastGetModuleCurDir( char* szFilePathOut, unsigned int nBufSize );	/* <- ̂Ȃ */


/*	Windows: roast_file_win32__windows_h.c	*/
/*	Linux:   roast_file_unix__isdirectory.c	*/

/*	obt@ȂꍇɂNULL	*/
char* roast_curdir( char* buf, unsigned int bufsize );

ROAST_BOOL roast_chdir(const char* path);



/*============================================================*/

/*	roast_file_win32__imagehlp.c	*/

ROAST_BOOL RoastCreateDirectoryR( const char* szDirectory );





/**/


/*	܂錾Bi roast_file_win32__windows_h2.c?j  */


/*	l[	*/
ROAST_BOOL roast_rename_file(const char* from, const char* to);

/*	폜	*/
ROAST_BOOL roast_del_file( const char* filename );

/*	Rs[	*/
ROAST_BOOL roast_copy_file( const char* from, const char* to );

/*	ړ	*/
ROAST_BOOL roast_move_file( const char* from, const char* to );



/*////////////////////////////////////////////////////////////////////*/
/*  ǂݏ                                                          */


/*		*/
ROAST_BOOL roast_write_file( const char* filename, unsigned char* membuf, unsigned int length);

/*	ǋL	*/
ROAST_BOOL roast_append_file( const char* filename, unsigned char* membuf, unsigned int length);

/*	ǂݍ	*/
unsigned char* roast_read_file_alloc( const char* filename );
unsigned char* roast_read_file( const char* filename, unsigned char* membuf, unsigned int length);



////////////////////////////////////////////////////////

//	hCu^Cv
#define ROAST_DRIVE_TYPE_UNKNOWN	(0)
#define ROAST_DRIVE_TYPE_FIXED 		(1)		//	ŒhCuiHDDj
#define ROAST_DRIVE_TYPE_HDD 		(ROAST_DRIVE_TYPE_FIXED)

#define ROAST_DRIVE_TYPE_REMOVABLE 	(2)		//	̃fBXŃAhCuo܂B
#define ROAST_DRIVE_TYPE_REMOVABLE 	(2)		//	̃fBXŃAhCuo܂B

#define ROAST_DRIVE_TYPE_CDROM 		(4)		//	̃hCúACD-ROM hCułB
#define ROAST_DRIVE_TYPE_RAMDISK 	(8)		//	̃hCúARAM fBXNłB

#define ROAST_DRIVE_TYPE_REMOTE 	(32)		//	̃hCúA[gilbg[NjhCułB
#define ROAST_DRIVE_TYPE_NETWORK 	(32)		//	̃hCúA[gilbg[NjhCułB

int roast_get_drive_type(const char *path);


__ROAST_EXTERN_C_END


#endif/*__SFJP_OPENMGL_roast_file_H__*/
