#ifndef __MYU_STANDARD_LIBRARY__mslstd_H__
#define __MYU_STANDARD_LIBRARY__mslstd_H__

#include "mslcommon.h"

	#include <string>

////////////////////////////////////////////////////
//
//	֐Q
//
namespace msl
{
	typedef struct
	{
		long    left;
		long    top;
		long    right;
		long    bottom;
	} MSL_RECT;

	typedef MSL_RECT MYU_RECT;
	typedef MSL_RECT _MYU_RECT;
	typedef MSL_RECT _MSL_RECT;

	///////////////////////////////////////////////////

	int system_ex( const char* cmd, ... );

	#define MEMSET4_TYPE	unsigned long

	inline void *memset4(MEMSET4_TYPE *s, MEMSET4_TYPE ul, size_t n){
		MEMSET4_TYPE *p = s;
		//for(; p-s != n*sizeof(MEMSET4_TYPE); p++)
		for(; (size_t)(p-s) != n; p++)
			*p = ul;
		return s;
	}

	//////////////////////////////////////////////////////

	//	ev[g
	template <typename T> class auto_ptr_ary
	{
	protected:
		T* m_p;
	public:
		auto_ptr_ary(T* p){ m_p = p; }
		virtual ~auto_ptr_ary(){ SAFE_DELETE_ARY(m_p); }

		T* get(){ return m_p; }
	};

	//	ev[gŁiNXfXgN^ĂяoKv̂ꍇɊ댯j
	class auto_delete_ary
	{
	protected:
		void* m_p;
	public:
		auto_delete_ary(void* p){ m_p = p; }
		virtual ~auto_delete_ary(){ SAFE_DELETE_ARY(m_p); }

		void* get(){ return m_p; }
	};

	/*
	class CMyuPoolBase {
	public:
		bool Load(const char* sz
	}
	*/

	//	g폜
	class CMyuSelfDeletable{
	public:
		void DeleteSelf(){ delete this; }
	};

	class CMyuObject{};

	inline bool IsRectInternal(_MSL_RECT *pRect, int x, int y){
		if ( pRect->left >= x && pRect->right <= x &&
			 pRect->top >= y && pRect->bottom <= y )
			 return true;
		else
			return false;
	}

}//namespace msl


//////////////////////////////////////////////////////////

#ifdef WIN32
	#include <windows.h>
	#define CPPBOOL_TO_WINBOOL(b)		(b ? TRUE : FALSE)
	#define WINBOOL_TO_CPPBOOL(b)		(b ? true : false)

	#ifdef _WINDEF_
		inline msl::MSL_RECT WindowsRectToMslRect(RECT rect){
			msl::MSL_RECT mslRect;
			mslRect.top = rect.top; 
			mslRect.left = rect.left; 
			mslRect.bottom = rect.bottom; 
			mslRect.right = rect.right;
			return mslRect;
		}
	#endif//_WINDEF_
#else
	typedef struct
	{
		long    left;
		long    top;
		long    right;
		long    bottom;
	} RECT;
#endif//WIN32

#endif//__MYU_STANDARD_LIBRARY__mslstd_H__
