#ifndef __MyuIniWriter_H__
#define __MyuIniWriter_H__

#include "MyuIniReader.h"

//	NX錾
class CMyuIniWriter : public CMyuIniReader
{
public:
	//	RXgN^EfXgN^
	CMyuIniWriter(){}
	virtual ~CMyuIniWriter(){}

	//	݌n
	BOOL WriteString( const char* szName, const char* szStr ){
		m_cache[szName] = szStr;	//	LbVXV
		return WritePrivateProfileString( GetL(szName), GetR(szName), szStr, m_strIniPath.c_str() ); }
	BOOL WriteStr( const char* szName, const char* szStr ){ return WriteString( szName, szStr ); }
	BOOL WriteInt( const char* szName, int nNum ){
		char work[32];
		return WriteString( szName, dectostr( nNum, work ) ); }
	BOOL WriteInt( const char* szSection, const char* szValueName, int nNum ){
		string name = szSection;
		name += "::";
		name += szValueName;
		char work[32];
		return WriteString( name.c_str(), dectostr( nNum, work ) ); }
	BOOL WriteNum( const char* szName, int nNum ){ return WriteInt( szName, nNum ); }
	BOOL WriteBool( const char* szName, BOOL bFlg ){ return WriteInt( szName, bFlg ); }

	//	폜n
	BOOL DeleteKey( const char* szSectionName, const char* szValueName ){
		ClearCache();
		return WritePrivateProfileString( szSectionName, szValueName, NULL, m_strIniPath.c_str() ); }
	BOOL DeleteKey( const char* szName ){ return DeleteKey(GetL(szName),GetR(szName)); }
	BOOL DeleteSection( const char* szSectionName ){ return DeleteKey(szSectionName,NULL); }
};
#endif//__MyuIniWriter_H__