#ifndef __MfcIniManager_H__
#define __MfcIniManager_H__

#include "MyuIniReader.h"
#include "msl.h"

#define DDXTYPE_INT		(1)
#define DDXTYPE_UINT	(2)
#define DDXTYPE_STR		(3)
#define DDXTYPE_CBOOL	(5)

#define DDXTYPE_BOOL	(10)

namespace mwlmfc{

typedef struct
{
	void* ptr;
	int type;
} MFC_INI_MGR_ITEM;

//	NX錾
class CMfcIniManager : public CMyuIniReader
{
private:
	map<string,MFC_INI_MGR_ITEM> m_mapMfc;
	typedef map<string,MFC_INI_MGR_ITEM>::iterator ITEM_ITR;

public:
	//	RXgN^EfXgN^d
	CMfcIniManager(){}
	virtual ~CMfcIniManager(){}

/*	const char* GetStr( const char* szName );
	const char* operator[]( const char* szName ){ return szName; }*/

	void AttachDdxBOOL( const char* szName, BOOL* pValue ){
		AddDdxEntry( szName, pValue, DDXTYPE_BOOL ); }
	void AttachDdxInt( const char* szName, int* pValue ){
		AddDdxEntry( szName, pValue, DDXTYPE_INT ); }

	void AddDdxEntry( const char* szName, void* ptr, int type );

	BOOL DdxLoad();
	BOOL ReloadFromDdx();
	BOOL Write(){return TRUE;}
};

}//namespace mwlmfc

#endif//__MfcIniManager_H__