#ifndef __SFJP_MYU__AGH_DEFS_H__
#define __SFJP_MYU__AGH_DEFS_H__

#ifndef __AGH_MY_ALLOCATOR
	#define __AGH_MY_ALLOCATOR std::allocator
#endif
//#define _AGH_ALLOCATOR(_Ty)		std::allocator<_Ty>
#define _AGH_ALLOCATOR(_Ty)		__AGH_MY_ALLOCATOR<_Ty>

//	Types
//typedef std::string		_agh_string;
typedef std::basic_string<char, std::char_traits<char>, _AGH_ALLOCATOR(char) >
							_agh_string;
#define _AGH_STRING			std::string

#define _AGH_VECTOR(_Ty)	std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >
//#define _agh_vector(_Ty)	std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >

#define _AGH_MAP(_K,_Ty)	std::map<_K, _Ty, _AGH_ALLOCATOR(_Ty) >
//#define _agh_map(_K,_Ty)	std::map<_K, _Ty, _AGH_ALLOCATOR(_Ty) >

typedef _AGH_MAP(_agh_string,_agh_string) _agh_map_strstr;

#define _AGH_LIST(_Ty)		std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >
//#define _agh_list(_Ty)		std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >

//typedef unsigned long _DWORD;
typedef unsigned long AGH_DWORD;
typedef unsigned long AGH_COLOR;
typedef unsigned char AGH_BYTE;
typedef unsigned long AGHDWORD;
typedef unsigned long AGHCOLOR;
typedef unsigned char AGHBYTE;

//	RECT
typedef struct _tagAGH_RECT
{
	long    left;
	long    top;
	long    right;
	long    bottom;

	_tagAGH_RECT(){
		left = top = right = bottom = 0;
	}
	_tagAGH_RECT(long left_in, long top_in, long right_in, long bottom_in){
		left = left_in;
		top = top_in;
		right = right_in;
		bottom = bottom_in;
	}
} _AGH_RECT, _AGH_RECT;

//	POINT
typedef struct _tagAGH_POINT
{
    long	x;
    long	y;

	_tagAGH_POINT(){ x = y = 0; }
	_tagAGH_POINT(long x_in, long y_in){
		x = x_in;
		y = y_in;
	}
} _AGH_POINT, AGH_POINT;

class CAghAnyClassBase {};


///// COLOR Types ///////////////////////////////////////////////////////////////////////////////

#define AGH_FILTER_BYTE(x)		((x)&0xff)
#define AGHCOLOR_ARGB(a,r,g,b)	((agh::AGHCOLOR)(\
	(((a)&0xff)<<24)|\
	(((r)&0xff)<<16)|\
	(((g)&0xff)<<8)|\
	(((b)&0xff))))
#define AGHCOLOR_RGB(r,g,b)		AGHCOLOR_ARGB(0xff,r,g,b)
#define AGHCOLOR_XRGB(r,g,b)	AGHCOLOR_ARGB(0xff,r,g,b)

inline AGH_BYTE AghWrapByte( int x )
{
	if ( x > 255 )
		return 255;
	if ( x < 0 )
		return 0;
	return x;
}

////////////////////////////////
//
//		}N
//
#define AGHCOLOR_A(a)			((agh::AGHCOLOR)((((a)&0xff)<<24)|(0x00ffffff)))
#define AGHCOLORW_A(a)			AGHCOLOR_A(AghAghWrapByte(a))
#define AGHCOLORW_ARGB(a,r,g,b)	AGHCOLOR_ARGB(AghAghWrapByte(a),AghAghWrapByte(r),AghAghWrapByte(g),AghAghWrapByte(b))
#define AGHCOLORW_RGBA(r,g,b,a)	AGHCOLOR_RGBA(AghWrapByte(r),AghWrapByte(g),AghWrapByte(b),AghWrapByte(a))
#define AGHCOLORW_XRGB(r,g,b)	AGHCOLOR_XRGB(AghWrapByte(r),AghWrapByte(g),AghWrapByte(b))

//	̂[
#define AGHCOLOR_MONO(v)		AGHCOLOR_XRGB(v,v,v)
#define AGHCOLORW_MONO(v)		AGHCOLOR_XRGB(AghWrapByte(v),AghWrapByte(v),AghWrapByte(v))

#define AGHCOLOR_BLUE			((agh::AGHCOLOR)0xff0000ff)
#define AGHCOLOR_GREEN			((agh::AGHCOLOR)0xff00ff00)
#define AGHCOLOR_RED			((agh::AGHCOLOR)0xffff0000)
#define AGHCOLOR_PINK			((agh::AGHCOLOR)0xffff00ff)
#define AGHCOLOR_CYAN			((agh::AGHCOLOR)0xff00ffff)
#define AGHCOLOR_YELLOW			((agh::AGHCOLOR)0xffffff00)
#define AGHCOLOR_WHITE			((agh::AGHCOLOR)0xffffffff)
#define AGHCOLOR_BLACK			((agh::AGHCOLOR)0xff000000)
#define AGHCOLOR_FULLWHITE		((agh::AGHCOLOR)0xffffffff)	//	AGHCOLOR_WHITEɓ

#define AGHCOLOR_NABLUE			((agh::AGHCOLOR)0x000000ff)
#define AGHCOLOR_NAGREEN		((agh::AGHCOLOR)0x0000ff00)
#define AGHCOLOR_NARED			((agh::AGHCOLOR)0x00ff0000)
#define AGHCOLOR_NAPINK			((agh::AGHCOLOR)0x00ff00ff)
#define AGHCOLOR_NACYAN			((agh::AGHCOLOR)0x0000ffff)
#define AGHCOLOR_NAYELLOW		((agh::AGHCOLOR)0x00ffff00)
#define AGHCOLOR_NAWHITE		((agh::AGHCOLOR)0x00ffffff)
#define AGHCOLOR_NABLACK		((agh::AGHCOLOR)0x00000000)

#define AGHCOLOR_FULLALPHA		((agh::AGHCOLOR)0xff000000)
#define AGHCOLOR_ZEROALPHA		((agh::AGHCOLOR)0x00000000)

//	tB^[
#define AGHCOLOR_ZEROALPHA_FILTER(COLOR)	(COLOR&0x00ffffff)
#define AGHCOLOR_FULLALPHA_FILTER(COLOR)	(COLOR|0xff000000)

#define AGHCOLOR_GETNAMASK(COLOR)		(COLOR&0x00ffffff)
#define AGHCOLOR_GETNRMASK(COLOR)		(COLOR&0xff00ffff)
#define AGHCOLOR_GETNGMASK(COLOR)		(COLOR&0xffff00ff)
#define AGHCOLOR_GETNBMASK(COLOR)		(COLOR&0xffffff00)

#define AGHCOLOR_GETAMASK(COLOR)		(COLOR&0xff000000)
#define AGHCOLOR_GETRMASK(COLOR)		(COLOR&0x00ff0000)
#define AGHCOLOR_GETGMASK(COLOR)		(COLOR&0x0000ff00)
#define AGHCOLOR_GETBMASK(COLOR)		(COLOR&0x000000ff)

#define AGHCOLOR_GETA(COLOR)			(AGHCOLOR_AMASK(COLOR)>>24)
#define AGHCOLOR_GETR(COLOR)			(AGHCOLOR_RMASK(COLOR)>>16)
#define AGHCOLOR_GETG(COLOR)			(AGHCOLOR_GMASK(COLOR)>>8)
#define AGHCOLOR_GETB(COLOR)			(AGHCOLOR_BMASK(COLOR))

#define AGHCOLOR_CHANGEA(COLOR,A)		(AGHCOLOR_GETNAMASK(COLOR)|(A<<24))
#define AGHCOLOR_CHANGER(COLOR,R)		(AGHCOLOR_GETNAMASK(COLOR)|(R<<16))
#define AGHCOLOR_CHANGEG(COLOR,G)		(AGHCOLOR_GETNAMASK(COLOR)|(G<<8))
#define AGHCOLOR_CHANGEB(COLOR,B)		(AGHCOLOR_GETNAMASK(COLOR)|(B))

///// Vector Types ///////////////////////////////////////////////////////////////////////////////

typedef float pos3d_t;

//	AGH_VECTOR2
typedef struct _AGH_XY
{
	pos3d_t x;
	pos3d_t y;

	_AGH_XY(){
		y = x = 0;
	}
	_AGH_XY( pos3d_t x_in, pos3d_t y_in ){
		x = x_in;
		y = y_in;
	}
}
AGH_XY, AGH_VECTOR2, AGHVECTOR2;

//	AGH_VECTOR3
typedef struct _AGH_XYZ
{
	pos3d_t x;
	pos3d_t y;
	pos3d_t z;

	_AGH_XYZ(){
		z = y = x = 0;
	}
	_AGH_XYZ( pos3d_t x_in, pos3d_t y_in, pos3d_t z_in ){
		x = x_in;
		y = y_in;
		z = z_in;
	}
}
AGH_XYZ, AGH_VECTOR, AGH_VECTOR3, AGHVECTOR3;

////////////////////////////////////////////////////////////////////////////

//	Single Inheritance
class _CAghCallbackDummyBaseSI{};
typedef _CAghCallbackDummyBaseSI _CAghCallbackDummyBase;

//	Multiple Inheritance
class _CAghCallbackDummyBaseMI_A{};class _CAghCallbackDummyBaseMI_B{};
class _CAghCallbackDummyBaseMI : public _CAghCallbackDummyBaseMI_A, public _CAghCallbackDummyBaseMI_B{};


#endif//__SFJP_MYU__AGH_DEFS_H__
