#ifndef __SFJP_MYU__AGH_ControlBase_H__
#define __SFJP_MYU__AGH_ControlBase_H__

//	m_nTypeFlg
#define AGH_CONTROL_TYPEFLG_DEFAULT		(0x00000000)
#define AGH_CONTROL_TYPEFLG_VISUAL		(0x00000010)


/////////////////////////////////////////////////////////
//	Control Types

#define AGH_CONTROL_TYPE_NULL			(0x00000000)

#define AGH_CONTROL_TYPE_ROOT			(0x00010100)

#define AGH_CONTROL_TYPE_WINDOW			(0x00011001)
#define AGH_CONTROL_TYPE_BUTTON			(0x00011020)
#define AGH_CONTROL_TYPE_LABEL			(0x00011030)
#define AGH_CONTROL_TYPE_COMBO_BOX		(0x00011200)
#define AGH_CONTROL_TYPE_LIST_CTRL		(0x00011220)
#define AGH_CONTROL_TYPE_TREE_CTRL		(0x00011224)

#define AGH_CONTROL_TYPE_IMAGE			(0x00012060)

#define AGH_CONTROL_TYPE_IMPL_FACTORY	(0x00018100)

#define AGH_CONTROL_TYPE_USER_FIRST		(0x20000000)
//	********** User Defined **********
#define AGH_CONTROL_TYPE_USER_LAST		(0x5FFFFFFF)
// reserved: 0x60000000 - 0xffffffff


/////////////////////////////////////////////////////////
//	Foundation Control Types - {Rg[

#define AGH_FOUNDA_CTRL_NORMAL			(0x00000000)
#define AGH_FOUNDA_CTRL_VISUAL			(0x00000010)


/////////////////////////////////////////////////////////
//	Variable Keys
/*
#define AGH_VALKEY_NOINHERIT			(0x00000000)
#define AGH_VALKEY_NOTINHERIT			(0x00000000)
#define AGH_VALKEY_INHERIT				(0x80000000)
*/
//	2009/05/03  tɂ[v̎i0x80000000breakj
#define AGH_VALKEY_INHERIT				(0x00000000)
#define AGH_VALKEY_NOINHERIT			(0x80000000)
#define AGH_VALKEY_NOTINHERIT			(0x80000000)

//----------

#define AGH_VALKEY_NULL					(0x00000000)

#define AGH_VALKEY_FOUNDA_CONTROL		(AGH_VALKEY_NOINHERIT + 0x00008008)		//	Not Inherit.
#define AGH_VALKEY_FOUNDA_CTRL			(AGH_VALKEY_NOINHERIT + 0x00008008)		//	Not Inherit. (Alias)
#define AGH_VALKEY_CONTROL_TYPE			(AGH_VALKEY_NOINHERIT + 0x00008010)		//	Not Inherit.

#define AGH_VALKEY_ROOT					(AGH_VALKEY_INHERIT +   0x00010100)		//	Inherit to sub control.
#define AGH_VALKEY_PARENT				(AGH_VALKEY_NOINHERIT + 0x00010200)		//	Not Inherit.
#define AGH_VALKEY_CHILD				(AGH_VALKEY_NOINHERIT + 0x00010210)		//	Not Inherit.
#define AGH_VALKEY_CHILD_FIRST			(AGH_VALKEY_NOINHERIT + 0x00010211)		//	Not Inherit.
#define AGH_VALKEY_CHILD_LAST			(AGH_VALKEY_NOINHERIT + 0x00010212)		//	Not Inherit.
#define AGH_VALKEY_IMPL_FACTORY			(AGH_VALKEY_INHERIT +   0x00010504)		//	Inherit to sub control.

#define AGH_VALKEY_CONTROLS_FIRST		(AGH_VALKEY_INHERIT + 0x00040000)		//	Inherit to sub control.
#define AGH_VALKEY_WINDOW				(AGH_VALKEY_CONTROLS_FIRST + 0200)		//	Inherit to sub control.
#define AGH_VALKEY_CONTROLS_LAST		(AGH_VALKEY_INHERIT + 0x000FFFFF)		//	Inherit to sub control.

#define AGH_VALKEY_USER_FIRST			(0x20000000)
//	********** User Defined **********
#define AGH_VALKEY_USER_LAST			(0x5FFFFFFF)
// reserved: 0x60000000 - 0x7fffffff

/*
#define AGH_VALKEY_NOINHERIT			(0x80000000)

#define AGH_VALKEY_NOINHERIT_USER_FIRST	(AGH_VALKEY_NOINHERIT+AGH_VALKEY_USER_FIRST)
#define AGH_VALKEY_NOINHERIT_USER_LAST	(AGH_VALKEY_NOINHERIT+AGH_VALKEY_USER_LAST)
*/

#define AGH_VALKEY_INVALID				(0xFFFFFFFF)

/////////////////////////////////////////////////////////


/*************************************************************************************************/
/*                                                                                               */
/*  CControlBase                                                                                 */
/*                                                                                               */
/*************************************************************************************************/

class CVisualControlBase;

//	Control base class : eRg[NX
class CControlBase : public agh::COtherEventBase
{
//	####### ^錾 : Types Definition #######
public:
	//typedef std::vector<agh::CControlBase*> CHILD_CTRL_ARY_TYPE;
	//typedef std::vector<agh::CControlBase*>::iterator CHILD_CTRL_ARY_ITERATOR;
	//typedef _agh_vector<agh::CControlBase*> CHILD_CTRL_ARY_TYPE;
	//typedef _agh_vector<agh::CControlBase*>::iterator CHILD_CTRL_ARY_ITERATOR;
	typedef _AGH_VECTOR(agh::CControlBase*) CHILD_CTRL_ARY_TYPE;
	typedef _AGH_VECTOR(agh::CControlBase*)::iterator CHILD_CTRL_ARY_ITERATOR;
	//typedef std::list<agh::CControlBase*> CHILD_CTRL_ARY_TYPE;

//	$$$$$$$ protectedoϐn $$$$$$$
protected:
	CHILD_CTRL_ARY_TYPE m_ctrlPtrAry;	//	qRg[Qi|C^zj: Child Control List (pointer array)
	//agh::CControlBase* m_pParent;			//	eRg[̃|C^ : Parent Control Pointer
	_agh_string m_controlId;			//	SRg[ӂɎʉ\ID : Unique ID on All Control

	//std::map<int,int> m_nmap;
	//std::map<std::string,std::string> m_smap;
	//_agh_map<int,int> m_nmap;
	//_agh_map_strstr m_smap;
	//_AGH_MAP(int,int) m_valMapInt;
	typedef std::map<unsigned int,int> VAL_MAP_INT;
	typedef std::map<std::string,std::string> VAL_MAP_STR;
	VAL_MAP_INT m_valMapInt;
	VAL_MAP_STR m_valMapStr;

	_agh_string m_strControlTypeName;	//	Rg[ʖ

	int m_nTypeFlg;				//	Control type flags (AGH_CONTROL_TYPEFLG_... 's OR)
	/*int m_nTypeFlgUser1;		//	User Control type flags. (1)
	int m_nTypeFlgUser2;		//	User Control type flags. (2)
	int m_nTypeFlgUser3;		//	User Control type flags. (3)*/

	///////////////////////////////////////////////////////////////////////

	bool FindValMapInt(int nKey, int* pResult){
		VAL_MAP_INT::iterator it = m_valMapInt.find(nKey);
		if ( it == m_valMapInt.end() )
			return false;
		else{
			*pResult = it->second;
			return true;
		}
	}
	int FindValMapInt(int nKey){
		VAL_MAP_INT::iterator it = m_valMapInt.find(nKey);
		if ( it == m_valMapInt.end() )
			return NULL;
		else
			return it->second;
	}
	virtual int StrKeyNameToIntKey(const char* szKey){ return AGH_VALKEY_INVALID; }

//	####### Ce[^n(J) #######
public:
	/*
	typedef CHILD_CTRL_ARY_TYPE::iterator ctrl_iterator;
	typedef CHILD_CTRL_ARY_TYPE::iterator citerator;
	typedef CHILD_CTRL_ARY_TYPE::iterator cIterator;
	typedef CHILD_CTRL_ARY_TYPE::iterator cItr;
	typedef CHILD_CTRL_ARY_TYPE::iterator citr;

	ctrl_iterator cbegin(){ return m_ctrlPtrAry.begin(); }
	ctrl_iterator cend(){ return m_ctrlPtrAry.end(); }
	*/

	class ctrl_iterator2
	{
	private:
		CHILD_CTRL_ARY_ITERATOR m_it;
	public:
		ctrl_iterator2(CHILD_CTRL_ARY_ITERATOR it_in){ m_it = it_in; }
		void operator ++ (){ m_it++; }
		void operator ++ (int){ m_it++; }
		int operator != (ctrl_iterator2 it_in){ return m_it != it_in.m_it ? 1 : 0; }
		agh::CControlBase* operator -> (){ return *m_it; }
		agh::CControlBase* get(){ return *m_it; }
	};
	class vctrl_iterator2
	{
	private:
		CHILD_CTRL_ARY_ITERATOR m_it;
		CHILD_CTRL_ARY_ITERATOR m_it_end;

		void _nv_skip(){
			//for(; m_it != m_it.end(); m_it++)
			for(; m_it != m_it_end; m_it++)
			{
				if ( (*m_it)->IsVisualControl() ){
					//m_it = m_it_end; // 2009/05/17 VisualłȂꍇɖ[vɊׂ <- Ⴄ 2009/05/18
					break;
					//return m_it;
				}
			}
			//return m_it;	//	 m_ctrlPtrAry.end() B
		}

	public:
		vctrl_iterator2(CHILD_CTRL_ARY_ITERATOR it_in){ m_it = it_in; }
		vctrl_iterator2(CHILD_CTRL_ARY_ITERATOR it_in, CHILD_CTRL_ARY_ITERATOR it_end_in){
			m_it = it_in;	//	TODO: oOĂ
			m_it_end = it_end_in;

			_nv_skip();
		}
		void operator ++ (int){ operator ++(); }
		void operator ++ (){
			m_it++;	//	2009/05/18 ꂪ

			_nv_skip();
			/*
			//for(; m_it != m_it.end(); m_it++)
			for(; m_it != m_it_end; m_it++)
			{
				if ( (*m_it)->IsVisualControl() ){
					//m_it = m_it_end; // 2009/05/17 VisualłȂꍇɖ[vɊׂ <- Ⴄ 2009/05/18
					break;
					//return m_it;
				}
			}
			//return m_it;	//	 m_ctrlPtrAry.end() B
			*/
		}
		int operator != (vctrl_iterator2 it_in){ return m_it != it_in.m_it ? 1 : 0; }
		agh::CVisualControlBase* operator -> (){ return (agh::CVisualControlBase*)*m_it; }
		agh::CVisualControlBase* get(){ return (agh::CVisualControlBase*)*m_it; }
	};

	typedef ctrl_iterator2 ctrl_iterator;
	typedef ctrl_iterator citerator;
	typedef ctrl_iterator cIterator;
	typedef ctrl_iterator cItr;
	typedef ctrl_iterator citr;

	typedef vctrl_iterator2 vctrl_iterator;
	typedef vctrl_iterator vciterator;
	typedef vctrl_iterator vcIterator;
	typedef vctrl_iterator vcItr;
	typedef vctrl_iterator vcitr;

	ctrl_iterator cbegin(){ return ctrl_iterator2(m_ctrlPtrAry.begin()); }
	ctrl_iterator cend(){ return ctrl_iterator2(m_ctrlPtrAry.end()); }
	vctrl_iterator vcbegin(){ return vctrl_iterator2(m_ctrlPtrAry.begin(), m_ctrlPtrAry.end()); }
	vctrl_iterator vcend(){ return vctrl_iterator2(m_ctrlPtrAry.end()); }

	int _cpp(int &i){
		i++;
		for(; i<((int)m_ctrlPtrAry.size()); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			break;
		}
		return i;
	}
	int _vcpp(int &i){
		i++;
		for(; i<((int)m_ctrlPtrAry.size()); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			if ( !p_->IsVisualControl() )
				continue;
			break;
		}
		return i;
	}
	/*int _cpp(int i_in){
		for(int i=i_in; i<m_ctrlPtrAry.size(); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			break;
		}
		return i;
	}
	int _vcpp(int i_in){
		for(int i=i_in; i<m_ctrlPtrAry.size(); i++)
		{
			agh::CControlBase *p_ = m_ctrlPtrAry[i];
			if ( p_ == NULL )
				continue;
			if ( !p_->IsVisualControl() )
				continue;
			break;
		}
		return i;
	}*/

protected:
#define _AGH_CTRL_LOOP_START	for(citr cit=cbegin(); cit != cend(); cit++){
#define _AGH_CTRL_LOOP_END		}

//	######## I[o[Ch\ȃCxgnh : Overridable Event Handlers ########
_AGH_EVENT_ACCESS_MODIFIER:
	virtual bool OnInit(){return true;}		//	falseԂƃvOI
	virtual bool OnFrame(){return true;}	//	falseԂƃvOI

	virtual void OnRegist(){}
	virtual void OnUnregist(){ SetParentControl(NULL); /*m_pParent = NULL;*/ }


//	$$$$$$$ ĂяopCxgnh $$$$$$$
protected:
	virtual bool _OnFrame(){
		//	ƎqAǂŏ낤EEEH
		if ( this->OnFrame() != true )
			return false;
		if ( this->OnFrameChilds() != true )
			return false;
		return true;
		/*
		_AGH_CTRL_LOOP_START
			if ( cit->_OnFrame() != true )
				break;
		_AGH_CTRL_LOOP_END
		*/
	}
	virtual bool OnFrameChilds(){
		_AGH_CTRL_LOOP_START
			if ( cit->_OnFrame() != true )
				break;
		_AGH_CTRL_LOOP_END
		return true;
	}	

//	######### OĂяoWIȂ̑̃\bh #########
public:
	//	RXgN^
	CControlBase(){
		m_nTypeFlg = 0;

		SetValInt(AGH_VALKEY_FOUNDA_CTRL, AGH_FOUNDA_CTRL_NORMAL);
		SetValInt(AGH_VALKEY_INHERIT, 0);
		SetValInt(AGH_VALKEY_NOINHERIT, 0);
	}
	CControlBase(int nTypeFlg){
		m_nTypeFlg = nTypeFlg;

		SetValInt(AGH_VALKEY_FOUNDA_CTRL, AGH_FOUNDA_CTRL_NORMAL);
		SetValInt(AGH_VALKEY_INHERIT, 0);
		SetValInt(AGH_VALKEY_NOINHERIT, 0);
	}
	virtual ~CControlBase(){}	//	fXgN^ƌĂ΂邽߂̑΍

	///////////////////////////////////////////////////////////////////////////////

	//	Rg[̓o^
	virtual void RegistSubControl(agh::CControlBase* pControl){
		m_ctrlPtrAry.push_back(pControl);

		//	2009/04/05
		pControl->SetParentControl(this);
		pControl->OnRegist();
		//pControl->OnRegist(this);
	}

	//	Rg[̓o^
	virtual void RegistSubControl(agh::CControlBase &rControl){
		m_ctrlPtrAry.push_back(&rControl);

		//	2009/04/05
		rControl.SetParentControl(this);
		rControl.OnRegist();
		//pControl->OnRegist(this);
	}
	virtual void RegistControl(agh::CControlBase &rControl){ RegistSubControl(rControl); }
	virtual void RegistControl(agh::CControlBase* pControl){ RegistSubControl(pControl); }

	
	//virtual void UnegistSubControl(agh::CControlBase* pControl)
	//virtual void UnegistSubControl(agh::CControlBase &rControl)

	virtual void UnegistSubControl(int i){
		//	2009/04/05
		//m_ctrlPtrAry[i]->SetParentControl(NULL);
		m_ctrlPtrAry[i]->OnUnregist();

		m_ctrlPtrAry[i] = NULL;
	}
	virtual void UnegistControl(int i){ UnegistSubControl(i); }

	///////////////////////////////////////////////////////////////////////////////

	virtual void SetValInt(int nKey, int nVal){ m_valMapInt[nKey] = nVal; }
	//virtual void SetValInt(const char* szKey, int nVal){ ; }	//	ĂȂΏNULL
	void SetValPtr(int nKey, void* ptr){ SetValInt(nKey, (int)ptr); }
	//void SetValPtr(const char* szKey, void* ptr){ SetValInt(szKey, (int)ptr); }

	virtual int GetValInt(int nKey){ return FindValMapInt(nKey); }
	//virtual int GetValInt(const char* szKey){ return NULL; }	//	ĂȂΏNULL
	void* GetValPtr(int nKey){ return (void*)GetValInt(nKey); }
	//void* GetValPtr(const char* szKey){ return (void*)GetValInt(szKey); }

	VAL_MAP_INT& GetIntValMap(){ return m_valMapInt; }
	VAL_MAP_STR& GetStrValMap(){ return m_valMapStr; }

	///////////////

	virtual bool IsVisualControl(){ return m_nTypeFlg&AGH_CONTROL_TYPEFLG_VISUAL ? true : false; }

	bool IsVisualCtrl(){
		return GetValInt(AGH_VALKEY_FOUNDA_CTRL) == AGH_FOUNDA_CTRL_VISUAL ? true : false; }
	bool IsVisual(){
		return GetValInt(AGH_VALKEY_FOUNDA_CTRL) == AGH_FOUNDA_CTRL_VISUAL ? true : false; }

	//virtual void SetParentControl(agh::CControlBase* pParentControl){ m_pParent = pParentControl; }
	//virtual void SetParentControl(agh::CControlBase* pParentControl){ m_valMapInt[AGH_VALKEY_PARENT] = (int)pParentControl; }
	virtual void SetParentControl(agh::CControlBase* pParentControl){
		m_valMapInt[AGH_VALKEY_PARENT] = (int)pParentControl;
	
//#ifdef AGH_VALKEY_NOINHERIT == 0
		VAL_MAP_INT &pivm = pParentControl->GetIntValMap();
		VAL_MAP_INT::iterator it = pivm.begin();
		for(; it != pivm.end() ; it++)
		{
			//if ( it->first >= AGH_VALKEY_INHERIT ) <- ?
			//if ( ((unsigned int)it->first) >= ((unsigned int)AGH_VALKEY_NOINHERIT) )
			if ( it->first >= AGH_VALKEY_NOINHERIT )	//	first̂unsignedɂȂ̂ŃLXgsvȂ͂
				break;

			m_valMapInt[it->first] = it->second;
		}

/* String: 
		VAL_MAP_STR &psvm = pParentControl->GetStrValMap();
		VAL_MAP_STR::iterator it2 = psvm.begin();
		for(; it2 != psvm.end() ; it2++)
		{
			if ( it2->first >= AGH_VALKEY_INHERIT )
				break;

			m_valMapStr[it2->first] = it2->second;
		}*/

		/*VAL_MAP_INT &pivm = pParentControl->GetIntValMap();
		m_valMapInt.insert(pivm.find(AGH_VALKEY_INHERIT), pivm.find(AGH_VALKEY_NOINHERIT));*/

		//m_valMapInt = pParentControl->GetIntValMap();
		//m_valMapStr = pParentControl->GetStrValMap();
	}
	virtual agh::CControlBase* GetParentControl(){ return (agh::CControlBase*)GetValPtr(AGH_VALKEY_PARENT); }
	//virtual void OnRegist(agh::CControlBase* pParentControl){ m_pParent = pParentControl; }

	///////////////////////////////////////////////////////////////////////////////

	virtual void* GetInternalPtr(){ return NULL; }
	void* GetInternal(){ return GetInternalPtr(); }
};






//#################################################################################################

//#################################################################################################

//#################################################################################################

//#################################################################################################



/*************************************************************************************************/
/*                                                                                               */
/*  CVisualControlBase                                                                           */
/*                                                                                               */
/*************************************************************************************************/

#define AGH_CONTROL_OPTION_NULL						(0)
#define AGH_CONTROL_OPTION_DRAGGING_NO_OVER_PARENT	(1)

#define AGH_CONTROL_ALIGN_LEFT			(0x00)
#define AGH_CONTROL_ALIGN_RIGHT			(0x01)
#define AGH_CONTROL_ALIGN_CENTER		(0x02)
#define AGH_CONTROL_ALIGN_TOP			(0x10)
#define AGH_CONTROL_ALIGN_BOTTOM		(0x11)
#define AGH_CONTROL_ALIGN_VCENTER		(0x12)
#define _AGH_CONTROL_ALIGN_HFILTER(a)	((a)&0x0f)
#define _AGH_CONTROL_ALIGN_VFILTER(a)	((a)&0xf0)

//	\nRg[NX
class CVisualControlBase : public agh::CControlBase, public agh::CMouseEventBase, public agh::COtherVisualEventBase {
protected:
	//	Q (protected member variable)
	_AGH_RECT m_rect;			//	̃IuWFNg̋` : This Object Client Rect
	AGH_COLOR m_color;			//	F
	//float m_fCenterX;			//	S0.5fBftHgl0.5fB}CiXƂ1.0fȏw肷ƁA(s֑)
	//float m_fCenterY;			//	dS摜͈̔͊OƌƂɂȂ܂
	/*	₢EEEImage̕ɂ񂾂āEEEiႤ
	float m_fAngle;				//	]pxB0`360̓x : Rotation Angle
	float m_fScaleX;			//	kځB1.0fŌ̃TCYiftHgj
	float m_fScaleY;			//	kځB1.0fŌ̃TCYiftHgj
	*/
	bool m_bCentering;

	//	p[^n
	bool m_bDragMovable;		//	hbOɂړ\
	bool m_bDragNoOverParentRect;//	hbOɂĐe̋`I[o[Ȃ悤ɂ邩
	//_DWORD m_dwOptions;		//	IuVQ

	//	p[^֘A\bh
	bool IsNoOverParentRect(){ return m_bDragNoOverParentRect; }

private:
	//	hbOɊ֘Aϐ
	bool m_bOnDragging;			//	hbO : is Now Dragging
	int m_nMouseDownX;			//	}EXDownʒuY : Mouse Downed Position X
	int m_nMouseDownY;			//	}EXDownʒuY : Mouse Downed Position Y
	_AGH_RECT m_dragOldRect;	//	hbOŐ`iʒuj: Drag Prev Rect (Position Information)

	void SetVisualControlFlg(){ SetValInt(AGH_VALKEY_FOUNDA_CTRL, AGH_FOUNDA_CTRL_VISUAL); }

_AGH_EVENT_ACCESS_MODIFIER:
	//	I[o[Ch\ : Overridable Methods
	virtual void OnDraw(){}

	//////////////////////////////////////////////////////////

_AGH_EVENT_ACCESS_MODIFIER:
	//	Drag Movable
	//virtual void _OnLButtonDown(int x, int y){
	virtual void OnLButtonDown(int x, int y){
		if (m_bDragMovable){
			m_bOnDragging = true;
			m_dragOldRect = m_rect;
		}
		m_nMouseDownX = x;
		m_nMouseDownY = y;
	}
	virtual void OnLButtonUp(int x, int y){
		if (m_bDragMovable){
			m_bOnDragging = false;
		}
	}
	virtual void OnLButtonUpOuter(int x, int y){
		if (m_bDragMovable){
			m_bOnDragging = false;
		}
	}
	virtual void OnMouseMove(int nPosX, int nPosY, int nMoveX, int nMoveY){
		if (m_bDragMovable && m_bOnDragging){
			/*m_rect.left += nMoveX;
			m_rect.top += nMoveY;
			m_rect.right += nMoveX;
			m_rect.bottom += nMoveY;*/
			m_rect.left = m_dragOldRect.left + nPosX - m_nMouseDownX;
			m_rect.top = m_dragOldRect.top + nPosY - m_nMouseDownY;
			m_rect.right = m_dragOldRect.right + nPosX - m_nMouseDownX;
			m_rect.bottom = m_dragOldRect.bottom + nPosY - m_nMouseDownY;
		}
	}
	virtual void OnMouseMoveOuter(int nPosX, int nPosY, int nMoveX, int nMoveY){
		OnMouseMove(nPosX,nPosY,nMoveX,nMoveY);
	}
	//	Mouse Event Interrupt
	//	(ret = true: Should call Control event Method / false: Should not call Control event Method)
	//	(Al = true: Rg[̃Cxg\bhĂԂׂ / false: Ă΂Ȃׂ)
	virtual bool OnMouseEventInterrupt(agh::CControlBase* pControl, int nPosX, int nPosY, int nMoveX, int nMoveY){return true;}

public:
	//	J (public member variable)

public:
	//	RXgN^
	CVisualControlBase() : agh::CControlBase(AGH_CONTROL_TYPEFLG_VISUAL) {
		AghZeroMemory(&m_rect, sizeof(m_rect));
		m_bDragMovable = false;
		m_bOnDragging = false;
		m_bCentering = false;
		m_color = AGHCOLOR_FULLWHITE;

		SetVisualControlFlg();

		//m_fCenterX = 0.5f;	//	2009/03/31 ͕[
		//m_fCenterY = 0.5f;	//	2009/03/31 ͕[
		/*//	2009/03/25
		m_fAngle = 0.0f;
		m_fScaleX = 1.0f;
		m_fScaleY = 1.0f;*/
	}
	virtual ~CVisualControlBase(){}	//	fXgN^ƌĂ΂邽߂̑΍

	virtual void Draw(){OnDraw();}

	/////////////////////////////////////////////////////////////////

	//	ʒu֘AvpeB\bh
	virtual void SetPos(int x, int y){
		m_rect.left = x;
		m_rect.top = y;
	}
	/*virtual void SetPos(int left, int top, int right, int bottom){
		m_rect.left = left;
		m_rect.top = top;
		m_rect.right = right;
		m_rect.bottom = bottom;
	}*/
	virtual void SetRect(int left, int top, int right, int bottom){
		m_rect.left = left;
		m_rect.top = top;
		m_rect.right = right;
		m_rect.bottom = bottom;
	}
	virtual void SetRect(_AGH_RECT &rect){
		m_rect = rect;
	}
	virtual void Move(int x, int y){
		m_rect.left += x;
		m_rect.top += y;
		m_rect.right += x;
		m_rect.bottom += y;
	}
	virtual _AGH_RECT& GetRect(){ return m_rect; }
	virtual int GetWidth(){ return GetRect().right - GetRect().left; }
	virtual int GetHeight(){ return GetRect().bottom - GetRect().top; }

	//	F֌W
	virtual void SetColor(AGHCOLOR color){ m_color = color; }
	virtual void SetARGB(AGH_BYTE a, AGH_BYTE r, AGH_BYTE g, AGH_BYTE b){ m_color = AGHCOLOR_ARGB(a,r,g,b); }
	virtual void SetRGB(AGH_BYTE r, AGH_BYTE g, AGH_BYTE b){ m_color = AGHCOLOR_RGB(r,g,b); }
	virtual void SetXRGB(AGH_BYTE r, AGH_BYTE g, AGH_BYTE b){ m_color = AGHCOLOR_XRGB(r,g,b); }
	virtual void SetAlpha(AGH_BYTE a){ m_color = AGHCOLOR_CHANGEA(m_color,a); }
	/*virtual void SetColorFilter(AGH_BYTE r, AGH_BYTE g, AGH_BYTE b);
	virtual void SetColorFilter(AGH_BYTE a, AGH_BYTE r, AGH_BYTE g, AGH_BYTE b);
	virtual void SetFilter(AGH_BYTE r, AGH_BYTE g, AGH_BYTE b);
	virtual void SetFilter(AGH_BYTE a, AGH_BYTE r, AGH_BYTE g, AGH_BYTE b);
	virtual void SetFilter(AGH_COLOR argb);
	virtual void SetArgbFilter(AGH_COLOR argb);*/
	virtual AGHCOLOR GetColor(){ return m_color; }

	//	񂹂 (RECTύX) - 
	/*virtual void Align(int align){ m_nAlign = align; }
	virtual void NoAlign(){ Align( _AGH_CONTROL_ALIGN_VFILTER(m_nAlign) + AGH_CONTROL_ALIGN_LEFT ); }
	virtual void AlignNon(){ Align( _AGH_CONTROL_ALIGN_VFILTER(m_nAlign) + AGH_CONTROL_ALIGN_LEFT ); }
	virtual void AlignLeft(){ Align( _AGH_CONTROL_ALIGN_VFILTER(m_nAlign) + AGH_CONTROL_ALIGN_LEFT ); }
	virtual void AlignRight(){ Align( _AGH_CONTROL_ALIGN_VFILTER(m_nAlign) + AGH_CONTROL_ALIGN_RIGHT); }
	virtual void AlignCenter(){ Align( _AGH_CONTROL_ALIGN_VFILTER(m_nAlign) + AGH_CONTROL_ALIGN_CENTER); }
	virtual void AlignTop(){ Align( _AGH_CONTROL_ALIGN_HFILTER(m_nAlign) + AGH_CONTROL_ALIGN_TOP); }
	virtual void AlignBottom(){ Align( _AGH_CONTROL_ALIGN_HFILTER(m_nAlign) + AGH_CONTROL_ALIGN_BOTTOM); }
	virtual void AlignVCenter(){ Align( _AGH_CONTROL_ALIGN_HFILTER(m_nAlign) + AGH_CONTROL_ALIGN_VCENTER); }*/

	//	IvVݒn
	virtual void EnableDrag(bool bFlg=true){ m_bDragMovable = bFlg; }
	virtual void EnableDragMovable(bool bFlg=true){ m_bDragMovable = bFlg; }
	virtual void DisableDrag(){ m_bDragMovable = false; }
	virtual void DisableDragMovable(){ m_bDragMovable = false; }
	virtual void EnableDragNoOverParentRect(bool bFlg=true){ m_bDragNoOverParentRect = bFlg; }
	virtual void DisableDragNoOverParentRect(){ m_bDragNoOverParentRect = false; }
	virtual void EnableCentering(){ m_bCentering = true; }
	virtual void DisableCentering(){ m_bCentering = false; }

	virtual bool IsCentering(){ return m_bCentering; }

protected:
	agh::CVisualControlBase* GetVCtrlPtr(int i){ return (agh::CVisualControlBase*)m_ctrlPtrAry[i]; }
};

typedef CVisualControlBase C2dVisualControlBase, C2DVisualControlBase, CVisibleControlBase;
//typedef CControlBase CVisibleControlBase;
//typedef CControlBase CVisualControlBase;


/*************************************************************************************************/
/*                                                                                               */
/*  C3DVisualControlBase                                                                         */
/*                                                                                               */
/*************************************************************************************************/

#define AGH_CONTROL_OPTION_NULL						(0)
#define AGH_CONTROL_OPTION_DRAGGING_NO_OVER_PARENT	(1)

//	\nRg[NX
class C3dVisualControlBase : public agh::CVisualControlBase {
protected:
	pos3d_t m_x;
	pos3d_t m_y;
	pos3d_t m_z;

	AGHVECTOR3 m_center;	//	S0.5fBftHgl0.5fB}CiXƂ1.0fȏw肷ƁAdSIuWFNg͈̔͊OƌƂɂȂ܂
	AGHVECTOR3 m_rotate;	//	]pxB0`360̓x : Rotation Angle
	AGHVECTOR3 m_scale;		//	kځB1.0fŌ̃TCYiftHgj

public:
	C3dVisualControlBase(){
		m_x = 0.0f;
		m_y = 0.0f;
		m_z = 0.0f;
		m_center.x = m_center.y = m_center.z = 0.5f;
		m_scale.x = m_scale.y = m_scale.z = 1.0f;
	}

	//	ʒu֘AvpeB\bh
	virtual void SetPos(pos3d_t x, pos3d_t y, pos3d_t z){
		m_x = x;
		m_y = y;
		m_z = y;
	}
	virtual void Move(pos3d_t x, pos3d_t y, pos3d_t z){
		m_x += x;
		m_y += y;
		m_z += y;
	}

	//	ʒu֘AvpeB\bh
	virtual void SetAngle(pos3d_t x, pos3d_t y, pos3d_t z){
		m_rotate.x = x;
		m_rotate.y = y;
		m_rotate.z = y;
	}
	virtual void Rotate(pos3d_t x, pos3d_t y, pos3d_t z){
		m_rotate.x += x;
		m_rotate.y += y;
		m_rotate.z += y;
	}
};

typedef C3dVisualControlBase C3DVisualControlBase;

inline bool IsVisualCtrl(agh::CControlBase *pCtrl){
	return pCtrl->GetValInt(AGH_VALKEY_FOUNDA_CTRL) == AGH_FOUNDA_CTRL_VISUAL ? true : false;
}

#endif//__SFJP_MYU__AGH_ControlBase_H__
