#ifndef __MYU_STANDARD_LIBRARY__mslfile_H__
#define __MYU_STANDARD_LIBRARY__mslfile_H__

#include "mslcommon.h"

//	W`
#include <stdlib.h>
#include <io.h>			//	_access
#ifdef WIN32
	#include <windows.h>	//	MAX_PATĤ߂ɁEEE
#endif

////////////////////////////////////////////////////
//
//	֐Q
//
namespace msl
{
	//	t@Cǂݍ
	bool readfile_to_mem( const char* filename, unsigned char* buf, int bufsize );
	unsigned char* readfile_to_mem( const char* filename, int *p_bufsize );
	inline bool ReadFileToMem( const char* szFileName, unsigned char* szBuf, int nBufSize ){
		return readfile_to_mem( szFileName, (unsigned char*)szBuf, nBufSize );}
	/*inline bool readfile_to_mem( const char* filename, char* buf, int bufsize ){
		return readfile_to_mem( filename, (unsigned char*)buf, bufsize );}
	inline bool ReadFileToMem( const char* szFileName, char* szBuf, int nBufSize ){
		return readfile_to_mem( szFileName, (unsigned char*)szBuf, nBufSize );}*/
	inline bool readfile_to_str( const char* filename, char* buf, int bufsize ){
		MslZeroMemory( buf, bufsize );
		return readfile_to_mem( filename, (unsigned char*)buf, bufsize-1 );}

	//	ǂݍ݊gn
	unsigned char* ReadFileAndAlloc( const char* szFileName, int nAllocMargin=0 );	//	allocƌĂnew

	//	t@C
	bool writefile_from_mem( const char* filename, unsigned char* buf, int writesize );
	inline bool WriteFileFromMem( const char* szFileName, unsigned char* szBuf, int nWriteSize ){
		return writefile_from_mem( szFileName, szBuf, nWriteSize ); }

	//	݊gn
	inline bool writefile_from_str( const char* filename, char* buf ){
		return writefile_from_mem( filename, (unsigned char*)buf, strlen(buf) ); }

	//	t@CTCY擾
	long get_filesize( const char* szFileName );

	//	t@C̑ݗL
	inline bool exist_file( const char* file ){
		if ( _access(file, 0 /*0=F_OK*/) == 0 )
			return true;
		else
			return false;
	}
	inline bool is_exist_file( const char* file ){ return exist_file(file); }
	inline bool IsExistFile( const char* szFilePath ){ return exist_file(szFilePath); }

	char* ExtractDirName( const char* szFilePath, char* szOutDir, int nBufSize );
	inline char* ExtractDirName( const char* szFilePath ){
		static char work[MAX_PATH+1];
		return ExtractDirName( szFilePath, work, sizeof(work) );
	}
#define CutDirName		ExtractDirName
#define SplitDirName	ExtractDirName
#define CutDirPath		ExtractDirName

	char* ExtractFileName( const char* szFilePath, char* szOutFileName, int nBufSize );
	inline char* ExtractFileName( const char* szFilePath ){
		static char work[MAX_PATH];
		return ExtractFileName( szFilePath, work, sizeof(work) );
	}
#define CutFileName		ExtractFileName
#define SplitFileName	ExtractFileName

	char* GetExt( const char* szFile, char* szBuf, int nBufSize=4 );
	inline char* GetExt( const char* szFile ){
		static char work[64];
		return GetExt( szFile, work, sizeof(work) );
	}
#define GetFileExt	GetExt
#define GetExtFile	GetExt

	//	2007/07/18
	char* GetNoExt( const char* szFile, char* szOutNotExt, int nBufSize );
	inline const char* GetNoExt( const char* szFile ){
		static char work[MAX_PATH+1];
		return GetNoExt( szFile, work, sizeof(work) );}

	//bool FileStrRpc( const char* szFile, vector<string> &rpcFromList, vector<string> &rpcToList );

}//namespace msl

//////////////////////////////////////////////////////////////////////

NSMSL_START

//	NX錾
class auto_file
{
protected:
	FILE* m_fp;

public:
	//	RXgN^EfXgN^
	auto_file(){ m_fp = NULL; }
	auto_file(FILE* fp){ /*set(fp) <- NG*/ m_fp = fp; }
	virtual ~auto_file(){ close(); }

	///////////////////////////////////////
	
	FILE* open( const char *path, const char *mode )
	{
		close();//Ă
		m_fp = fopen( path, mode );
		return m_fp;
		/*if ( m_fp == NULL )
			return false;
		return true;*/
	}
	
	void close()
	{
		if ( m_fp != NULL &&
			 m_fp != stdout && m_fp != stdin && m_fp != stderr )
		{
			fclose( m_fp );
			m_fp = NULL;
		}
	}

	FILE* open_stdout(){
		set(stdout); return get(); }
	FILE* open_stdin(){
		set(stdin); return get(); }
	FILE* open_stderr(){
		set(stderr); return get(); }

	///////////////////////////////////////
	
	void set(FILE* fp){ close(); m_fp = fp; }
	FILE* get(){ return m_fp; }
};
//typedef auto_file auto_fp;

class auto_fp{
public:
	auto_file af;

public:
	auto_fp(){}
	auto_fp(FILE* fp) : af(fp){}
	virtual ~auto_fp(){}

	bool open( const char *path, const char *mode ){ return ( af.open(path,mode)!= NULL ? true : false ); }
	void close(){af.close();}
	FILE* get(){ return af.get(); }
};

NSMSL_END

#endif//__MYU_STANDARD_LIBRARY__mslfile_H__
