#ifndef __SFJP_MYU__AGH_EffectControl_H__
#define __SFJP_MYU__AGH_EffectControl_H__

class CEffectControlBase : public CControlBase {
protected
	int m_frameCounter;
	int m_nowTimeMs;

	void ResetTime(){
		m_frameCounter = 0;
		m_nowTimeMs = -1;
	}

_AGH_EVENT_ACCESS_MODIFIER:
	virtual bool OnFrame(){
		m_frameCounter++;
		return true;
	}

public:
	CEffectControlBase(){
		ResetTime();
	}

	void SetTimeUnitInFrame(){ m_frameCounter=0; m_nowTimeMs=-1; }
	void SetTimeUnitInMs(){ m_frameCounter=-1; m_nowTimeMs=0; }
};

////////////////////////////////////////////////////////////////////////////////////////////////////

//	F̃tF[h
class CColorFadeController : public CEffectControlBase
{
protected:
	AGHCOLOR m_startColor;
	AGHCOLOR m_endColor;
	int m_nTargetTime;
	AGHCOLOR *m_pTarget;

	//	Cxgnh
_AGH_EVENT_ACCESS_MODIFIER:
	virtual bool OnFrame(){
		if ( m_timeInFrame != 0 ){
			if ( m_timeInFrame <= m_frameCounter ){
				if ( pTargetColor == NULL )
					throw CAghException("CColorFadeController::OnFrame()  Target color not setted. "
						"Please call SetParentControl() or SetTargetColorPtr()");

				CEffectControlBase::OnFrame();
			}
			else
				m_timeInFrame = 0;
		}
		return true;
	}

public:
	//	RXgN^
	CColorFadeController(){
		m_startColor = 0xffffffff;
		m_endColor = 0xffffffff;
		m_nTargetTime = 0;
		m_pTarget = NULL;
	}

	void Fade(AGHCOLOR startColor, AGHCOLOR endColor, int nTime){
		m_startColor = startColor;
		m_endColor = endColor;
		m_nTargetTime = nTime;
		ResetTime();
	}
	void FadeIn(int nTime){ Fade( 0x00ffffff, 0xffffffff, nTime); }
	void FadeOut(int nTime){ Fade( 0xffffffff, 0x00ffffff, nTime); }

	virtual void SetParentControl(CVisualControlBase* pParentControl){
		//TODO: m_pTarget = pParentControl->
		CControlBase::SetParentControl(pParentControl);
	}
	void SetTargetColorPtr(AGHCOLOR *pTargetColor){
		m_pTarget = pTargetColor;
	}
};

//	_
class CBlinkController : public CEffectControlBase {
};

#endif//__SFJP_MYU__AGH_EffectControl_H__